/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.commons.compress.compressors.xz;

import java.io.IOException;
import java.io.InputStream;
import sqldelight.org.apache.commons.compress.MemoryLimitException;
import sqldelight.org.apache.commons.compress.compressors.CompressorInputStream;
import sqldelight.org.apache.commons.compress.utils.CountingInputStream;
import sqldelight.org.apache.commons.compress.utils.IOUtils;
import sqldelight.org.apache.commons.compress.utils.InputStreamStatistics;
import sqldelight.org.tukaani.xz.SingleXZInputStream;
import sqldelight.org.tukaani.xz.XZ;
import sqldelight.org.tukaani.xz.XZInputStream;

public class XZCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public static boolean matches(byte[] signature, int length) {
        if (length < XZ.HEADER_MAGIC.length) {
            return false;
        }
        for (int i = 0; i < XZ.HEADER_MAGIC.length; ++i) {
            if (signature[i] == XZ.HEADER_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    public XZCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated) throws IOException {
        this(inputStream, decompressConcatenated, -1);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated, int memoryLimitInKb) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = decompressConcatenated ? new XZInputStream((InputStream)this.countingStream, memoryLimitInKb) : new SingleXZInputStream((InputStream)this.countingStream, memoryLimitInKb);
    }

    @Override
    public int read() throws IOException {
        try {
            int ret = this.in.read();
            this.count(ret == -1 ? -1 : 1);
            return ret;
        }
        catch (sqldelight.org.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        try {
            int ret = this.in.read(buf, off, len);
            this.count(ret);
            return ret;
        }
        catch (sqldelight.org.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return IOUtils.skip(this.in, n);
        }
        catch (sqldelight.org.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }
}

