/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.dom.svg;

import sqldelight.org.apache.batik.dom.svg.AbstractSVGList;
import sqldelight.org.apache.batik.dom.svg.ListHandler;
import sqldelight.org.apache.batik.dom.svg.SVGItem;
import sqldelight.org.apache.batik.dom.svg.SVGNumberItem;
import sqldelight.org.apache.batik.parser.NumberListHandler;
import sqldelight.org.apache.batik.parser.NumberListParser;
import sqldelight.org.apache.batik.parser.ParseException;
import sqldelight.org.w3c.dom.DOMException;
import sqldelight.org.w3c.dom.Element;
import sqldelight.org.w3c.dom.svg.SVGException;
import sqldelight.org.w3c.dom.svg.SVGNumber;
import sqldelight.org.w3c.dom.svg.SVGNumberList;

public abstract class AbstractSVGNumberList
extends AbstractSVGList
implements SVGNumberList {
    public static final String SVG_NUMBER_LIST_SEPARATOR = " ";

    @Override
    protected String getItemSeparator() {
        return SVG_NUMBER_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGNumberList() {
    }

    @Override
    public SVGNumber initialize(SVGNumber newItem) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.initializeImpl(newItem));
    }

    @Override
    public SVGNumber getItem(int index) throws DOMException {
        return (SVGNumber)((Object)this.getItemImpl(index));
    }

    @Override
    public SVGNumber insertItemBefore(SVGNumber newItem, int index) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.insertItemBeforeImpl(newItem, index));
    }

    @Override
    public SVGNumber replaceItem(SVGNumber newItem, int index) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.replaceItemImpl(newItem, index));
    }

    @Override
    public SVGNumber removeItem(int index) throws DOMException {
        return (SVGNumber)((Object)this.removeItemImpl(index));
    }

    @Override
    public SVGNumber appendItem(SVGNumber newItem) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.appendItemImpl(newItem));
    }

    @Override
    protected SVGItem createSVGItem(Object newItem) {
        SVGNumber l = (SVGNumber)newItem;
        return new SVGNumberItem(l.getValue());
    }

    @Override
    protected void doParse(String value, ListHandler handler) throws ParseException {
        NumberListParser NumberListParser2 = new NumberListParser();
        NumberListBuilder builder = new NumberListBuilder(handler);
        NumberListParser2.setNumberListHandler(builder);
        NumberListParser2.parse(value);
    }

    @Override
    protected void checkItemType(Object newItem) throws SVGException {
        if (!(newItem instanceof SVGNumber)) {
            this.createSVGException((short)0, "expected SVGNumber", null);
        }
    }

    protected static class NumberListBuilder
    implements NumberListHandler {
        protected ListHandler listHandler;
        protected float currentValue;

        public NumberListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startNumberList() throws ParseException {
            this.listHandler.startList();
        }

        @Override
        public void startNumber() throws ParseException {
            this.currentValue = 0.0f;
        }

        @Override
        public void numberValue(float v) throws ParseException {
            this.currentValue = v;
        }

        @Override
        public void endNumber() throws ParseException {
            this.listHandler.item(new SVGNumberItem(this.currentValue));
        }

        @Override
        public void endNumberList() throws ParseException {
            this.listHandler.endList();
        }
    }
}

