/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.dom;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import sqldelight.org.apache.batik.dom.AbstractNode;
import sqldelight.org.apache.batik.dom.events.DocumentEventSupport;
import sqldelight.org.apache.batik.dom.events.EventSupport;
import sqldelight.org.w3c.dom.DOMImplementation;

public abstract class AbstractDOMImplementation
implements DOMImplementation,
Serializable {
    protected static final String RESOURCES = "sqldelight.org.apache.batik.dom.resources.Messages";
    protected final HashMap<String, Object> features = new HashMap();

    protected void registerFeature(String name, Object value) {
        this.features.put(name.toLowerCase(), value);
    }

    protected AbstractDOMImplementation() {
        this.registerFeature("Core", new String[]{"2.0", "3.0"});
        this.registerFeature("XML", new String[]{"1.0", "2.0", "3.0"});
        this.registerFeature("Events", new String[]{"2.0", "3.0"});
        this.registerFeature("UIEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MouseEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("TextEvents", "3.0");
        this.registerFeature("KeyboardEvents", "3.0");
        this.registerFeature("MutationEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MutationNameEvents", "3.0");
        this.registerFeature("Traversal", "2.0");
        this.registerFeature("XPath", "3.0");
    }

    public boolean hasFeature(String feature, String version2) {
        String[] va;
        Object v;
        if (feature == null || feature.length() == 0) {
            return false;
        }
        if (feature.charAt(0) == '+') {
            feature = feature.substring(1);
        }
        if ((v = this.features.get(feature.toLowerCase())) == null) {
            return false;
        }
        if (version2 == null || version2.length() == 0) {
            return true;
        }
        if (v instanceof String) {
            return version2.equals(v);
        }
        for (String aVa : va = (String[])v) {
            if (!version2.equals(aVa)) continue;
            return true;
        }
        return false;
    }

    public Object getFeature(String feature, String version2) {
        if (this.hasFeature(feature, version2)) {
            return this;
        }
        return null;
    }

    public DocumentEventSupport createDocumentEventSupport() {
        return new DocumentEventSupport();
    }

    public EventSupport createEventSupport(AbstractNode n) {
        return new EventSupport(n);
    }

    public void setLocale(Locale l) {
    }

    public Locale getLocale() {
        return Locale.ENGLISH;
    }

    protected void initLocalizable() {
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        if (args.length == 0) {
            return key;
        }
        return key + " " + Arrays.toString(args);
    }
}

