/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.gnu.trove;

import java.util.ConcurrentModificationException;
import sqldelight.gnu.trove.TDoubleObjectHashMap;
import sqldelight.gnu.trove.TIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDoubleObjectIterator<V>
extends TIterator {
    private final TDoubleObjectHashMap<V> _map;

    public TDoubleObjectIterator(TDoubleObjectHashMap<V> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._map.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] values = this._map._values;
        int i = this._index;
        while (i-- > 0 && !TDoubleObjectHashMap.isFull(values, i)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public double key() {
        return this._map._set[this._index];
    }

    public V value() {
        return this._map._values[this._index];
    }

    public V setValue(V val) {
        V old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

