/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.dk.brics.automaton;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import sqldelight.dk.brics.automaton.Automaton;
import sqldelight.dk.brics.automaton.RegExp;

public final class Datatypes {
    private static final Map<String, Automaton> automata;
    private static final Automaton ws;
    private static final Set<String> unicodeblock_names;
    private static final Set<String> unicodecategory_names;
    private static final Set<String> xml_names;
    private static final String[] unicodeblock_names_array;
    private static final String[] unicodecategory_names_array;
    private static final String[] xml_names_array;

    private Datatypes() {
    }

    public static void main(String[] args) {
        long t = System.currentTimeMillis();
        boolean b = Automaton.setAllowMutate(true);
        Datatypes.buildAll();
        Automaton.setAllowMutate(b);
        System.out.println("Storing automata...");
        for (Map.Entry<String, Automaton> e : automata.entrySet()) {
            Datatypes.store(e.getKey(), e.getValue());
        }
        System.out.println("Time for building automata: " + (System.currentTimeMillis() - t) + "ms");
    }

    public static Automaton get(String name) {
        Automaton a = automata.get(name);
        if (a == null) {
            a = Datatypes.load(name);
            automata.put(name, a);
        }
        return a;
    }

    public static boolean isUnicodeBlockName(String name) {
        return unicodeblock_names.contains(name);
    }

    public static boolean isUnicodeCategoryName(String name) {
        return unicodecategory_names.contains(name);
    }

    public static boolean isXMLName(String name) {
        return xml_names.contains(name);
    }

    public static boolean exists(String name) {
        try {
            Datatypes.class.getClassLoader().getResource(name + ".aut").openStream().close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static Automaton load(String name) {
        try {
            URL url = Datatypes.class.getClassLoader().getResource(name + ".aut");
            return Automaton.load(url.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void store(String name, Automaton a) {
        String dir = System.getProperty("sqldelight.dk.brics.automaton.datatypes");
        if (dir == null) {
            dir = "build";
        }
        try {
            a.store(new FileOutputStream(dir + "/" + name + ".aut"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void buildAll() {
        String[] xmlexps = new String[]{"Extender", "[\u3031-\u3035\u309d-\u309e\u30fc-\u30fe\u00b7\u02d0\u02d1\u0387\u0640\u0e46\u0ec6\u3005]", "CombiningChar", "[\u0300-\u0345\u0360-\u0361\u0483-\u0486\u0591-\u05a1\u05a3-\u05b9\u05bb-\u05bd\u05c1-\u05c2\u064b-\u0652\u06d6-\u06dc\u06dd-\u06df\u06e0-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0901-\u0903\u093e-\u094c\u0951-\u0954\u0962-\u0963\u0981-\u0983\u09c0-\u09c4\u09c7-\u09c8\u09cb-\u09cd\u09e2-\u09e3\u0a40-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a70-\u0a71\u0a81-\u0a83\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0b01-\u0b03\u0b3e-\u0b43\u0b47-\u0b48\u0b4b-\u0b4d\u0b56-\u0b57\u0b82-\u0b83\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0c01-\u0c03\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c82-\u0c83\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5-\u0cd6\u0d02-\u0d03\u0d3e-\u0d43\u0d46-\u0d48\u0d4a-\u0d4d\u0e34-\u0e3a\u0e47-\u0e4e\u0eb4-\u0eb9\u0ebb-\u0ebc\u0ec8-\u0ecd\u0f18-\u0f19\u0f71-\u0f84\u0f86-\u0f8b\u0f90-\u0f95\u0f99-\u0fad\u0fb1-\u0fb7\u20d0-\u20dc\u302a-\u302f\u05bf\u05c4\u0670\u093c\u094d\u09bc\u09be\u09bf\u09d7\u0a02\u0a3c\u0a3e\u0a3f\u0abc\u0b3c\u0bd7\u0d57\u0e31\u0eb1\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f97\u0fb9\u20e1\u3099\u309a]", "Digit", "[0-9\u0660-\u0669\u06f0-\u06f9\u0966-\u096f\u09e6-\u09ef\u0a66-\u0a6f\u0ae6-\u0aef\u0b66-\u0b6f\u0be7-\u0bef\u0c66-\u0c6f\u0ce6-\u0cef\u0d66-\u0d6f\u0e50-\u0e59\u0ed0-\u0ed9\u0f20-\u0f29]", "Ideographic", "[\u4e00-\u9fa5\u3021-\u3029\u3007]", "BaseChar", "[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u00ff\u0100-\u0131\u0134-\u013e\u0141-\u0148\u014a-\u017e\u0180-\u01c3\u01cd-\u01f0\u01f4-\u01f5\u01fa-\u0217\u0250-\u02a8\u02bb-\u02c1\u0388-\u038a\u038e-\u03a1\u03a3-\u03ce\u03d0-\u03d6\u03e2-\u03f3\u0401-\u040c\u040e-\u044f\u0451-\u045c\u045e-\u0481\u0490-\u04c4\u04c7-\u04c8\u04cb-\u04cc\u04d0-\u04eb\u04ee-\u04f5\u04f8-\u04f9\u0531-\u0556\u0561-\u0586\u05d0-\u05ea\u05f0-\u05f2\u0621-\u063a\u0641-\u064a\u0671-\u06b7\u06ba-\u06be\u06c0-\u06ce\u06d0-\u06d3\u06e5-\u06e6\u0905-\u0939\u0958-\u0961\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b6-\u09b9\u09dc-\u09dd\u09df-\u09e1\u09f0-\u09f1\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a59-\u0a5c\u0a72-\u0a74\u0a85-\u0a8b\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b36-\u0b39\u0b5c-\u0b5d\u0b5f-\u0b61\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb5\u0bb7-\u0bb9\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c60-\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0ce0-\u0ce1\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d28\u0d2a-\u0d39\u0d60-\u0d61\u0e01-\u0e2e\u0e32-\u0e33\u0e40-\u0e45\u0e81-\u0e82\u0e87-\u0e88\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0eaa-\u0eab\u0ead-\u0eae\u0eb2-\u0eb3\u0ec0-\u0ec4\u0f40-\u0f47\u0f49-\u0f69\u10a0-\u10c5\u10d0-\u10f6\u1102-\u1103\u1105-\u1107\u110b-\u110c\u110e-\u1112\u1154-\u1155\u115f-\u1161\u116d-\u116e\u1172-\u1173\u11ae-\u11af\u11b7-\u11b8\u11bc-\u11c2\u1e00-\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u212a-\u212b\u2180-\u2182\u3041-\u3094\u30a1-\u30fa\u3105-\u312c\uac00-\ud7a3\u0386\u038c\u03da\u03dc\u03de\u03e0\u0559\u06d5\u093d\u09b2\u0a5e\u0a8d\u0abd\u0ae0\u0b3d\u0b9c\u0cde\u0e30\u0e84\u0e8a\u0e8d\u0ea5\u0ea7\u0eb0\u0ebd\u1100\u1109\u113c\u113e\u1140\u114c\u114e\u1150\u1159\u1163\u1165\u1167\u1169\u1175\u119e\u11a8\u11ab\u11ba\u11eb\u11f0\u11f9\u1f59\u1f5b\u1f5d\u1fbe\u2126\u212e]", "Letter", "<BaseChar>|<Ideographic>", "NCNameChar", "<Letter>|<Digit>|[-._]|<CombiningChar>|<Extender>", "NameChar", "<NCNameChar>|:", "Nmtoken", "<NameChar>+", "NCName", "(<Letter>|_)<NCNameChar>*", "Name", "(<Letter>|[_:])<NameChar>*", "QName", "(<NCName>:)?<NCName>", "Char", "[\t\n\r -\ud7ff\ue000-\ufffd]|[\ud800-\udbff][\udc00-\udfff]", "whitespacechar", "[ \t\n\r]"};
        System.out.println("Building XML automata...");
        Map<String, Automaton> t = Datatypes.buildMap(xmlexps);
        Datatypes.putFrom("NCName", t);
        Datatypes.putFrom("QName", t);
        Datatypes.putFrom("Char", t);
        Datatypes.putFrom("NameChar", t);
        Datatypes.putFrom("Letter", t);
        Datatypes.putFrom("whitespacechar", t);
        Datatypes.put(automata, "whitespace", ws);
        String[] uriexps = new String[]{"digit", "[0-9]", "upalpha", "[A-Z]", "lowalpha", "[a-z]", "alpha", "<lowalpha>|<upalpha>", "alphanum", "<alpha>|<digit>", "hex", "<digit>|[a-f]|[A-F]", "escaped", "%<hex><hex>", "mark", "[-_.!~*'()]", "unreserved", "<alphanum>|<mark>", "reserved", "[;/?:@&=+$,\\[\\]]", "uric", "<reserved>|<unreserved>|<escaped>", "fragment", "<uric>*", "query", "<uric>*", "pchar", "<unreserved>|<escaped>|[:@&=+$,]", "param", "<pchar>*", "segment", "<pchar>*(;<param>)*", "path_segments", "<segment>(/<segment>)*", "abs_path", "/<path_segments>", "uric_no_slash", "<unreserved>|<escaped>|[;?:@&=+$,]", "opaque_part", "<uric_no_slash><uric>*", "port", "<digit>*", "IPv4address", "(<digit>{1,3}\\.){3}<digit>{1,3}", "hexseq", "<hex>{1,4}(:<hex>{1,4})*", "hexpart", "<hexseq>|<hexseq>::<hexseq>?|::<hexseq>", "IPv6address", "<hexpart>(:<IPv4address>)?", "toplabel", "<alpha>|(<alpha>(<alphanum>|-)*<alphanum>)", "domainlabel", "<alphanum>|(<alphanum>(<alphanum>|-)*<alphanum>)", "hostname", "(<domainlabel>\\.)*<toplabel>\\.?", "host", "<hostname>|<IPv4address>|\\[<IPv6address>\\]", "hostport", "<host>(:<port>)?", "userinfo", "(<unreserved>|<escaped>|[;:&=+$,])*", "server", "((<userinfo>\\@)?<hostport>)?", "reg_name", "(<unreserved>|<escaped>|[$,;:@&=+])+", "authority", "<server>|<reg_name>", "scheme", "<alpha>(<alpha>|<digit>|[-+.])*", "rel_segment", "(<unreserved>|<escaped>|[;@&=+$,])+", "rel_path", "<rel_segment><abs_path>?", "net_path", "//<authority><abs_path>?", "hier_part", "(<net_path>|<abs_path>)(\\?<query>)?", "relativeURI", "(<net_path>|<abs_path>|<rel_path>)(\\?<query>)?", "absoluteURI", "<scheme>:(<hier_part>|<opaque_part>)", "URI", "(<absoluteURI>|<relativeURI>)?(\\#<fragment>)?"};
        System.out.println("Building URI automaton...");
        Datatypes.putFrom("URI", Datatypes.buildMap(uriexps));
        Datatypes.put(automata, "anyname", Automaton.minimize(Automaton.makeChar('{').concatenate(automata.get("URI").clone()).concatenate(Automaton.makeChar('}')).optional().concatenate(automata.get("NCName").clone())));
        Datatypes.put(automata, "noap", new RegExp("~(@[@%]@)").toAutomaton());
        String[] xsdmisc = new String[]{"_", "[ \t\n\r]*", "d", "[0-9]", "Z", "[-+](<00-13>:<00-59>|14:00)|Z", "Y", "(<d>{4,})&~(0000)", "M", "<01-12>", "D", "<01-31>", "T", "<00-23>:<00-59>:<00-59>|24:00:00", "B64", "[A-Za-z0-9+/]", "B16", "[AEIMQUYcgkosw048]", "B04", "[AQgw]", "B04S", "<B04> ?", "B16S", "<B16> ?", "B64S", "<B64> ?"};
        String[] xsdexps = new String[]{"boolean", "<_>(true|false|1|0)<_>", "decimal", "<_>([-+]?<d>+(\\.<d>+)?)<_>", "float", "<_>([-+]?<d>+(\\.<d>+)?([Ee][-+]?<d>+)?|INF|-INF|NaN)<_>", "integer", "<_>[-+]?[0-9]+<_>", "duration", "<_>(-?P(((<d>+Y)?(<d>+M)?(<d>+D)?(T(((<d>+H)?(<d>+M)?(<d>+(\\.<d>+)?S)?)&~()))?)&~()))<_>", "dateTime", "<_>(-?<Y>-<M>-<D>T<T>(\\.<d>+)?<Z>?)<_>", "time", "<_>(<T>(\\.<d>+)?<Z>?)<_>", "date", "<_>(-?<Y>-<M>-<D><Z>?)<_>", "gYearMonth", "<_>(-?<Y>-<M><Z>?)<_>", "gYear", "<_>(-?<Y><Z>?)<_>", "gMonthDay", "<_>(--<M>-<D><Z>?)<_>", "gDay", "<_>(--<D><Z>?)<_>", "gMonth", "<_>(--<M><Z>?)<_>", "hexBinary", "<_>([0-9a-fA-F]{2}*)<_>", "base64Binary", "<_>(((<B64S><B64S><B64S><B64S>)*((<B64S><B64S><B64S><B64>)|(<B64S><B64S><B16S>=)|(<B64S><B04S>= ?=)))?)<_>", "language", "<_>[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*<_>", "nonPositiveInteger", "<_>(0+|-<d>+)<_>", "negativeInteger", "<_>(-[1-9]<d>*)<_>", "nonNegativeInteger", "<_>(<d>+)<_>", "positiveInteger", "<_>([1-9]<d>*)<_>"};
        System.out.println("Building XML Schema automata...");
        Map<String, Automaton> m = Datatypes.buildMap(xsdmisc);
        Datatypes.putWith(xsdexps, m);
        Datatypes.put(m, "UNSIGNEDLONG", Automaton.makeMaxInteger("18446744073709551615"));
        Datatypes.put(m, "UNSIGNEDINT", Automaton.makeMaxInteger("4294967295"));
        Datatypes.put(m, "UNSIGNEDSHORT", Automaton.makeMaxInteger("65535"));
        Datatypes.put(m, "UNSIGNEDBYTE", Automaton.makeMaxInteger("255"));
        Datatypes.put(m, "LONG", Automaton.makeMaxInteger("9223372036854775807"));
        Datatypes.put(m, "LONG_NEG", Automaton.makeMaxInteger("9223372036854775808"));
        Datatypes.put(m, "INT", Automaton.makeMaxInteger("2147483647"));
        Datatypes.put(m, "INT_NEG", Automaton.makeMaxInteger("2147483648"));
        Datatypes.put(m, "SHORT", Automaton.makeMaxInteger("32767"));
        Datatypes.put(m, "SHORT_NEG", Automaton.makeMaxInteger("32768"));
        Datatypes.put(m, "BYTE", Automaton.makeMaxInteger("127"));
        Datatypes.put(m, "BYTE_NEG", Automaton.makeMaxInteger("128"));
        HashMap<String, Automaton> u = new HashMap<String, Automaton>();
        u.putAll(t);
        u.putAll(m);
        String[] xsdexps2 = new String[]{"Nmtoken2", "<_><Nmtoken><_>", "Name2", "<_><Name><_>", "NCName2", "<_><NCName><_>", "QName2", "<_><QName><_>", "Nmtokens", "<_>(<Nmtoken><_>)+", "NCNames", "<_>(<NCName><_>)+", "Names", "<_>(<Name><_>)+", "unsignedLong", "<_><UNSIGNEDLONG><_>", "unsignedInt", "<_><UNSIGNEDINT><_>", "unsignedShort", "<_><UNSIGNEDSHORT><_>", "unsignedByte", "<_><UNSIGNEDBYTE><_>", "long", "<_>(<LONG>|-<LONG_NEG>)<_>", "int", "<_>(<INT>|-<INT_NEG>)<_>", "short", "<_>(<SHORT>|-<SHORT_NEG>)<_>", "byte", "<_>(<BYTE>|-<BYTE_NEG>)<_>", "string", "<Char>*"};
        Datatypes.putWith(xsdexps2, u);
        System.out.println("Building Unicode block automata...");
        Datatypes.put(automata, "BasicLatin", Automaton.makeCharRange('\u0000', '\u007f'));
        Datatypes.put(automata, "Latin-1Supplement", Automaton.makeCharRange('\u0080', '\u00ff'));
        Datatypes.put(automata, "LatinExtended-A", Automaton.makeCharRange('\u0100', '\u017f'));
        Datatypes.put(automata, "LatinExtended-B", Automaton.makeCharRange('\u0180', '\u024f'));
        Datatypes.put(automata, "IPAExtensions", Automaton.makeCharRange('\u0250', '\u02af'));
        Datatypes.put(automata, "SpacingModifierLetters", Automaton.makeCharRange('\u02b0', '\u02ff'));
        Datatypes.put(automata, "CombiningDiacriticalMarks", Automaton.makeCharRange('\u0300', '\u036f'));
        Datatypes.put(automata, "Greek", Automaton.makeCharRange('\u0370', '\u03ff'));
        Datatypes.put(automata, "Cyrillic", Automaton.makeCharRange('\u0400', '\u04ff'));
        Datatypes.put(automata, "Armenian", Automaton.makeCharRange('\u0530', '\u058f'));
        Datatypes.put(automata, "Hebrew", Automaton.makeCharRange('\u0590', '\u05ff'));
        Datatypes.put(automata, "Arabic", Automaton.makeCharRange('\u0600', '\u06ff'));
        Datatypes.put(automata, "Syriac", Automaton.makeCharRange('\u0700', '\u074f'));
        Datatypes.put(automata, "Thaana", Automaton.makeCharRange('\u0780', '\u07bf'));
        Datatypes.put(automata, "Devanagari", Automaton.makeCharRange('\u0900', '\u097f'));
        Datatypes.put(automata, "Bengali", Automaton.makeCharRange('\u0980', '\u09ff'));
        Datatypes.put(automata, "Gurmukhi", Automaton.makeCharRange('\u0a00', '\u0a7f'));
        Datatypes.put(automata, "Gujarati", Automaton.makeCharRange('\u0a80', '\u0aff'));
        Datatypes.put(automata, "Oriya", Automaton.makeCharRange('\u0b00', '\u0b7f'));
        Datatypes.put(automata, "Tamil", Automaton.makeCharRange('\u0b80', '\u0bff'));
        Datatypes.put(automata, "Telugu", Automaton.makeCharRange('\u0c00', '\u0c7f'));
        Datatypes.put(automata, "Kannada", Automaton.makeCharRange('\u0c80', '\u0cff'));
        Datatypes.put(automata, "Malayalam", Automaton.makeCharRange('\u0d00', '\u0d7f'));
        Datatypes.put(automata, "Sinhala", Automaton.makeCharRange('\u0d80', '\u0dff'));
        Datatypes.put(automata, "Thai", Automaton.makeCharRange('\u0e00', '\u0e7f'));
        Datatypes.put(automata, "Lao", Automaton.makeCharRange('\u0e80', '\u0eff'));
        Datatypes.put(automata, "Tibetan", Automaton.makeCharRange('\u0f00', '\u0fff'));
        Datatypes.put(automata, "Myanmar", Automaton.makeCharRange('\u1000', '\u109f'));
        Datatypes.put(automata, "Georgian", Automaton.makeCharRange('\u10a0', '\u10ff'));
        Datatypes.put(automata, "HangulJamo", Automaton.makeCharRange('\u1100', '\u11ff'));
        Datatypes.put(automata, "Ethiopic", Automaton.makeCharRange('\u1200', '\u137f'));
        Datatypes.put(automata, "Cherokee", Automaton.makeCharRange('\u13a0', '\u13ff'));
        Datatypes.put(automata, "UnifiedCanadianAboriginalSyllabics", Automaton.makeCharRange('\u1400', '\u167f'));
        Datatypes.put(automata, "Ogham", Automaton.makeCharRange('\u1680', '\u169f'));
        Datatypes.put(automata, "Runic", Automaton.makeCharRange('\u16a0', '\u16ff'));
        Datatypes.put(automata, "Khmer", Automaton.makeCharRange('\u1780', '\u17ff'));
        Datatypes.put(automata, "Mongolian", Automaton.makeCharRange('\u1800', '\u18af'));
        Datatypes.put(automata, "LatinExtendedAdditional", Automaton.makeCharRange('\u1e00', '\u1eff'));
        Datatypes.put(automata, "GreekExtended", Automaton.makeCharRange('\u1f00', '\u1fff'));
        Datatypes.put(automata, "GeneralPunctuation", Automaton.makeCharRange('\u2000', '\u206f'));
        Datatypes.put(automata, "SuperscriptsandSubscripts", Automaton.makeCharRange('\u2070', '\u209f'));
        Datatypes.put(automata, "CurrencySymbols", Automaton.makeCharRange('\u20a0', '\u20cf'));
        Datatypes.put(automata, "CombiningMarksforSymbols", Automaton.makeCharRange('\u20d0', '\u20ff'));
        Datatypes.put(automata, "LetterlikeSymbols", Automaton.makeCharRange('\u2100', '\u214f'));
        Datatypes.put(automata, "NumberForms", Automaton.makeCharRange('\u2150', '\u218f'));
        Datatypes.put(automata, "Arrows", Automaton.makeCharRange('\u2190', '\u21ff'));
        Datatypes.put(automata, "MathematicalOperators", Automaton.makeCharRange('\u2200', '\u22ff'));
        Datatypes.put(automata, "MiscellaneousTechnical", Automaton.makeCharRange('\u2300', '\u23ff'));
        Datatypes.put(automata, "ControlPictures", Automaton.makeCharRange('\u2400', '\u243f'));
        Datatypes.put(automata, "OpticalCharacterRecognition", Automaton.makeCharRange('\u2440', '\u245f'));
        Datatypes.put(automata, "EnclosedAlphanumerics", Automaton.makeCharRange('\u2460', '\u24ff'));
        Datatypes.put(automata, "BoxDrawing", Automaton.makeCharRange('\u2500', '\u257f'));
        Datatypes.put(automata, "BlockElements", Automaton.makeCharRange('\u2580', '\u259f'));
        Datatypes.put(automata, "GeometricShapes", Automaton.makeCharRange('\u25a0', '\u25ff'));
        Datatypes.put(automata, "MiscellaneousSymbols", Automaton.makeCharRange('\u2600', '\u26ff'));
        Datatypes.put(automata, "Dingbats", Automaton.makeCharRange('\u2700', '\u27bf'));
        Datatypes.put(automata, "BraillePatterns", Automaton.makeCharRange('\u2800', '\u28ff'));
        Datatypes.put(automata, "CJKRadicalsSupplement", Automaton.makeCharRange('\u2e80', '\u2eff'));
        Datatypes.put(automata, "KangxiRadicals", Automaton.makeCharRange('\u2f00', '\u2fdf'));
        Datatypes.put(automata, "IdeographicDescriptionCharacters", Automaton.makeCharRange('\u2ff0', '\u2fff'));
        Datatypes.put(automata, "CJKSymbolsandPunctuation", Automaton.makeCharRange('\u3000', '\u303f'));
        Datatypes.put(automata, "Hiragana", Automaton.makeCharRange('\u3040', '\u309f'));
        Datatypes.put(automata, "Katakana", Automaton.makeCharRange('\u30a0', '\u30ff'));
        Datatypes.put(automata, "Bopomofo", Automaton.makeCharRange('\u3100', '\u312f'));
        Datatypes.put(automata, "HangulCompatibilityJamo", Automaton.makeCharRange('\u3130', '\u318f'));
        Datatypes.put(automata, "Kanbun", Automaton.makeCharRange('\u3190', '\u319f'));
        Datatypes.put(automata, "BopomofoExtended", Automaton.makeCharRange('\u31a0', '\u31bf'));
        Datatypes.put(automata, "EnclosedCJKLettersandMonths", Automaton.makeCharRange('\u3200', '\u32ff'));
        Datatypes.put(automata, "CJKCompatibility", Automaton.makeCharRange('\u3300', '\u33ff'));
        Datatypes.put(automata, "CJKUnifiedIdeographsExtensionA", Automaton.makeCharRange('\u3400', '\u4db5'));
        Datatypes.put(automata, "CJKUnifiedIdeographs", Automaton.makeCharRange('\u4e00', '\u9fff'));
        Datatypes.put(automata, "YiSyllables", Automaton.makeCharRange('\ua000', '\ua48f'));
        Datatypes.put(automata, "YiRadicals", Automaton.makeCharRange('\ua490', '\ua4cf'));
        Datatypes.put(automata, "HangulSyllables", Automaton.makeCharRange('\uac00', '\ud7a3'));
        Datatypes.put(automata, "CJKCompatibilityIdeographs", Automaton.makeCharRange('\uf900', '\ufaff'));
        Datatypes.put(automata, "AlphabeticPresentationForms", Automaton.makeCharRange('\ufb00', '\ufb4f'));
        Datatypes.put(automata, "ArabicPresentationForms-A", Automaton.makeCharRange('\ufb50', '\ufdff'));
        Datatypes.put(automata, "CombiningHalfMarks", Automaton.makeCharRange('\ufe20', '\ufe2f'));
        Datatypes.put(automata, "CJKCompatibilityForms", Automaton.makeCharRange('\ufe30', '\ufe4f'));
        Datatypes.put(automata, "SmallFormVariants", Automaton.makeCharRange('\ufe50', '\ufe6f'));
        Datatypes.put(automata, "ArabicPresentationForms-B", Automaton.makeCharRange('\ufe70', '\ufefe'));
        Datatypes.put(automata, "Specials", Automaton.makeCharRange('\ufeff', '\ufeff'));
        Datatypes.put(automata, "HalfwidthandFullwidthForms", Automaton.makeCharRange('\uff00', '\uffef'));
        Datatypes.put(automata, "Specials", Automaton.makeCharRange('\ufff0', '\ufffd'));
        Datatypes.put(automata, "OldItalic", Automaton.makeChar('\ud800').concatenate(Automaton.makeCharRange('\udf00', '\udf2f')));
        Datatypes.put(automata, "Gothic", Automaton.makeChar('\ud800').concatenate(Automaton.makeCharRange('\udf30', '\udf4f')));
        Datatypes.put(automata, "Deseret", Automaton.makeChar('\ud801').concatenate(Automaton.makeCharRange('\udc00', '\udc4f')));
        Datatypes.put(automata, "ByzantineMusicalSymbols", Automaton.makeChar('\ud834').concatenate(Automaton.makeCharRange('\udc00', '\udcff')));
        Datatypes.put(automata, "MusicalSymbols", Automaton.makeChar('\ud834').concatenate(Automaton.makeCharRange('\udd00', '\uddff')));
        Datatypes.put(automata, "MathematicalAlphanumericSymbols", Automaton.makeChar('\ud835').concatenate(Automaton.makeCharRange('\udc00', '\udfff')));
        Datatypes.put(automata, "CJKUnifiedIdeographsExtensionB", Automaton.makeCharRange('\ud840', '\ud868').concatenate(Automaton.makeCharRange('\udc00', '\udfff')).union(Automaton.makeChar('\ud869').concatenate(Automaton.makeCharRange('\udc00', '\uded6'))));
        Datatypes.put(automata, "CJKCompatibilityIdeographsSupplement", Automaton.makeChar('\ud87e').concatenate(Automaton.makeCharRange('\udc00', '\ude1f')));
        Datatypes.put(automata, "Tags", Automaton.makeChar('\udb40').concatenate(Automaton.makeCharRange('\udc00', '\udc7f')));
        Datatypes.put(automata, "PrivateUse", Automaton.makeCharRange('\ue000', '\uf8ff').union(Automaton.makeCharRange('\udb80', '\udbbe').concatenate(Automaton.makeCharRange('\udc00', '\udfff')).union(Automaton.makeChar('\udbbf').concatenate(Automaton.makeCharRange('\udc00', '\udffd')))).union(Automaton.makeCharRange('\udbc0', '\udbfe').concatenate(Automaton.makeCharRange('\udc00', '\udfff')).union(Automaton.makeChar('\udbff').concatenate(Automaton.makeCharRange('\udc00', '\udffd')))));
        System.out.println("Building Unicode category automata...");
        HashMap categories = new HashMap();
        try {
            StreamTokenizer st = new StreamTokenizer(new BufferedReader(new FileReader("src/Unicode.txt")));
            st.resetSyntax();
            st.whitespaceChars(59, 59);
            st.whitespaceChars(10, 32);
            st.wordChars(48, 57);
            st.wordChars(97, 122);
            st.wordChars(65, 90);
            while (st.nextToken() != -1) {
                int cp = Integer.parseInt(st.sval, 16);
                st.nextToken();
                String cat = st.sval;
                Set<Integer> c = (TreeSet<Integer>)categories.get(cat);
                if (c == null) {
                    c = new TreeSet<Integer>();
                    categories.put(cat, c);
                }
                c.add(cp);
                String ccat = cat.substring(0, 1);
                c = (Set)categories.get(ccat);
                if (c == null) {
                    c = new TreeSet();
                    categories.put(ccat, c);
                }
                c.add(cp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        ArrayList<Automaton> assigned = new ArrayList<Automaton>();
        for (Map.Entry me : categories.entrySet()) {
            ArrayList<Automaton> la1 = new ArrayList<Automaton>();
            ArrayList<Automaton> la2 = new ArrayList<Automaton>();
            for (Integer cp : (Set)me.getValue()) {
                la1.add(Datatypes.makeCodePoint(cp));
                if (la1.size() != 50) continue;
                la2.add(Automaton.minimize(Automaton.union(la1)));
                la1.clear();
            }
            la2.add(Automaton.union(la1));
            Automaton a = Automaton.minimize(Automaton.union(la2));
            Datatypes.put(automata, (String)me.getKey(), a);
            assigned.add(a);
        }
        Automaton cn = Automaton.minimize(automata.get("Char").clone().intersection(Automaton.union(assigned).complement()));
        Datatypes.put(automata, "Cn", cn);
        Datatypes.put(automata, "C", automata.get("C").clone().union(cn));
    }

    private static Automaton makeCodePoint(int cp) {
        if (cp >= 65536) {
            char[] cu = new char[]{(char)(55296 + ((cp -= 65536) >> 10)), (char)(56320 + (cp & 0x3FF))};
            return Automaton.makeString(new String(cu));
        }
        return Automaton.makeChar((char)cp);
    }

    private static Map<String, Automaton> buildMap(String[] exps) {
        HashMap<String, Automaton> map = new HashMap<String, Automaton>();
        int i = 0;
        while (i + 1 < exps.length) {
            Datatypes.put(map, exps[i++], new RegExp(exps[i++]).toAutomaton(map));
        }
        return map;
    }

    private static void putWith(String[] exps, Map<String, Automaton> use) {
        int i = 0;
        while (i + 1 < exps.length) {
            Datatypes.put(automata, exps[i++], new RegExp(exps[i++]).toAutomaton(use));
        }
    }

    private static void putFrom(String name, Map<String, Automaton> from) {
        automata.put(name, from.get(name));
    }

    private static void put(Map<String, Automaton> map, String name, Automaton a) {
        map.put(name, a);
        System.out.println("  " + name + ": " + a.getNumberOfStates() + " states, " + a.getNumberOfTransitions() + " transitions");
    }

    static Automaton getWhitespaceAutomaton() {
        return ws;
    }

    static {
        unicodeblock_names_array = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-B", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-B", "Specials", "HalfwidthandFullwidthForms", "Specials", "OldItalic", "Gothic", "Deseret", "ByzantineMusicalSymbols", "MusicalSymbols", "MathematicalAlphanumericSymbols", "CJKUnifiedIdeographsExtensionB", "CJKCompatibilityIdeographsSupplement", "Tags"};
        unicodecategory_names_array = new String[]{"Lu", "Ll", "Lt", "Lm", "Lo", "L", "Mn", "Mc", "Me", "M", "Nd", "Nl", "No", "N", "Pc", "Pd", "Ps", "Pe", "Pi", "Pf", "Po", "P", "Zs", "Zl", "Zp", "Z", "Sm", "Sc", "Sk", "So", "S", "Cc", "Cf", "Co", "Cn", "C"};
        xml_names_array = new String[]{"NCName", "QName", "Char", "NameChar", "URI", "anyname", "noap", "whitespace", "whitespacechar", "string", "boolean", "decimal", "float", "integer", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "hexBinary", "base64Binary", "NCName2", "NCNames", "QName2", "Nmtoken2", "Nmtokens", "Name2", "Names", "language"};
        automata = new HashMap<String, Automaton>();
        ws = Automaton.minimize(Automaton.makeCharSet(" \t\n\r").repeat());
        unicodeblock_names = new HashSet<String>(Arrays.asList(unicodeblock_names_array));
        unicodecategory_names = new HashSet<String>(Arrays.asList(unicodecategory_names_array));
        xml_names = new HashSet<String>(Arrays.asList(xml_names_array));
    }
}

