/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import sqldelight.com.intellij.util.ui.GraphicsUtil;
import sqldelight.com.intellij.util.ui.ImageUtil;
import sqldelight.com.intellij.util.ui.StartupUiUtil;
import sqldelight.com.intellij.util.ui.WavePainter;

public class WavePainter2D
extends WavePainter {
    private static final float STROKE_WIDTH = 0.7f;
    private static final Map<Color, WavePainter2D> myPainters = new HashMap<Color, WavePainter2D>();
    private static final int PATTERN_WIDTH = 4000;
    private final BufferedImage myImage = ImageUtil.createImage(4000, 3, 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WavePainter2D(Color color) {
        Graphics2D g = this.myImage.createGraphics();
        try {
            GraphicsUtil.setupAAPainting(g);
            g.setStroke(new BasicStroke(0.7f));
            g.setColor(color);
            double height = 1.0;
            double cycle = 4.0 * height;
            double wavedAt = (double)2.3f - height;
            GeneralPath wavePath = new GeneralPath();
            wavePath.moveTo(0.0, wavedAt - Math.cos(0.0 / cycle) * height);
            for (int x = 0; x < 4000; ++x) {
                wavePath.lineTo((double)x, wavedAt - Math.cos((double)(x * 2) * Math.PI / cycle) * height);
            }
            g.draw(wavePath);
        }
        finally {
            g.dispose();
        }
    }

    @Override
    public void paint(Graphics2D g, int xStart, int xEnd, int y) {
        this.paint(g, (double)xStart, (double)xEnd, (double)y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, double xStart, double xEnd, double y) {
        Rectangle2D.Double waveClip;
        Shape clip = g.getClip();
        Rectangle2D.Double rectangle = new Rectangle2D.Double(xStart, y - 3.0, xEnd - xStart, 3.0);
        Rectangle2D rectangle2D = waveClip = clip != null ? clip.getBounds2D().createIntersection(rectangle) : rectangle;
        if (((RectangularShape)waveClip).isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.setClip(waveClip);
            xStart -= xStart % 4.0;
            g2d.translate(xStart, y - 3.0);
            StartupUiUtil.drawImage((Graphics)g2d, (Image)this.myImage, 0, 0, null);
        }
        finally {
            g2d.dispose();
        }
    }

    public static WavePainter2D forColor(Color color) {
        WavePainter2D painter = myPainters.get(color);
        if (painter == null) {
            painter = new WavePainter2D(color);
            myPainters.put(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()), painter);
        }
        return painter;
    }
}

