/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ref;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import sqldelight.com.intellij.openapi.util.LowMemoryWatcher;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.reference.SoftReference;
import sqldelight.com.intellij.util.MemoryDumpHelper;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.ref.GCUtil;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;

public class GCWatcher {
    private final ReferenceQueue<Object> myQueue;
    private final Set<Reference<?>> myReferences;

    private GCWatcher(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(0);
        }
        this.myQueue = new ReferenceQueue();
        this.myReferences = ContainerUtil.newConcurrentSet();
        for (Object o : objects) {
            if (o == null) continue;
            this.myReferences.add(new WeakReference<Object>(o, this.myQueue));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static GCWatcher tracking(Object ... objects) {
        return GCWatcher.tracking(Arrays.asList(objects));
    }

    @NotNull
    @Contract(pure=true)
    public static GCWatcher tracking(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(1);
        }
        return new GCWatcher(objects);
    }

    @NotNull
    public static GCWatcher fromClearedRef(@NotNull Ref<?> ref) {
        if (ref == null) {
            GCWatcher.$$$reportNull$$$0(2);
        }
        GCWatcher result = GCWatcher.tracking(ref.get());
        ref.set(null);
        GCWatcher gCWatcher = result;
        if (gCWatcher == null) {
            GCWatcher.$$$reportNull$$$0(3);
        }
        return gCWatcher;
    }

    private boolean isEverythingCollected() {
        boolean removed;
        while (true) {
            Reference<Object> ref;
            if ((ref = this.myQueue.poll()) == null) {
                return this.myReferences.isEmpty();
            }
            removed = this.myReferences.remove(ref);
            assert (removed);
        }
    }

    public boolean tryCollect(int timeoutMs) {
        return LowMemoryWatcher.runWithNotificationsSuppressed(() -> {
            long startTime = System.currentTimeMillis();
            GCUtil.allocateTonsOfMemory(new StringBuilder(), () -> this.isEverythingCollected() || System.currentTimeMillis() - startTime > (long)timeoutMs);
            return this.isEverythingCollected();
        });
    }

    public void ensureCollected() {
        StringBuilder log = new StringBuilder();
        if (!GCUtil.allocateTonsOfMemory(log, this::isEverythingCollected)) {
            String message = "Couldn't garbage-collect some objects, they might still be reachable from GC roots: " + ContainerUtil.mapNotNull(this.myReferences, SoftReference::dereference);
            try {
                File file = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), "GCWatcher.hprof.zip");
                MemoryDumpHelper.captureMemoryDumpZipped(file);
                System.out.println("##teamcity[publishArtifacts '" + file.getPath() + "']");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.isEverythingCollected()) {
                message = message + "\nEverything is collected after taking the heap dump.";
            }
            message = message + "Log:\n" + log;
            throw new IllegalStateException(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/ref/GCWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/ref/GCWatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromClearedRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tracking";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromClearedRef";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

