/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.indexing;

import java.io.IOException;
import java.nio.charset.Charset;
import sqldelight.com.intellij.lang.FileASTNode;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.lang.LighterAST;
import sqldelight.com.intellij.lang.TreeBackedLighterAST;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.fileEditor.FileDocumentManager;
import sqldelight.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.fileTypes.FileTypeRegistry;
import sqldelight.com.intellij.openapi.fileTypes.LanguageFileType;
import sqldelight.com.intellij.openapi.project.DefaultProjectFactory;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.LanguageSubstitutors;
import sqldelight.com.intellij.psi.PsiDocumentManager;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiFileFactory;
import sqldelight.com.intellij.util.indexing.FileContent;
import sqldelight.com.intellij.util.indexing.IndexedFileImpl;
import sqldelight.com.intellij.util.indexing.IndexingDataKeys;
import sqldelight.com.intellij.util.indexing.PsiDependentFileContent;
import sqldelight.com.intellij.util.indexing.SubstitutedFileType;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends IndexedFileImpl
implements PsiDependentFileContent {
    private Charset myCharset;
    protected byte[] myContent;
    private CharSequence myContentAsText;
    private final long myStamp;
    private byte[] myFileContentHash;
    private boolean myLighterASTShouldBeThreadSafe;
    private final boolean myPhysicalContent;
    private static final Key<PsiFile> CACHED_PSI = Key.create("cached psi from content");

    public FileContentImpl(@NotNull VirtualFile file, @NotNull CharSequence contentAsText, long documentStamp) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(0);
        }
        if (contentAsText == null) {
            FileContentImpl.$$$reportNull$$$0(1);
        }
        this(file, contentAsText, null, documentStamp, false);
    }

    public FileContentImpl(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(2);
        }
        if (content == null) {
            FileContentImpl.$$$reportNull$$$0(3);
        }
        this(file, null, content, -1L, true);
    }

    /*
     * WARNING - void declaration
     */
    protected FileContentImpl(@NotNull VirtualFile file, CharSequence contentAsText, byte[] content, long stamp, boolean bl) {
        void physicalContent;
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(4);
        }
        super(file, FileTypeRegistry.getInstance().getFileTypeByFile(file, content), null);
        this.myContentAsText = contentAsText;
        this.myContent = content;
        this.myStamp = stamp;
        this.myPhysicalContent = physicalContent;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.getPsiFileForPsiDependentIndex();
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    private PsiFile getFileFromText() {
        PsiFile psi = this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            psi = this.createFileFromText(this.getContentAsText());
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(6);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public LighterAST getLighterAST() {
        LighterAST lighterAST = this.getUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFile().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY, lighterAST);
        }
        LighterAST lighterAST2 = lighterAST;
        if (lighterAST2 == null) {
            FileContentImpl.$$$reportNull$$$0(7);
        }
        return lighterAST2;
    }

    void ensureThreadSafeLighterAST() {
        this.myLighterASTShouldBeThreadSafe = true;
    }

    public PsiFile createFileFromText(@NotNull CharSequence text) {
        FileType fileType;
        Project project;
        if (text == null) {
            FileContentImpl.$$$reportNull$$$0(8);
        }
        if ((project = this.getProject()) == null) {
            project = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        if (!((fileType = this.getFileTypeWithoutSubstitution()) instanceof LanguageFileType)) {
            throw new AssertionError((Object)("PSI can be created only for a file with LanguageFileType but actual is " + fileType.getClass() + ".\nPlease use a proper FileBasedIndexExtension#getInputFilter() implementation for the caller index"));
        }
        return FileContentImpl.createFileFromText(project, text, (LanguageFileType)fileType, this.myFile, this.myFileName);
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project, @NotNull CharSequence text, @NotNull LanguageFileType fileType, @NotNull VirtualFile file, @NotNull String fileName) {
        if (project == null) {
            FileContentImpl.$$$reportNull$$$0(9);
        }
        if (text == null) {
            FileContentImpl.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(11);
        }
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(12);
        }
        if (fileName == null) {
            FileContentImpl.$$$reportNull$$$0(13);
        }
        Language language = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.getInstance().substituteLanguage(language, file, project);
        PsiFile psiFile = PsiFileFactory.getInstance(project).createFileFromText(fileName, substitutedLanguage, text, false, false, false, file);
        if (psiFile == null) {
            throw new IllegalStateException("psiFile is null. language = " + language.getID() + ", substitutedLanguage = " + substitutedLanguage.getID());
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            FileContentImpl.$$$reportNull$$$0(14);
        }
        return psiFile2;
    }

    public static FileContent createByFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(15);
        }
        return FileContentImpl.createByFile(file, null);
    }

    public static FileContent createByFile(@NotNull VirtualFile file, @Nullable Project project) throws IOException {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(16);
        }
        FileContentImpl content = new FileContentImpl(file, file.contentsToByteArray());
        if (project != null) {
            content.setProject(project);
        }
        return content;
    }

    @ApiStatus.Internal
    @NotNull
    public FileType getFileTypeWithoutSubstitution() {
        FileType fileType = this.getFileType();
        FileType fileType2 = fileType instanceof SubstitutedFileType ? ((SubstitutedFileType)fileType).getOriginalFileType() : fileType;
        if (fileType2 == null) {
            FileContentImpl.$$$reportNull$$$0(17);
        }
        return fileType2;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileContentImpl.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            FileContentImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            this.myCharset = charset = this.myFile.getCharset();
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            FileContentImpl.$$$reportNull$$$0(20);
        }
        return charset2;
    }

    public long getStamp() {
        return this.myStamp;
    }

    public boolean isPhysicalContent() {
        return this.myPhysicalContent;
    }

    @Override
    public byte @NotNull [] getContent() {
        byte[] content = this.myContent;
        if (content == null) {
            this.myContent = content = this.myContentAsText.toString().getBytes(this.getCharset());
        }
        if (content == null) {
            FileContentImpl.$$$reportNull$$$0(21);
        }
        return content;
    }

    @Override
    @NotNull
    public CharSequence getContentAsText() {
        FileType unsubstitutedFileType = this.getFileTypeWithoutSubstitution();
        if (unsubstitutedFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + unsubstitutedFileType.getDescription());
        }
        CharSequence content = this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            CharSequence charSequence = content;
            if (charSequence == null) {
                FileContentImpl.$$$reportNull$$$0(22);
            }
            return charSequence;
        }
        CharSequence contentAsText = this.myContentAsText;
        if (contentAsText == null) {
            this.myContentAsText = contentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myFile);
            this.myContent = null;
        }
        CharSequence charSequence = contentAsText;
        if (charSequence == null) {
            FileContentImpl.$$$reportNull$$$0(23);
        }
        return charSequence;
    }

    @Override
    public String toString() {
        return "FileContentImpl(" + this.getFileName() + ")";
    }

    public byte @Nullable [] getHash() {
        if (!this.myPhysicalContent) {
            throw new IllegalStateException("Hashes are allowed only while physical changes indexing");
        }
        return this.myFileContentHash;
    }

    public void setHashes(byte @NotNull [] fileContentHash) {
        if (fileContentHash == null) {
            FileContentImpl.$$$reportNull$$$0(24);
        }
        this.myFileContentHash = fileContentHash;
    }

    @Deprecated
    @NotNull
    public PsiFile getPsiFileForPsiDependentIndex() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document;
        PsiFile psi = null;
        if (!this.myPhysicalContent && (document = FileDocumentManager.getInstance().getCachedDocument(this.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance(this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            psi = existingPsi;
        }
        if (psi == null) {
            psi = this.getFileFromText();
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(25);
        }
        return psiFile;
    }

    @Override
    public Project getProject() {
        Project project = super.getProject();
        return project != null ? project : this.getUserData(IndexingDataKeys.PROJECT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAsText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileFromText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLighterAST";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeWithoutSubstitution";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentAsText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFileForPsiDependentIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createByFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setHashes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IllegalDataException
    extends RuntimeException {
        IllegalDataException(String message) {
            super(message);
        }
    }
}

