/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.util.IconLoader;
import sqldelight.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.ui.scale.DerivedScaleType;
import sqldelight.com.intellij.ui.scale.ScaleContext;
import sqldelight.com.intellij.ui.svg.MyTranscoder;
import sqldelight.com.intellij.ui.svg.SaxSvgDocumentFactory;
import sqldelight.com.intellij.util.ImageLoader;
import sqldelight.com.intellij.util.SVGLoaderCache;
import sqldelight.com.intellij.util.SVGLoaderPrebuilt;
import sqldelight.com.intellij.util.SystemProperties;
import sqldelight.com.intellij.util.concurrency.AppExecutorUtil;
import sqldelight.com.intellij.util.ui.ImageUtil;
import sqldelight.com.intellij.util.ui.JBUI;
import sqldelight.org.apache.batik.anim.dom.SVGOMDocument;
import sqldelight.org.apache.batik.bridge.BridgeContext;
import sqldelight.org.apache.batik.bridge.GVTBuilder;
import sqldelight.org.apache.batik.transcoder.TranscoderException;
import sqldelight.org.apache.batik.transcoder.TranscoderInput;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.w3c.dom.Document;
import sqldelight.org.w3c.dom.Element;

public final class SVGLoader {
    private static final byte[] DEFAULT_THEME = new byte[0];
    private static SvgElementColorPatcherProvider ourColorPatcher = null;
    private static final SVGLoaderCache ourCache = new SVGLoaderCache(){

        @Override
        @NotNull
        protected Path getCachesHome() {
            Path path = Paths.get(PathManager.getSystemPath(), "sqldelight.icons");
            if (path == null) {
                1.$$$reportNull$$$0(0);
            }
            return path;
        }

        @Override
        protected void forkIOTask(@NotNull Runnable action) {
            if (action == null) {
                1.$$$reportNull$$$0(1);
            }
            AppExecutorUtil.getAppExecutorService().execute(action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/SVGLoader$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCachesHome";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/SVGLoader$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "forkIOTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final int ICON_DEFAULT_SIZE = 16;

    public static Image load(@NotNull URL url, float scale) throws IOException {
        if (url == null) {
            SVGLoader.$$$reportNull$$$0(0);
        }
        return SVGLoader.load(url, url.openStream(), scale);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(1);
        }
        return SVGLoader.load(null, stream, scale);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(2);
        }
        return SVGLoader.load(url, stream, scale, null);
    }

    @ApiStatus.Internal
    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale, @Nullable ImageLoader.Dimension2DDouble dimension2DDouble) throws IOException {
        BufferedImage image;
        ImageLoader.Dimension2DDouble docSize;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(3);
        }
        if (docSize == null) {
            docSize = new ImageLoader.Dimension2DDouble(0.0, 0.0);
        }
        byte[] theme = null;
        byte[] svgBytes = null;
        if (SystemProperties.getBooleanProperty("idea.ui.icons.svg.disk.cache", true)) {
            SvgElementColorPatcher subPatcher;
            theme = DEFAULT_THEME;
            SvgElementColorPatcherProvider colorPatcher = ourColorPatcher;
            if (colorPatcher != null && (subPatcher = colorPatcher.forURL(url)) != null) {
                theme = subPatcher.digest();
            }
            if (theme == DEFAULT_THEME && (image = SVGLoaderPrebuilt.loadUrlFromPreBuiltCache(url, scale, docSize)) != null) {
                return image;
            }
            if (theme != null) {
                svgBytes = FileUtil.loadBytes(stream);
                image = ourCache.loadFromCache(theme, svgBytes, scale, docSize);
                if (image != null) {
                    return image;
                }
                stream = new ByteArrayInputStream(svgBytes);
            }
        }
        if ((image = SVGLoader.loadWithoutCache(url, stream, scale, docSize)) != null && theme != null) {
            ourCache.storeLoadedImage(theme, svgBytes, scale, image, docSize);
        }
        return image;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static BufferedImage loadWithoutCache(@Nullable URL url, @NotNull InputStream stream, double scale, @Nullable ImageLoader.Dimension2DDouble dimension2DDouble) throws IOException {
        void docSize;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(4);
        }
        try {
            MyTranscoder transcoder = MyTranscoder.createImage(scale, SVGLoader.createTranscodeInput(url, stream));
            if (docSize != null) {
                docSize.setSize(transcoder.getOrigDocWidth(), transcoder.getOrigDocHeight());
            }
            return transcoder.getImage();
        }
        catch (TranscoderException ex) {
            if (docSize != null) {
                docSize.setSize(0.0, 0.0);
            }
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Image load(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext ctx, double width, double d) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(5);
        }
        if (ctx == null) {
            SVGLoader.$$$reportNull$$$0(6);
        }
        try {
            void height;
            double s = ctx.getScale(DerivedScaleType.PIX_SCALE);
            return MyTranscoder.createImage(1.0, SVGLoader.createTranscodeInput(url, stream), (float)(width * s), (float)(height * s)).getImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, ScaleContext ctx, double width, double d) throws IOException {
        void height;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(7);
        }
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx, width, (double)height);
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI((Image)image, ctx);
        return (T)t;
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(8);
        }
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx.getScale(DerivedScaleType.PIX_SCALE));
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI((Image)image, ctx);
        return (T)t;
    }

    @Deprecated
    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, JBUI.ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(9);
        }
        return SVGLoader.loadHiDPI(url, stream, (ScaleContext)ctx);
    }

    public static ImageLoader.Dimension2DDouble getDocumentSize(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        int ch;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(10);
        }
        BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream(100);
        byte[] bytes = new byte[3];
        boolean checkClosingBracket = false;
        while ((ch = stream.read()) != -1) {
            buffer.write(ch);
            if (ch == 60) {
                int n = stream.read(bytes, 0, 3);
                if (n == -1) break;
                buffer.write(bytes, 0, n);
                checkClosingBracket = n == 3 && bytes[0] == 115 && bytes[1] == 118 && bytes[2] == 103;
                continue;
            }
            if (!checkClosingBracket || ch != 62) continue;
            buffer.write(new byte[]{60, 47, 115, 118, 103, 62});
            return SVGLoader.getDocumentSize(scale, SVGLoader.createTranscodeInput(url, new ByteArrayInputStream(buffer.getInternalBuffer(), 0, buffer.size())));
        }
        return new ImageLoader.Dimension2DDouble(16.0 * scale, 16.0 * scale);
    }

    public static double getMaxZoomFactor(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(11);
        }
        if (ctx == null) {
            SVGLoader.$$$reportNull$$$0(12);
        }
        ImageLoader.Dimension2DDouble size = SVGLoader.getDocumentSize(ctx.getScale(DerivedScaleType.PIX_SCALE), SVGLoader.createTranscodeInput(url, stream));
        double iconMaxSize2 = MyTranscoder.getIconMaxSize();
        return Math.min(iconMaxSize2 / size.getWidth(), iconMaxSize2 / size.getHeight());
    }

    private SVGLoader() {
    }

    @NotNull
    private static TranscoderInput createTranscodeInput(@Nullable URL url, @NotNull InputStream stream) throws IOException {
        TranscoderInput myTranscoderInput;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(13);
        }
        String uri = null;
        try {
            if (url != null && "jar".equals(url.getProtocol())) {
                url = new URL(url.getPath());
            }
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Document document = new SaxSvgDocumentFactory().createDocument(uri, stream);
        SVGLoader.patchColors(url, document);
        TranscoderInput transcoderInput = myTranscoderInput = new TranscoderInput(document);
        if (transcoderInput == null) {
            SVGLoader.$$$reportNull$$$0(14);
        }
        return transcoderInput;
    }

    private static void patchColors(@Nullable URL url, @NotNull Document document) {
        SvgElementColorPatcher patcher;
        SvgElementColorPatcherProvider colorPatcher;
        if (document == null) {
            SVGLoader.$$$reportNull$$$0(15);
        }
        if ((colorPatcher = ourColorPatcher) != null && (patcher = colorPatcher.forURL(url)) != null) {
            patcher.patchColors(document.getDocumentElement());
        }
    }

    @Deprecated
    public static void setColorPatcher(final @Nullable SvgColorPatcher colorPatcher) {
        if (colorPatcher == null) {
            SVGLoader.setColorPatcherProvider(null);
            return;
        }
        SVGLoader.setColorPatcherProvider(new SvgElementColorPatcherProvider(){

            @Override
            public SvgElementColorPatcher forURL(final @Nullable URL url) {
                return new SvgElementColorPatcher(){

                    @Override
                    public void patchColors(@NotNull Element svg) {
                        if (svg == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        colorPatcher.patchColors(url, svg);
                    }

                    @Override
                    public byte @Nullable [] digest() {
                        return null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svg", "sqldelight/com/intellij/util/SVGLoader$2$1", "patchColors"));
                    }
                };
            }
        });
    }

    public static void setColorPatcherProvider(@Nullable SvgElementColorPatcherProvider colorPatcher) {
        ourColorPatcher = colorPatcher;
        IconLoader.clearCache();
    }

    /*
     * WARNING - void declaration
     */
    private static ImageLoader.Dimension2DDouble getDocumentSize(double scale, @NotNull TranscoderInput transcoderInput) {
        void input;
        if (transcoderInput == null) {
            SVGLoader.$$$reportNull$$$0(16);
        }
        SVGOMDocument document = (SVGOMDocument)input.getDocument();
        BridgeContext ctx = new MyTranscoder(scale).createBridgeContext(document);
        new GVTBuilder().build(ctx, document);
        Dimension2D size = ctx.getDocumentSize();
        return new ImageLoader.Dimension2DDouble(size.getWidth() * scale, size.getHeight() * scale);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/SVGLoader";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/SVGLoader";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTranscodeInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadWithoutCache";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadHiDPI";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentSize";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMaxZoomFactor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTranscodeInput";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchColors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static interface SvgColorPatcher {
        @Deprecated
        default public void patchColors(@NotNull Element svg) {
            if (svg == null) {
                SvgColorPatcher.$$$reportNull$$$0(0);
            }
        }

        default public void patchColors(@Nullable URL url, @NotNull Element svg) {
            if (svg == null) {
                SvgColorPatcher.$$$reportNull$$$0(1);
            }
            this.patchColors(svg);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svg", "sqldelight/com/intellij/util/SVGLoader$SvgColorPatcher", "patchColors"));
        }
    }

    public static interface SvgElementColorPatcherProvider {
        @Nullable
        public SvgElementColorPatcher forURL(@Nullable URL var1);
    }

    public static interface SvgElementColorPatcher {
        public void patchColors(@NotNull Element var1);

        public byte @Nullable [] digest();
    }
}

