/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import sqldelight.com.intellij.ui.paint.PaintUtil;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.com.intellij.ui.scale.ScaleContext;
import sqldelight.com.intellij.util.HiDPIScaledGraphics;
import sqldelight.com.intellij.util.ui.ImageUtil;
import sqldelight.org.imgscalr.Scalr;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class JBHiDPIScaledImage
extends BufferedImage {
    @Nullable
    private final Image myImage;
    private final double myUserWidth;
    private final double myUserHeight;
    private final double myScale;

    public JBHiDPIScaledImage(int width, int height, int type2) {
        this((double)width, (double)height, type2);
    }

    public JBHiDPIScaledImage(double width, double height, int type2) {
        this((GraphicsConfiguration)null, width, height, type2);
    }

    public JBHiDPIScaledImage(@Nullable Graphics2D g, int width, int height, int type2) {
        this(g, (double)width, (double)height, type2, PaintUtil.RoundingMode.FLOOR);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@Nullable Graphics2D g, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type2;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(0);
        }
        this(JBUIScale.sysScale(g), width, height, (int)type2, (PaintUtil.RoundingMode)rm);
    }

    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, int width, int height, int type2) {
        this(gc, (double)width, (double)height, type2);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@Nullable ScaleContext ctx, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type2;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(1);
        }
        this(JBUIScale.sysScale(ctx), width, height, (int)type2, (PaintUtil.RoundingMode)rm);
    }

    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, double width, double height, int type2) {
        this(gc, width, height, type2, PaintUtil.RoundingMode.FLOOR);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type2;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(2);
        }
        this(JBUIScale.sysScale(gc), width, height, (int)type2, (PaintUtil.RoundingMode)rm);
    }

    /*
     * WARNING - void declaration
     */
    private JBHiDPIScaledImage(double scale, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void type2;
        void rm;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(3);
        }
        super(rm.round(width * scale), rm.round(height * scale), (int)type2);
        this.myImage = null;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = scale;
    }

    public JBHiDPIScaledImage(@NotNull Image image, int width, int height, int type2) {
        if (image == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(4);
        }
        this(image, (double)width, (double)height, type2);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@NotNull Image image, double width, double height, int n) {
        void type2;
        if (image == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(5);
        }
        super(1, 1, (int)type2);
        this.myImage = image;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = this.myUserWidth > 0.0 ? (double)this.myImage.getWidth(null) / this.myUserWidth : 1.0;
    }

    public double getScale() {
        return this.myScale;
    }

    @NotNull
    public JBHiDPIScaledImage scale(double scaleFactor) {
        Image img = this.myImage == null ? this : this.myImage;
        int w = (int)(scaleFactor * (double)this.getRealWidth(null));
        int h = (int)(scaleFactor * (double)this.getRealHeight(null));
        if (w <= 0 || h <= 0) {
            JBHiDPIScaledImage jBHiDPIScaledImage = this;
            if (jBHiDPIScaledImage == null) {
                JBHiDPIScaledImage.$$$reportNull$$$0(6);
            }
            return jBHiDPIScaledImage;
        }
        BufferedImage scaled = Scalr.resize(ImageUtil.toBufferedImage(img), Scalr.Method.QUALITY, w, h, new BufferedImageOp[0]);
        double newUserWidth = (double)w / this.myScale;
        double newUserHeight = (double)h / this.myScale;
        if (this.myImage != null) {
            return new JBHiDPIScaledImage((Image)scaled, newUserWidth, newUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(this.myScale, newUserWidth, newUserHeight, this.getType(), PaintUtil.RoundingMode.ROUND);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, (int)Math.round(newUserWidth), (int)Math.round(newUserHeight), 0, 0, ((Image)scaled).getWidth(null), ((Image)scaled).getHeight(null), null);
        g.dispose();
        JBHiDPIScaledImage jBHiDPIScaledImage = newImg;
        if (jBHiDPIScaledImage == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(7);
        }
        return jBHiDPIScaledImage;
    }

    @NotNull
    public JBHiDPIScaledImage scale(int targetUserWidth, int targetUserHeight) {
        Image img = this.myImage == null ? this : this.myImage;
        int w = this.getUserWidth(null);
        int h = this.getUserHeight(null);
        if (w <= 0 || h <= 0 || w == targetUserWidth && h == targetUserHeight) {
            JBHiDPIScaledImage jBHiDPIScaledImage = this;
            if (jBHiDPIScaledImage == null) {
                JBHiDPIScaledImage.$$$reportNull$$$0(8);
            }
            return jBHiDPIScaledImage;
        }
        int targetWidth = (int)Math.round((double)targetUserWidth * this.myScale);
        int targetHeight = (int)Math.round((double)targetUserHeight * this.myScale);
        BufferedImage scaled = Scalr.resize(ImageUtil.toBufferedImage(img), Scalr.Method.QUALITY, Scalr.Mode.FIT_EXACT, targetWidth, targetHeight, new BufferedImageOp[0]);
        if (this.myImage != null) {
            return new JBHiDPIScaledImage((Image)scaled, targetUserWidth, targetUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(this.myScale, (double)targetUserWidth, (double)targetUserHeight, this.getType(), PaintUtil.RoundingMode.ROUND);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, targetUserWidth, targetUserHeight, 0, 0, ((Image)scaled).getWidth(null), ((Image)scaled).getHeight(null), null);
        g.dispose();
        JBHiDPIScaledImage jBHiDPIScaledImage = newImg;
        if (jBHiDPIScaledImage == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(9);
        }
        return jBHiDPIScaledImage;
    }

    public Image getDelegate() {
        return this.myImage;
    }

    @Override
    public int getWidth() {
        return this.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.getHeight(null);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.myImage != null ? this.getUserWidth(observer) : this.getRealWidth(observer);
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.myImage != null ? this.getUserHeight(observer) : this.getRealHeight(observer);
    }

    public int getUserWidth(ImageObserver observer) {
        return this.myImage != null ? (int)Math.round(this.myUserWidth) : (int)Math.round((double)super.getWidth(observer) / this.myScale);
    }

    public int getUserHeight(ImageObserver observer) {
        return this.myImage != null ? (int)Math.round(this.myUserHeight) : (int)Math.round((double)super.getHeight(observer) / this.myScale);
    }

    public int getRealWidth(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getWidth(observer) : super.getWidth(observer);
    }

    public int getRealHeight(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getHeight(observer) : super.getHeight(observer);
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g = super.createGraphics();
        if (this.myImage == null) {
            g.scale(this.myScale, this.myScale);
            return new HiDPIScaledGraphics(g);
        }
        return g;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/JBHiDPIScaledImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/JBHiDPIScaledImage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

