/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.util.Objects;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Iconable;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiManager;
import sqldelight.com.intellij.testFramework.LightVirtualFile;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

class FileIconKey {
    private final VirtualFile myFile;
    private final Project myProject;
    @Iconable.IconFlags
    private final int myFlags;
    @Nullable
    private final Language myInitialLanguage;
    private final long myStamp;

    FileIconKey(@NotNull VirtualFile file, @Nullable Project project, @Iconable.IconFlags int flags) {
        if (file == null) {
            FileIconKey.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myProject = project;
        this.myFlags = flags;
        this.myInitialLanguage = this.myFile instanceof LightVirtualFile ? ((LightVirtualFile)this.myFile).getLanguage() : null;
        this.myStamp = project == null ? 0L : PsiManager.getInstance(project).getModificationTracker().getModificationCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileIconKey)) {
            return false;
        }
        FileIconKey that = (FileIconKey)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        if (this.myStamp != that.myStamp) {
            return false;
        }
        if (!this.myFile.equals(that.myFile)) {
            return false;
        }
        if (!Objects.equals(this.myProject, that.myProject)) {
            return false;
        }
        return Objects.equals(this.myInitialLanguage, that.myInitialLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.myFile, this.myProject, this.myFlags, this.myStamp);
    }

    VirtualFile getFile() {
        return this.myFile;
    }

    Project getProject() {
        return this.myProject;
    }

    @Iconable.IconFlags
    int getFlags() {
        return this.myFlags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "sqldelight/com/intellij/util/FileIconKey", "<init>"));
    }
}

