/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.lang.ref.Reference;
import java.util.List;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Computable;
import sqldelight.com.intellij.openapi.util.Getter;
import sqldelight.com.intellij.openapi.util.ModificationTracker;
import sqldelight.com.intellij.openapi.util.RecursionGuard;
import sqldelight.com.intellij.openapi.util.RecursionManager;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.util.CachedValueProfiler;
import sqldelight.com.intellij.psi.util.CachedValueProvider;
import sqldelight.com.intellij.psi.util.ProfilingInfo;
import sqldelight.com.intellij.reference.SoftReference;
import sqldelight.com.intellij.util.ArrayUtil;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.CachedValueImpl;
import sqldelight.com.intellij.util.IdempotenceChecker;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.containers.NotNullList;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance(CachedValueImpl.class);
    private final boolean myTrackValue;
    private volatile SoftReference<Data<T>> myData;

    protected CachedValueBase(boolean trackValue) {
        this.myTrackValue = trackValue;
    }

    @NotNull
    private Data<T> computeData(@Nullable CachedValueProvider.Result<T> result) {
        ProfilingInfo profilingInfo;
        if (result == null) {
            return new Data<Object>(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY, ArrayUtil.EMPTY_LONG_ARRAY);
        }
        T value = result.getValue();
        Object[] inferredDependencies = this.normalizeDependencies(result);
        long[] inferredTimeStamps = new long[inferredDependencies.length];
        for (int i = 0; i < inferredDependencies.length; ++i) {
            inferredTimeStamps[i] = this.getTimeStamp(inferredDependencies[i]);
        }
        if (CachedValueProfiler.canProfile() && (profilingInfo = CachedValueProfiler.getInstance().getTemporaryInfo(result)) != null) {
            return new ProfilingData(value, inferredDependencies, inferredTimeStamps, profilingInfo);
        }
        return new Data<T>(value, inferredDependencies, inferredTimeStamps);
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.setData(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data) {
        this.myData = data == null ? null : new SoftReference<Data<Data<Data<Data<T>>>>>(data);
    }

    protected Object @NotNull [] normalizeDependencies(@NotNull CachedValueProvider.Result<T> result) {
        if (result == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        Object[] items = result.getDependencyItems();
        T value = result.getValue();
        Object[] rawDependencies = this.myTrackValue && value != null ? ArrayUtil.append(items, value) : items;
        NotNullList<Object> flattened = new NotNullList<Object>(rawDependencies.length);
        CachedValueBase.collectDependencies(flattened, rawDependencies);
        Object[] objectArray = ArrayUtil.toObjectArray(flattened);
        if (objectArray == null) {
            CachedValueBase.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data = this.getRawData();
        if (data != null) {
            if (this.isUpToDate(data)) {
                return data;
            }
            if (data instanceof ProfilingData) {
                ((ProfilingData)data).myProfilingInfo.valueDisposed();
            }
        }
        return null;
    }

    @Nullable
    private Data<T> getRawData() {
        return SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data data) {
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(2);
        }
        for (int i = 0; i < data.myDependencies.length; ++i) {
            Object dependency = data.myDependencies[i];
            if (!this.isDependencyOutOfDate(dependency, data.myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(3);
        }
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private static void collectDependencies(@NotNull List<Object> resultingDeps, Object @NotNull [] dependencies) {
        if (resultingDeps == null) {
            CachedValueBase.$$$reportNull$$$0(4);
        }
        if (dependencies == null) {
            CachedValueBase.$$$reportNull$$$0(5);
        }
        for (Object dependency : dependencies) {
            if (dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                CachedValueBase.collectDependencies(resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
        }
    }

    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(6);
        }
        if (dependency instanceof VirtualFile) {
            return ((VirtualFile)dependency).getModificationStamp();
        }
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(@NotNull CachedValueProvider.Result<T> result) {
        if (result == null) {
            CachedValueBase.$$$reportNull$$$0(7);
        }
        Data<T> data = this.computeData(result);
        this.setData(data);
        return data.getValue();
    }

    public abstract boolean isFromMyProject(@NotNull Project var1);

    public abstract Object getValueProvider();

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data = this.getUpToDateOrNull();
        if (data != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(data, this.getValueProvider(), () -> this.computeData(this.doCompute(param)));
            }
            return data.getValue();
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable<Data> calcData = () -> this.computeData(this.doCompute(param));
        data = RecursionManager.doPreventingRecursion(this, true, calcData);
        if (data == null) {
            data = calcData.compute();
        } else if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            do {
                boolean bl = reuse = (alreadyComputed = this.getRawData()) != null && this.isUpToDate(alreadyComputed);
                if (!reuse) continue;
                IdempotenceChecker.checkEquivalence(alreadyComputed, data, this.getValueProvider().getClass(), calcData);
            } while ((toReturn = this.cacheOrGetData(alreadyComputed, reuse ? null : data)) == null);
            return toReturn.getValue();
        }
        return data.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getValueProvider() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/CachedValueBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultingDeps";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/CachedValueBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDependencies";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOutOfDate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProfilingData<T>
    extends Data<T> {
        @NotNull
        private final ProfilingInfo myProfilingInfo;

        private ProfilingData(T value, Object @NotNull [] dependencies, long @NotNull [] timeStamps, @NotNull ProfilingInfo profilingInfo) {
            if (profilingInfo == null) {
                ProfilingData.$$$reportNull$$$0(0);
            }
            if (dependencies == null) {
                ProfilingData.$$$reportNull$$$0(1);
            }
            if (timeStamps == null) {
                ProfilingData.$$$reportNull$$$0(2);
            }
            super(value, dependencies, timeStamps);
            this.myProfilingInfo = profilingInfo;
        }

        @Override
        public T getValue() {
            this.myProfilingInfo.valueUsed();
            return super.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "profilingInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependencies";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeStamps";
                    break;
                }
            }
            objectArray[1] = "sqldelight/com/intellij/util/CachedValueBase$ProfilingData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class Data<T>
    implements Getter<T> {
        private final T myValue;
        private final Object @NotNull [] myDependencies;
        private final long @NotNull [] myTimeStamps;

        Data(T value, Object @NotNull [] dependencies, long @NotNull [] timeStamps) {
            if (dependencies == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (timeStamps == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myValue = value;
            this.myDependencies = dependencies;
            this.myTimeStamps = timeStamps;
        }

        public Object @NotNull [] getDependencies() {
            if (this.myDependencies == null) {
                Data.$$$reportNull$$$0(2);
            }
            return this.myDependencies;
        }

        public long @NotNull [] getTimeStamps() {
            if (this.myTimeStamps == null) {
                Data.$$$reportNull$$$0(3);
            }
            return this.myTimeStamps;
        }

        @Override
        public final T get() {
            return this.getValue();
        }

        public T getValue() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeStamps";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/CachedValueBase$Data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/CachedValueBase$Data";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeStamps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

