/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ui.icons;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.ui.icons.ImageType;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class IconLoadMeasurer {
    private static final Counter svgDecoding = new Counter("svg-decode");
    private static final Counter svgLoading = new Counter("svg-load");
    public static final Counter svgPreBuiltLoad = new Counter("svg-prebuilt");
    public static final Counter svgCacheWrite = new Counter("svg-cache-write");
    public static final Counter svgCacheRead = new Counter("svg-cache-read");
    private static final Counter decodingPng = new Counter("png-decode");
    private static final Counter loadingPng = new Counter("png-load");
    private static final Counter findIcon = new Counter("find-icon");
    private static final Counter findIconLoad = new Counter("find-icon-load");
    private static final Counter loadFromUrl = new Counter("load-from-url");
    private static final Counter loadFromResources = new Counter("load-from-resource");

    @NotNull
    public static List<Counter> getStats() {
        List<Counter> list = Arrays.asList(findIcon, findIconLoad, loadFromUrl, loadFromResources, svgLoading, svgDecoding, svgPreBuiltLoad, svgCacheRead, svgCacheWrite, loadingPng, decodingPng);
        if (list == null) {
            IconLoadMeasurer.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static void addDecoding(@NotNull ImageType type2, int duration) {
        if (type2 == null) {
            IconLoadMeasurer.$$$reportNull$$$0(1);
        }
        (type2 == ImageType.SVG ? svgDecoding : decodingPng).addDuration(duration);
    }

    public static void addLoading(@NotNull ImageType type2, int duration) {
        if (type2 == null) {
            IconLoadMeasurer.$$$reportNull$$$0(2);
        }
        (type2 == ImageType.SVG ? svgLoading : loadingPng).addDuration(duration);
    }

    public static void addFindIcon(long duration) {
        findIcon.addDuration(duration);
    }

    public static void addFindIconLoad(long duration) {
        findIconLoad.addDuration(duration);
    }

    public static void addLoadFromUrl(long duration) {
        loadFromUrl.addDuration(duration);
    }

    public static void addLoadFromResources(long duration) {
        loadFromResources.addDuration(duration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ui/icons/IconLoadMeasurer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ui/icons/IconLoadMeasurer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDecoding";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addLoading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Counter {
        private final String type;
        private final AtomicInteger counter;
        private final AtomicLong totalTime;

        public Counter(@NotNull String type2) {
            if (type2 == null) {
                Counter.$$$reportNull$$$0(0);
            }
            this.counter = new AtomicInteger();
            this.totalTime = new AtomicLong();
            this.type = type2;
        }

        @NotNull
        public String getType() {
            String string = this.type;
            if (string == null) {
                Counter.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getCounter() {
            return this.counter.get();
        }

        public long getTotalTime() {
            return this.totalTime.get();
        }

        public void addDurationStartedAt(long startTime) {
            if (startTime <= 0L) {
                return;
            }
            this.addDuration(StartUpMeasurer.getCurrentTime() - startTime);
        }

        public void addDuration(long duration) {
            this.counter.incrementAndGet();
            if (duration > 0L) {
                this.totalTime.getAndAdd(duration);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/ui/icons/IconLoadMeasurer$Counter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/ui/icons/IconLoadMeasurer$Counter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

