/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.SystemInfo;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class ComponentUtil {
    public static <T> T getClientProperty(@NotNull JComponent component, @NotNull Key<T> key) {
        if (component == null) {
            ComponentUtil.$$$reportNull$$$0(0);
        }
        if (key == null) {
            ComponentUtil.$$$reportNull$$$0(1);
        }
        return (T)component.getClientProperty(key);
    }

    public static <T> void putClientProperty(@NotNull JComponent component, @NotNull Key<T> key, T value) {
        if (component == null) {
            ComponentUtil.$$$reportNull$$$0(2);
        }
        if (key == null) {
            ComponentUtil.$$$reportNull$$$0(3);
        }
        component.putClientProperty(key, value);
    }

    public static boolean isDisableAutoRequestFocus() {
        return Registry.is("suppress.focus.stealing.disable.auto.request.focus", true) && !SystemInfo.isXfce && !SystemInfo.isI3;
    }

    public static boolean isMinimized(@Nullable Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)window;
        return frame.getExtendedState() == 1;
    }

    @NotNull
    public static Window getActiveWindow() {
        for (Window each : Window.getWindows()) {
            if (!each.isVisible() || !each.isActive()) continue;
            Window window = each;
            if (window == null) {
                ComponentUtil.$$$reportNull$$$0(4);
            }
            return window;
        }
        Frame frame = JOptionPane.getRootFrame();
        if (frame == null) {
            ComponentUtil.$$$reportNull$$$0(5);
        }
        return frame;
    }

    @NotNull
    public static Component findUltimateParent(@NotNull Component c) {
        if (c == null) {
            ComponentUtil.$$$reportNull$$$0(6);
        }
        Component parent = c;
        while (true) {
            Container nextParent;
            if ((nextParent = parent.getParent()) == null) {
                Component component = parent;
                if (component == null) {
                    ComponentUtil.$$$reportNull$$$0(7);
                }
                return component;
            }
            parent = nextParent;
        }
    }

    @Nullable
    public static Window getWindow(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    @Nullable
    public static Component findParentByCondition(@Nullable Component c, @NotNull Predicate<? super Component> condition) {
        if (condition == null) {
            ComponentUtil.$$$reportNull$$$0(8);
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!condition.test(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T getParentOfType(@NotNull Class<? extends T> type2, Component component) {
        if (type2 == null) {
            ComponentUtil.$$$reportNull$$$0(9);
        }
        while (component != null) {
            if (type2.isInstance(component)) {
                return (T)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ui/ComponentUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ui/ComponentUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUltimateParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUltimateParent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

