/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.List;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.components.ServiceManager;
import sqldelight.com.intellij.openapi.diagnostic.Attachment;
import sqldelight.com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.fileEditor.FileDocumentManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.FileViewProvider;
import sqldelight.com.intellij.psi.PsiCompiledElement;
import sqldelight.com.intellij.psi.PsiDocumentManager;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiFileFactory;
import sqldelight.com.intellij.psi.impl.DebugUtil;
import sqldelight.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import sqldelight.com.intellij.psi.stubs.IndexingStampInfo;
import sqldelight.com.intellij.psi.stubs.ManyProjectsStubIndexMismatch;
import sqldelight.com.intellij.psi.stubs.ObjectStubTree;
import sqldelight.com.intellij.psi.stubs.PsiFileStubImpl;
import sqldelight.com.intellij.psi.stubs.StubTree;
import sqldelight.com.intellij.psi.stubs.StubTreeBuilder;
import sqldelight.com.intellij.psi.stubs.UpToDateStubIndexMismatch;
import sqldelight.com.intellij.psi.tree.IStubFileElementType;
import sqldelight.com.intellij.util.Function;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            StubTreeLoader.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Nullable
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file) {
        if (file == null) {
            StubTreeLoader.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public RuntimeException stubTreeAndIndexDoNotMatch(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, @Nullable Throwable cause) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(2);
        }
        VirtualFile file = psiFile.getViewProvider().getVirtualFile();
        StubTree stubTreeFromIndex = (StubTree)this.readFromVFile(psiFile.getProject(), file);
        boolean compiled = psiFile instanceof PsiCompiledElement;
        Document document = compiled ? null : FileDocumentManager.getInstance().getDocument(file);
        IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(file);
        boolean upToDate = indexingStampInfo != null && indexingStampInfo.isUpToDate(document, file, psiFile);
        boolean canBePrebuilt = this.isPrebuilt(psiFile.getVirtualFile());
        String msg = "PSI and index do not match.\nPlease report the problem to JetBrains with the files attached\n";
        if (canBePrebuilt) {
            msg = msg + "This stub can have pre-built origin\n";
        }
        if (upToDate) {
            msg = msg + "INDEXED VERSION IS THE CURRENT ONE";
        }
        msg = msg + " file=" + psiFile;
        msg = msg + ", file.class=" + psiFile.getClass();
        msg = msg + ", file.lang=" + psiFile.getLanguage();
        msg = msg + ", modStamp=" + psiFile.getModificationStamp();
        if (!compiled) {
            String text = psiFile.getText();
            PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text);
            if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                boolean consistent = DebugUtil.psiToString(psiFile, true).equals(DebugUtil.psiToString(fromText, true));
                msg = consistent ? msg + "\n tree consistent" : msg + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
            }
        }
        if (stubTree != null) {
            msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
        }
        msg = msg + "\nlatestIndexedStub=" + stubTreeFromIndex;
        if (stubTreeFromIndex != null) {
            if (stubTree != null) {
                msg = msg + "\n   same size=" + (stubTree.getPlainList().size() == stubTreeFromIndex.getPlainList().size());
            }
            msg = msg + "\n   debugInfo=" + stubTreeFromIndex.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg = msg + "\n viewProvider=" + viewProvider;
        msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg = msg + "; file stamp: " + file.getModificationStamp();
        msg = msg + "; file modCount: " + file.getModificationCount();
        msg = msg + "; file length: " + file.getLength();
        if (document != null) {
            msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg = msg + "; doc stamp: " + document.getModificationStamp();
            msg = msg + "; doc size: " + document.getTextLength();
            msg = msg + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document);
        }
        msg = msg + "\nindexing info: " + indexingStampInfo;
        Attachment[] attachments = StubTreeLoader.createAttachments(stubTree, psiFile, file, stubTreeFromIndex);
        return this.hasPsiInManyProjects(file) ? StubTreeLoader.handleManyProjectsMismatch(msg, attachments, cause) : (upToDate ? StubTreeLoader.handleUpToDateMismatch(msg, attachments, cause) : new RuntimeExceptionWithAttachments(msg, cause, attachments));
    }

    protected abstract boolean isPrebuilt(@NotNull VirtualFile var1);

    private static RuntimeExceptionWithAttachments handleUpToDateMismatch(@NotNull String message, Attachment[] attachments, @Nullable Throwable cause) {
        if (message == null) {
            StubTreeLoader.$$$reportNull$$$0(3);
        }
        return new UpToDateStubIndexMismatch(message, cause, attachments);
    }

    private static RuntimeExceptionWithAttachments handleManyProjectsMismatch(@NotNull String message, Attachment[] attachments, @Nullable Throwable cause) {
        if (message == null) {
            StubTreeLoader.$$$reportNull$$$0(4);
        }
        return new ManyProjectsStubIndexMismatch(message, cause, attachments);
    }

    private static Attachment @NotNull [] createAttachments(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, VirtualFile file, @Nullable StubTree stubTreeFromIndex) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(5);
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.add(new Attachment(file.getPath() + "_file.txt", psiFile instanceof PsiCompiledElement ? "compiled" : psiFile.getText()));
        if (stubTree != null) {
            attachments.add(new Attachment("stubTree.txt", ((PsiFileStubImpl)stubTree.getRoot()).printTree()));
        }
        if (stubTreeFromIndex != null) {
            attachments.add(new Attachment("stubTreeFromIndex.txt", ((PsiFileStubImpl)stubTreeFromIndex.getRoot()).printTree()));
        }
        Attachment[] attachmentArray = attachments.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            StubTreeLoader.$$$reportNull$$$0(6);
        }
        return attachmentArray;
    }

    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider) {
        if (provider == null) {
            StubTreeLoader.$$$reportNull$$$0(7);
        }
        Function<PsiFile, String> fileClassName = file -> file.getClass().getSimpleName();
        Function<Pair, String> stubRootToString = pair -> "(" + ((IStubFileElementType)pair.first).toString() + ", " + ((IStubFileElementType)pair.first).getLanguage() + " -> " + (String)fileClassName.fun((PsiFile)pair.second) + ")";
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(provider);
        return ", stubBindingRoot = " + fileClassName.fun(provider.getStubBindingRoot()) + ", languages = [" + StringUtil.join(provider.getLanguages(), Language::getID, ", ") + "], fileTypes = [" + StringUtil.join(provider.getAllFiles(), file -> file.getFileType().getName(), ", ") + "], files = [" + StringUtil.join(provider.getAllFiles(), fileClassName, ", ") + "], roots = [" + StringUtil.join(roots, stubRootToString, ", ") + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/stubs/StubTreeLoader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/stubs/StubTreeLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasPsiInManyProjects";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStampInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stubTreeAndIndexDoNotMatch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleUpToDateMismatch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleManyProjectsMismatch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAttachments";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileViewProviderMismatchDiagnostics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

