/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.stubs.StubElement;
import sqldelight.com.intellij.psi.stubs.StubElementTypeHolderEP;
import sqldelight.com.intellij.psi.stubs.StubFieldAccessor;
import sqldelight.com.intellij.psi.stubs.StubSerializer;
import sqldelight.com.intellij.psi.tree.IElementType;
import sqldelight.gnu.trove.THashSet;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class IStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static volatile boolean ourInitializedStubs;
    private static volatile Set<String> ourLazyExternalIds;
    private static final Logger LOG;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (!this.isLazilyRegistered()) {
            IStubElementType.checkNotInstantiatedTooLate();
        }
    }

    public static void checkNotInstantiatedTooLate() {
        if (ourInitializedStubs) {
            LOG.error("All stub element types should be created before index initialization is complete.\nPlease add the class containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + Arrays.toString(StubElementTypeHolderEP.EP_NAME.getExtensions()));
        }
    }

    private boolean isLazilyRegistered() {
        try {
            return ourLazyExternalIds.contains(this.getExternalId());
        }
        catch (Throwable e) {
            return false;
        }
    }

    static void dropRegisteredTypes() {
        ourInitializedStubs = false;
    }

    static List<StubFieldAccessor> loadRegisteredStubElementTypes() {
        ArrayList<StubFieldAccessor> result = new ArrayList<StubFieldAccessor>();
        for (StubElementTypeHolderEP bean : StubElementTypeHolderEP.EP_NAME.getExtensionList()) {
            result.addAll(bean.initializeOptimized());
        }
        THashSet<String> lazyIds = new THashSet<String>();
        for (StubFieldAccessor accessor : result) {
            lazyIds.add(accessor.externalId);
        }
        ourInitializedStubs = true;
        ourLazyExternalIds = lazyIds;
        return result;
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    static {
        ourLazyExternalIds = Collections.emptySet();
        LOG = Logger.getInstance(IStubElementType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "sqldelight/com/intellij/psi/stubs/IStubElementType", "<init>"));
    }
}

