/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.search;

import sqldelight.com.intellij.lang.LanguageMatcher;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.search.FileLanguageGlobalScope;
import sqldelight.com.intellij.psi.search.GlobalSearchScope;
import sqldelight.com.intellij.psi.search.LocalSearchScope;
import sqldelight.com.intellij.psi.search.SearchScope;
import sqldelight.com.intellij.psi.util.PsiTreeUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class PsiSearchScopeUtil {
    @Nullable
    public static SearchScope union(@Nullable SearchScope a, @Nullable SearchScope b) {
        return a == null ? b : (b == null ? a : a.union(b));
    }

    public static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element) {
        if (scope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(1);
        }
        if (scope instanceof LocalSearchScope) {
            LocalSearchScope local = (LocalSearchScope)scope;
            return PsiSearchScopeUtil.isInScope(local, element);
        }
        GlobalSearchScope globalScope = (GlobalSearchScope)scope;
        return PsiSearchScopeUtil.isInScope(globalScope, element);
    }

    public static boolean isInScope(@NotNull GlobalSearchScope globalScope, @NotNull PsiElement element) {
        PsiFile file;
        if (globalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(3);
        }
        if ((file = element.getContainingFile()) == null) {
            return true;
        }
        while (file != null) {
            if (globalScope.contains(file.getOriginalFile().getViewProvider().getVirtualFile())) {
                return true;
            }
            PsiElement context = file.getContext();
            file = context == null ? null : context.getContainingFile();
        }
        return false;
    }

    public static boolean isInScope(@NotNull LocalSearchScope local, @NotNull PsiElement element) {
        PsiElement[] scopeElements;
        if (local == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement scopeElement : scopeElements = local.getScope()) {
            if (!PsiTreeUtil.isAncestor(scopeElement, element, false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static SearchScope restrictScopeTo(@NotNull SearchScope originalScope, FileType ... fileTypes) {
        if (originalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(6);
        }
        if (fileTypes == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(7);
        }
        if (originalScope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, fileTypes);
            if (globalSearchScope == null) {
                PsiSearchScopeUtil.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        LocalSearchScope localSearchScope = LocalSearchScope.getScopeRestrictedByFileTypes((LocalSearchScope)originalScope, fileTypes);
        if (localSearchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(9);
        }
        return localSearchScope;
    }

    @ApiStatus.Experimental
    @Contract(pure=true)
    @NotNull
    public static SearchScope restrictScopeToFileLanguage(@NotNull Project project, @NotNull SearchScope originalScope, @NotNull LanguageMatcher matcher) {
        if (project == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(10);
        }
        if (originalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(12);
        }
        if (originalScope instanceof GlobalSearchScope) {
            return new FileLanguageGlobalScope(project, (GlobalSearchScope)originalScope, matcher);
        }
        LocalSearchScope localSearchScope = LocalSearchScope.getScopeRestrictedByFileLanguage((LocalSearchScope)originalScope, matcher);
        if (localSearchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(13);
        }
        return localSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeTo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeToFileLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeTo";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeToFileLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

