/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import sqldelight.com.intellij.codeInspection.LocalQuickFix;
import sqldelight.com.intellij.openapi.extensions.ExtensionPointName;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.roots.ProjectFileIndex;
import sqldelight.com.intellij.openapi.roots.ProjectRootManager;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiFileSystemItem;
import sqldelight.com.intellij.psi.PsiManager;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class FileReferenceHelper {
    public static final ExtensionPointName<FileReferenceHelper> EP_NAME = new ExtensionPointName("sqldelight.com.intellij.psi.fileReferenceHelper");

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            FileReferenceHelper.$$$reportNull$$$0(0);
        }
        String string = url;
        if (string == null) {
            FileReferenceHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        List list = Collections.emptyList();
        if (list == null) {
            FileReferenceHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public PsiFileSystemItem getPsiFileSystemItem(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            FileReferenceHelper.$$$reportNull$$$0(3);
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        return FileReferenceHelper.getPsiFileSystemItem(psiManager, file);
    }

    public static PsiFileSystemItem getPsiFileSystemItem(PsiManager psiManager, VirtualFile file) {
        return file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
    }

    @Nullable
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            FileReferenceHelper.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            FileReferenceHelper.$$$reportNull$$$0(5);
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            FileReferenceHelper.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            FileReferenceHelper.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileReferenceHelper.$$$reportNull$$$0(8);
        }
        Collection<PsiFileSystemItem> collection = this.getRoots(module);
        if (collection == null) {
            FileReferenceHelper.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public abstract Collection<PsiFileSystemItem> getContexts(Project var1, @NotNull VirtualFile var2);

    public abstract boolean isMine(Project var1, @NotNull VirtualFile var2);

    public boolean isFallback() {
        return false;
    }

    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project, @NotNull VirtualFile file, boolean isAbsoluteReference) {
        if (project == null) {
            FileReferenceHelper.$$$reportNull$$$0(10);
        }
        if (file == null) {
            FileReferenceHelper.$$$reportNull$$$0(11);
        }
        if (isAbsoluteReference) {
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            Module module = index.getModuleForFile(file);
            if (module == null) {
                List<FileTargetContext> list = Collections.emptyList();
                if (list == null) {
                    FileReferenceHelper.$$$reportNull$$$0(12);
                }
                return list;
            }
            List<FileTargetContext> list = ContainerUtil.map(this.getRoots(module, file), FileTargetContext::new);
            if (list == null) {
                FileReferenceHelper.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<FileTargetContext> list = ContainerUtil.map(this.getContexts(project, file), FileTargetContext::new);
        if (list == null) {
            FileReferenceHelper.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileSystemItem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContexts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

