/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl.smartPointers;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.editor.event.DocumentEvent;
import sqldelight.com.intellij.openapi.editor.impl.FrozenDocument;
import sqldelight.com.intellij.openapi.fileEditor.FileDocumentManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.ProperTextRange;
import sqldelight.com.intellij.openapi.util.TextRange;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiDocumentManager;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiInvalidElementAccessException;
import sqldelight.com.intellij.psi.SmartPointerManager;
import sqldelight.com.intellij.psi.SmartPsiElementPointer;
import sqldelight.com.intellij.psi.SmartPsiFileRange;
import sqldelight.com.intellij.psi.impl.PsiDocumentManagerBase;
import sqldelight.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPointerEx;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import sqldelight.com.intellij.psi.util.PsiUtilCore;
import sqldelight.com.intellij.reference.SoftReference;
import sqldelight.com.intellij.testFramework.LightVirtualFile;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class SmartPointerManagerImpl
extends SmartPointerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SmartPointerManagerImpl.class);
    private final Project myProject;
    private final PsiDocumentManagerBase myPsiDocManager;
    private final Key<WeakReference<SmartPointerTracker>> LIGHT_TRACKER_KEY;
    private final ConcurrentMap<VirtualFile, SmartPointerTracker> myPhysicalTrackers;
    private static final Key<Reference<SmartPsiElementPointerImpl<?>>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(0);
        }
        this.myPhysicalTrackers = ContainerUtil.createConcurrentWeakValueMap();
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        this.LIGHT_TRACKER_KEY = Key.create("SMART_POINTERS " + (project.isDefault() ? "default" : Integer.valueOf(project.hashCode())));
    }

    @Override
    public void dispose() {
        SmartPointerTracker.processQueue();
    }

    @NotNull
    private static String anonymize(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(1);
        }
        String string = (project.isDisposed() ? "(Disposed)" : "") + (project.isDefault() ? "(Default)" : "") + project.hashCode();
        if (string == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void fastenBelts(@NotNull VirtualFile file) {
        SmartPointerTracker pointers;
        if (file == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(3);
        }
        if ((pointers = this.getTracker(file)) != null) {
            pointers.fastenBelts(this);
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(5);
        }
        return smartPsiElementPointer;
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(6);
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile, false);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(7);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(8);
        }
        SmartPointerManagerImpl.ensureValid(element, containingFile);
        SmartPointerTracker.processQueue();
        this.ensureMyProject(containingFile != null ? containingFile.getProject() : element.getProject());
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (!(pointer == null || pointer.getElementInfo() instanceof SelfElementInfo && ((SelfElementInfo)pointer.getElementInfo()).isForInjected() != forInjected || pointer.incrementAndGetReferenceCount(1) <= 0)) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                SmartPointerManagerImpl.$$$reportNull$$$0(9);
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPsiElementPointerImpl<E>>(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(10);
        }
        return smartPsiElementPointerImpl;
    }

    private void ensureMyProject(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(11);
        }
        if (project != this.myProject) {
            throw new IllegalArgumentException("Element from alien project: " + SmartPointerManagerImpl.anonymize(project) + " expected: " + SmartPointerManagerImpl.anonymize(this.myProject));
        }
    }

    private static void ensureValid(@NotNull PsiElement element, @Nullable PsiFile containingFile) {
        boolean valid;
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(12);
        }
        boolean bl = valid = containingFile != null ? containingFile.isValid() : element.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element);
            if (containingFile != null && !containingFile.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)containingFile, "Element " + element.getClass() + "(" + element.getLanguage() + ") claims to be valid but returns invalid containing file ");
            }
        }
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        Reference<SmartPsiElementPointerImpl<?>> data;
        SmartPsiElementPointerImpl<?> cachedPointer;
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(13);
        }
        if ((cachedPointer = SoftReference.dereference(data = element.getUserData(CACHED_SMART_POINTER_KEY))) != null && (cachedElement = cachedPointer.getElement()) != element) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(14);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(15);
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file, range, false);
        if (smartPsiFileRange == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(16);
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range, boolean forInjected) {
        if (file == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(17);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(18);
        }
        PsiUtilCore.ensureValid(file);
        SmartPointerTracker.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(this, file, ProperTextRange.create(range), forInjected);
        this.trackPointer(pointer, file.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(19);
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerElementInfo info;
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(20);
        }
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(21);
        }
        if (!((info = pointer.getElementInfo()) instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker tracker = this.getTracker(containingFile);
        if (tracker == null) {
            tracker = this.getOrCreateTracker(containingFile);
        }
        tracker.addReference(pointer);
    }

    @Override
    public void removePointer(@NotNull SmartPsiElementPointer<?> pointer) {
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(22);
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        this.ensureMyProject(pointer.getProject());
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == -1) {
            LOG.error("Double smart pointer removal");
            return;
        }
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            SmartPointerTracker.PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (reference != null) {
                if (reference.get() != pointer) {
                    throw new IllegalStateException("Reference points to " + reference.get());
                }
                reference.tracker.removeReference(reference);
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile file) {
        if (file == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(23);
        }
        return file instanceof LightVirtualFile ? (SmartPointerTracker)SoftReference.dereference(file.getUserData(this.LIGHT_TRACKER_KEY)) : (SmartPointerTracker)this.myPhysicalTrackers.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private SmartPointerTracker getOrCreateTracker(@NotNull VirtualFile file) {
        if (file == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(24);
        }
        ConcurrentMap<VirtualFile, SmartPointerTracker> concurrentMap = this.myPhysicalTrackers;
        // MONITORENTER : concurrentMap
        SmartPointerTracker tracker = this.getTracker(file);
        if (tracker == null) {
            tracker = new SmartPointerTracker();
            if (file instanceof LightVirtualFile) {
                file.putUserData(this.LIGHT_TRACKER_KEY, new WeakReference<SmartPointerTracker>(tracker));
            } else {
                this.myPhysicalTrackers.put(file, tracker);
            }
        }
        SmartPointerTracker smartPointerTracker = tracker;
        // MONITOREXIT : concurrentMap
        if (smartPointerTracker != null) return smartPointerTracker;
        SmartPointerManagerImpl.$$$reportNull$$$0(25);
        return smartPointerTracker;
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        VirtualFile file;
        SmartPointerTracker pointers;
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(26);
        }
        return (pointers = this.getTracker(file = containingFile.getViewProvider().getVirtualFile())) == null ? 0 : pointers.getSize();
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer<?> pointer1, @NotNull SmartPsiElementPointer<?> pointer2) {
        if (pointer1 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(27);
        }
        if (pointer2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(28);
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(@NotNull Document document, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        VirtualFile file;
        SmartPointerTracker list;
        if (document == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(29);
        }
        if (frozen == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(30);
        }
        if (events == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(31);
        }
        SmartPointerTracker smartPointerTracker = list = (file = FileDocumentManager.getInstance().getFile(document)) == null ? null : this.getTracker(file);
        if (list != null) {
            list.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file) {
        SmartPointerTracker list;
        if (file == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(32);
        }
        if ((list = this.getTracker(file)) != null) {
            list.updatePointerTargetsAfterReparse();
        }
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(33);
        }
        return project;
    }

    @NotNull
    PsiDocumentManagerBase getPsiDocumentManager() {
        PsiDocumentManagerBase psiDocumentManagerBase = this.myPsiDocManager;
        if (psiDocumentManagerBase == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(34);
        }
        return psiDocumentManagerBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 25: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 25: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 25: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 3: 
            case 14: 
            case 17: 
            case 23: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "anonymize";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiElementPointer";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiFileRangePointer";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTracker";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiDocumentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "anonymize";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 25: 
            case 33: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fastenBelts";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiElementPointer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureMyProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPointer";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiFileRangePointer";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "trackPointer";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removePointer";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTracker";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTracker";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPointersNumber";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "pointToTheSameElement";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updatePointers";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updatePointerTargetsAfterReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 25: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

