/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi;

import sqldelight.com.intellij.core.JavaPsiBundle;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.psi.JavaPsiFacade;
import sqldelight.com.intellij.psi.JavaResolveResult;
import sqldelight.com.intellij.psi.LambdaUtil;
import sqldelight.com.intellij.psi.PsiArrayType;
import sqldelight.com.intellij.psi.PsiCapturedWildcardType;
import sqldelight.com.intellij.psi.PsiClass;
import sqldelight.com.intellij.psi.PsiClassType;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiExpression;
import sqldelight.com.intellij.psi.PsiJavaCodeReferenceElement;
import sqldelight.com.intellij.psi.PsiKeyword;
import sqldelight.com.intellij.psi.PsiMethod;
import sqldelight.com.intellij.psi.PsiMethodReferenceExpression;
import sqldelight.com.intellij.psi.PsiPrimitiveType;
import sqldelight.com.intellij.psi.PsiReferenceExpression;
import sqldelight.com.intellij.psi.PsiSubstitutor;
import sqldelight.com.intellij.psi.PsiType;
import sqldelight.com.intellij.psi.PsiTypeElement;
import sqldelight.com.intellij.psi.PsiTypeParameter;
import sqldelight.com.intellij.psi.PsiWildcardType;
import sqldelight.com.intellij.psi.util.MethodSignature;
import sqldelight.com.intellij.psi.util.PsiTypesUtil;
import sqldelight.com.intellij.psi.util.PsiUtil;
import sqldelight.com.intellij.psi.util.TypeConversionUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceUtil {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceUtil.class);

    public static boolean isSecondSearchPossible(PsiType[] parameterTypes, QualifierResolveResult qualifierResolveResult, PsiMethodReferenceExpression methodRef) {
        return parameterTypes.length > 0 && !(parameterTypes[0] instanceof PsiPrimitiveType) && !methodRef.isConstructor() && PsiMethodReferenceUtil.isStaticallyReferenced(methodRef) && PsiMethodReferenceUtil.isReceiverType(parameterTypes[0], qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor());
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef) {
        PsiElement resolve;
        if (methodRef == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(0);
        }
        if ((resolve = methodRef.resolve()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve;
            PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
            PsiClassType.ClassResolveResult functionalResolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalResolveResult);
            return interfaceMethod != null && PsiMethodReferenceUtil.isResolvedBySecondSearch(methodRef, interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, functionalResolveResult)), method.isVarArgs(), method.hasModifierProperty("static"), method.getParameterList().getParametersCount());
        }
        return false;
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef, @Nullable MethodSignature signature, boolean varArgs, boolean isStatic, int parametersCount) {
        if (methodRef == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            return false;
        }
        QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(methodRef);
        PsiType[] functionalMethodParameterTypes = signature.getParameterTypes();
        return (parametersCount + 1 == functionalMethodParameterTypes.length && !varArgs || varArgs && functionalMethodParameterTypes.length > 0 && !isStatic) && PsiMethodReferenceUtil.isSecondSearchPossible(functionalMethodParameterTypes, qualifierResolveResult, methodRef);
    }

    @Nullable
    public static PsiType getQualifierType(PsiMethodReferenceExpression expression) {
        PsiTypeElement typeElement = expression.getQualifierType();
        if (typeElement != null) {
            return typeElement.getType();
        }
        PsiType qualifierType = null;
        PsiElement qualifier = expression.getQualifier();
        if (qualifier instanceof PsiExpression) {
            qualifierType = ((PsiExpression)qualifier).getType();
        }
        if (qualifierType == null && qualifier instanceof PsiReferenceExpression) {
            return JavaPsiFacade.getElementFactory(expression.getProject()).createType((PsiReferenceExpression)qualifier);
        }
        return qualifierType;
    }

    public static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression, JavaResolveResult result, PsiType functionalInterfaceType) {
        return PsiMethodReferenceUtil.isReturnTypeCompatible(expression, result, functionalInterfaceType, null);
    }

    public static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression) {
        return PsiMethodReferenceUtil.getMethodReferenceReturnType(expression, expression.advancedResolve(false));
    }

    private static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result) {
        PsiSubstitutor subst = result.getSubstitutor();
        PsiType methodReturnType = null;
        PsiClass containingClass = null;
        PsiElement resolve = result.getElement();
        if (resolve instanceof PsiMethod) {
            containingClass = ((PsiMethod)resolve).getContainingClass();
            methodReturnType = PsiTypesUtil.patchMethodGetClassReturnType(expression, (PsiMethod)resolve);
            if (methodReturnType == null) {
                methodReturnType = ((PsiMethod)resolve).getReturnType();
                if (PsiType.VOID.equals(methodReturnType)) {
                    return methodReturnType;
                }
                methodReturnType = subst.substitute(methodReturnType);
            }
        } else if (resolve instanceof PsiClass) {
            PsiTypeParameter[] typeParameters;
            if (PsiUtil.isArrayClass(resolve) && (typeParameters = ((PsiClass)resolve).getTypeParameters()).length == 1) {
                PsiType arrayComponentType = subst.substitute(typeParameters[0]);
                if (arrayComponentType == null) {
                    return null;
                }
                methodReturnType = arrayComponentType.createArrayType();
            }
            containingClass = (PsiClass)resolve;
        }
        if (methodReturnType == null) {
            if (containingClass == null) {
                return null;
            }
            methodReturnType = JavaPsiFacade.getElementFactory(expression.getProject()).createType(containingClass, subst);
        }
        return PsiUtil.captureToplevelWildcards(methodReturnType, expression);
    }

    private static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression, JavaResolveResult result, PsiType functionalInterfaceType, Ref<? super String> errorMessage) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod != null) {
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
            if (PsiType.VOID.equals(interfaceReturnType) || interfaceReturnType == null) {
                return true;
            }
            PsiType methodReturnType = PsiMethodReferenceUtil.getMethodReferenceReturnType(expression, result);
            if (methodReturnType == null) {
                return false;
            }
            if (TypeConversionUtil.isAssignable(interfaceReturnType, methodReturnType)) {
                return true;
            }
            if (errorMessage != null) {
                errorMessage.set(JavaPsiBundle.message("bad.return.type.in.method.reference", methodReturnType.getCanonicalText(), interfaceReturnType.getCanonicalText()));
            }
        }
        return false;
    }

    public static boolean isValidQualifier(PsiMethodReferenceExpression expression) {
        PsiElement referenceNameElement = expression.getReferenceNameElement();
        if (referenceNameElement instanceof PsiKeyword) {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier instanceof PsiTypeElement) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static QualifierResolveResult getQualifierResolveResult(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(2);
        }
        PsiClass containingClass = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiExpression expression = methodReferenceExpression.getQualifierExpression();
        if (expression != null) {
            JavaResolveResult resolveResult;
            PsiElement resolve;
            PsiType expressionType = expression.getType();
            expressionType = expressionType instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)expressionType).getUpperBound() : PsiMethodReferenceUtil.replaceArrayType(expressionType, expression);
            PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(expressionType);
            containingClass = result.getElement();
            if (containingClass != null) {
                substitutor = result.getSubstitutor();
            }
            if (containingClass == null && expression instanceof PsiReferenceExpression && (resolve = (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                containingClass = (PsiClass)resolve;
                substitutor = resolveResult.getSubstitutor();
                return new QualifierResolveResult(containingClass, substitutor, true);
            }
        } else {
            PsiType type2;
            PsiClassType.ClassResolveResult result;
            PsiTypeElement typeElement = methodReferenceExpression.getQualifierType();
            if (typeElement != null && (containingClass = (result = PsiUtil.resolveGenericsClassInType(type2 = PsiMethodReferenceUtil.replaceArrayType(typeElement.getType(), typeElement))).getElement()) != null) {
                return new QualifierResolveResult(containingClass, result.getSubstitutor(), true);
            }
        }
        return new QualifierResolveResult(containingClass, substitutor, false);
    }

    public static boolean isStaticallyReferenced(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        PsiExpression qualifierExpression;
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(3);
        }
        if ((qualifierExpression = methodReferenceExpression.getQualifierExpression()) != null) {
            return qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass;
        }
        return true;
    }

    public static boolean isReceiverType(@Nullable PsiType receiverType, PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        if (receiverType == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable(JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, psiSubstitutor), PsiMethodReferenceUtil.replaceArrayType(receiverType, containingClass));
    }

    public static PsiType getFirstParameterType(PsiType functionalInterfaceType, PsiElement context) {
        int interfaceMethodParamsLength;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        MethodSignature function = LambdaUtil.getFunction(resolveResult.getElement());
        if (function != null && (interfaceMethodParamsLength = function.getParameterTypes().length) > 0) {
            PsiType type2 = resolveResult.getSubstitutor().substitute(function.getParameterTypes()[0]);
            return type2 != null ? PsiUtil.captureToplevelWildcards(type2, context) : null;
        }
        return null;
    }

    private static PsiType replaceArrayType(PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof PsiArrayType) {
            type2 = JavaPsiFacade.getElementFactory(context.getProject()).getArrayClassType(((PsiArrayType)type2).getComponentType(), PsiUtil.getLanguageLevel(context));
        }
        return type2;
    }

    public static String checkTypeArguments(PsiTypeElement qualifier, PsiType psiType) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiType instanceof PsiClassType && (referenceElement = qualifier.getInnermostComponentReferenceElement()) != null) {
            PsiType[] typeParameters;
            for (PsiType typeParameter : typeParameters = referenceElement.getTypeParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]);
            }
        }
        return null;
    }

    public static String checkReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result, PsiType functionalInterfaceType) {
        Ref errorMessage = Ref.create();
        if (!PsiMethodReferenceUtil.isReturnTypeCompatible(expression, result, functionalInterfaceType, errorMessage)) {
            return (String)errorMessage.get();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/psi/PsiMethodReferenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedBySecondSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierResolveResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStaticallyReferenced";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceArrayType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class QualifierResolveResult {
        private final PsiClass myContainingClass;
        private final PsiSubstitutor mySubstitutor;
        private final boolean myReferenceTypeQualified;

        public QualifierResolveResult(PsiClass containingClass, PsiSubstitutor substitutor, boolean referenceTypeQualified) {
            this.myContainingClass = containingClass;
            this.mySubstitutor = substitutor;
            this.myReferenceTypeQualified = referenceTypeQualified;
        }

        @Nullable
        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public boolean isReferenceTypeQualified() {
            return this.myReferenceTypeQualified;
        }
    }
}

