/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import sqldelight.com.intellij.openapi.diagnostic.Attachment;
import sqldelight.com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import sqldelight.com.intellij.openapi.util.objectTree.ThrowableInterner;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class TraceableDisposable {
    private final Throwable CREATE_TRACE;
    private Throwable KILL_TRACE;

    public TraceableDisposable(boolean debug) {
        this.CREATE_TRACE = debug ? ThrowableInterner.intern(new Throwable()) : null;
    }

    public void kill(@NonNls @Nullable String msg) {
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = ThrowableInterner.intern(new Throwable(msg));
        }
    }

    public void killExceptionally(@NotNull Throwable throwable) {
        if (throwable == null) {
            TraceableDisposable.$$$reportNull$$$0(0);
        }
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = throwable;
        }
    }

    public void throwObjectNotDisposedError(@NonNls @NotNull String msg) {
        if (msg == null) {
            TraceableDisposable.$$$reportNull$$$0(1);
        }
        throw new ObjectNotDisposedException(msg);
    }

    public void throwDisposalError(@NonNls String msg) throws RuntimeException {
        throw new DisposalException(msg);
    }

    @NotNull
    public String getStackTrace() {
        StringWriter s = new StringWriter();
        PrintWriter out = new PrintWriter(s);
        if (this.CREATE_TRACE != null) {
            out.println("--------------Creation trace: ");
            this.CREATE_TRACE.printStackTrace(out);
        }
        if (this.KILL_TRACE != null) {
            out.println("--------------Kill trace: ");
            this.KILL_TRACE.printStackTrace(out);
        }
        out.println("-------------Own trace:");
        new DisposalException("" + System.identityHashCode(this)).printStackTrace(out);
        out.flush();
        String string = s.toString();
        if (string == null) {
            TraceableDisposable.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/util/TraceableDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/util/TraceableDisposable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "killExceptionally";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwObjectNotDisposedError";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DisposalException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private DisposalException(String message) {
            super(message);
        }

        @Override
        public Attachment @NotNull [] getAttachments() {
            SmartList<Attachment> answer = new SmartList<Attachment>();
            if (TraceableDisposable.this.CREATE_TRACE != null) {
                answer.add(new Attachment("creation", TraceableDisposable.this.CREATE_TRACE));
            }
            if (TraceableDisposable.this.KILL_TRACE != null) {
                answer.add(new Attachment("kill", TraceableDisposable.this.KILL_TRACE));
            }
            Attachment[] attachmentArray = answer.toArray(Attachment.EMPTY_ARRAY);
            if (attachmentArray == null) {
                DisposalException.$$$reportNull$$$0(0);
            }
            return attachmentArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/openapi/util/TraceableDisposable$DisposalException", "getAttachments"));
        }
    }

    private final class ObjectNotDisposedException
    extends RuntimeException
    implements ExceptionWithAttachments {
        ObjectNotDisposedException(String msg) {
            super(msg);
            TraceableDisposable.this.KILL_TRACE = ThrowableInterner.intern(new Throwable(msg));
        }

        @Override
        public Attachment @NotNull [] getAttachments() {
            Attachment[] attachmentArray = new Attachment[]{new Attachment("kill", TraceableDisposable.this.KILL_TRACE)};
            if (attachmentArray == null) {
                ObjectNotDisposedException.$$$reportNull$$$0(0);
            }
            return attachmentArray;
        }

        @Override
        public void printStackTrace(@NotNull PrintStream s) {
            if (s == null) {
                ObjectNotDisposedException.$$$reportNull$$$0(1);
            }
            PrintWriter writer2 = new PrintWriter(s);
            this.printStackTrace(writer2);
            writer2.flush();
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(TraceableDisposable.this.CREATE_TRACE.getStackTrace()));
            stack.remove(0);
            s.write(ObjectNotDisposedException.class.getCanonicalName() + ": See stack trace responsible for creation of unreleased object below \n\tat " + StringUtil.join(stack, "\n\tat "));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/util/TraceableDisposable$ObjectNotDisposedException";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttachments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/util/TraceableDisposable$ObjectNotDisposedException";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "printStackTrace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

