/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util;

import sqldelight.com.intellij.openapi.util.Factory;
import sqldelight.com.intellij.openapi.util.RecursionGuard;
import sqldelight.com.intellij.openapi.util.RecursionManager;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class NullableLazyValue<T> {
    private boolean myComputed;
    @Nullable
    private T myValue;

    @Nullable
    protected abstract T compute();

    @Nullable
    public T getValue() {
        T value = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    @NotNull
    public static <T> NullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value) {
        if (value == null) {
            NullableLazyValue.$$$reportNull$$$0(0);
        }
        return new NullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "sqldelight/com/intellij/openapi/util/NullableLazyValue", "createValue"));
    }
}

