/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.libraries;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.module.ModuleManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.roots.JdkOrderEntry;
import sqldelight.com.intellij.openapi.roots.LibraryOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleRootManager;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEnumerator;
import sqldelight.com.intellij.openapi.roots.OrderRootType;
import sqldelight.com.intellij.openapi.roots.ProjectRootManager;
import sqldelight.com.intellij.openapi.roots.impl.libraries.LibraryEx;
import sqldelight.com.intellij.openapi.roots.libraries.Library;
import sqldelight.com.intellij.openapi.roots.libraries.LibraryTable;
import sqldelight.com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.PathUtil;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.text.StringTokenizer;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isClassAvailableInLibrary(@NotNull Library library, @NotNull String fqn) {
        if (library == null) {
            LibraryUtil.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(1);
        }
        return LibraryUtil.isClassAvailableInLibrary(library.getFiles(OrderRootType.CLASSES), fqn);
    }

    public static boolean isClassAvailableInLibrary(VirtualFile @NotNull [] files, @NotNull String fqn) {
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(2);
        }
        if (files == null) {
            LibraryUtil.$$$reportNull$$$0(3);
        }
        return LibraryUtil.isClassAvailableInLibrary(Arrays.asList(files), fqn);
    }

    public static boolean isClassAvailableInLibrary(@NotNull List<? extends VirtualFile> files, @NotNull String fqn) {
        if (files == null) {
            LibraryUtil.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(5);
        }
        for (VirtualFile virtualFile : files) {
            if (!LibraryUtil.findInFile(virtualFile, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Library findLibraryByClass(@NotNull String fqn, @Nullable Project project) {
        LibraryTable projectTable;
        Library library;
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(6);
        }
        if (project != null && (library = LibraryUtil.findInTable(projectTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project), fqn)) != null) {
            return library;
        }
        LibraryTable table2 = LibraryTablesRegistrar.getInstance().getLibraryTable();
        return LibraryUtil.findInTable(table2, fqn);
    }

    private static boolean findInFile(@NotNull VirtualFile file, @NotNull StringTokenizer tokenizer) {
        VirtualFile child;
        if (file == null) {
            LibraryUtil.$$$reportNull$$$0(7);
        }
        if (tokenizer == null) {
            LibraryUtil.$$$reportNull$$$0(8);
        }
        if (!tokenizer.hasMoreTokens()) {
            return true;
        }
        StringBuilder name = new StringBuilder(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            name.append(".class");
        }
        return (child = file.findChild(name.toString())) != null && LibraryUtil.findInFile(child, tokenizer);
    }

    @Nullable
    private static Library findInTable(@NotNull LibraryTable table2, @NotNull String fqn) {
        if (table2 == null) {
            LibraryUtil.$$$reportNull$$$0(9);
        }
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(10);
        }
        for (Library library : table2.getLibraries()) {
            if (!LibraryUtil.isClassAvailableInLibrary(library, fqn)) continue;
            return library;
        }
        return null;
    }

    @NotNull
    public static Library createLibrary(@NotNull LibraryTable libraryTable, @NonNls @NotNull String baseName) {
        if (libraryTable == null) {
            LibraryUtil.$$$reportNull$$$0(11);
        }
        if (baseName == null) {
            LibraryUtil.$$$reportNull$$$0(12);
        }
        String name = baseName;
        int count = 2;
        while (libraryTable.getLibraryByName(name) != null) {
            name = baseName + " (" + count++ + ")";
        }
        Library library = libraryTable.createLibrary(name);
        if (library == null) {
            LibraryUtil.$$$reportNull$$$0(13);
        }
        return library;
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull Project project) {
        if (project == null) {
            LibraryUtil.$$$reportNull$$$0(14);
        }
        return LibraryUtil.getLibraryRoots(project, true, true);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull Project project, boolean includeSourceFiles, boolean includeJdk) {
        if (project == null) {
            LibraryUtil.$$$reportNull$$$0(15);
        }
        return LibraryUtil.getLibraryRoots(ModuleManager.getInstance(project).getModules(), includeSourceFiles, includeJdk);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(Module @NotNull [] modules, boolean includeSourceFiles, boolean includeJdk) {
        if (modules == null) {
            LibraryUtil.$$$reportNull$$$0(16);
        }
        HashSet roots = new HashSet();
        for (Module module : modules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                VirtualFile[] files;
                if (entry instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    if (library == null) continue;
                    VirtualFile[] virtualFileArray = files = includeSourceFiles ? library.getFiles(OrderRootType.SOURCES) : null;
                    if (files == null || files.length == 0) {
                        files = library.getFiles(OrderRootType.CLASSES);
                    }
                    ContainerUtil.addAll(roots, files);
                    continue;
                }
                if (!includeJdk || !(entry instanceof JdkOrderEntry)) continue;
                JdkOrderEntry jdkEntry = (JdkOrderEntry)entry;
                VirtualFile[] virtualFileArray = files = includeSourceFiles ? jdkEntry.getRootFiles(OrderRootType.SOURCES) : null;
                if (files == null || files.length == 0) {
                    files = jdkEntry.getRootFiles(OrderRootType.CLASSES);
                }
                ContainerUtil.addAll(roots, files);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            LibraryUtil.$$$reportNull$$$0(17);
        }
        return virtualFileArray;
    }

    @Nullable
    public static Library findLibrary(@NotNull Module module, @NotNull String name) {
        if (module == null) {
            LibraryUtil.$$$reportNull$$$0(18);
        }
        if (name == null) {
            LibraryUtil.$$$reportNull$$$0(19);
        }
        Ref<Object> result = Ref.create(null);
        OrderEnumerator.orderEntries(module).forEachLibrary(library -> {
            if (name.equals(library.getName())) {
                result.set(library);
                return false;
            }
            return true;
        });
        return result.get();
    }

    @Nullable
    public static OrderEntry findLibraryEntry(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            LibraryUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            LibraryUtil.$$$reportNull$$$0(21);
        }
        List<OrderEntry> entries = ProjectRootManager.getInstance(project).getFileIndex().getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry)) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public static String getPresentableName(@NotNull Library library) {
        String name;
        if (library == null) {
            LibraryUtil.$$$reportNull$$$0(22);
        }
        if ((name = library.getName()) != null) {
            String string = name;
            if (string == null) {
                LibraryUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        if (library instanceof LibraryEx && ((LibraryEx)library).isDisposed()) {
            return "Disposed Library";
        }
        String[] urls = library.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            String string = PathUtil.getFileName(VfsUtilCore.urlToPath(urls[0]));
            if (string == null) {
                LibraryUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        return "Empty Library";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/libraries/LibraryUtil";
                break;
            }
            case 14: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/libraries/LibraryUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClassAvailableInLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryByClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findInFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInTable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 24: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryEntry";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

