/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.roots.CompilerModuleExtension;
import sqldelight.com.intellij.openapi.roots.ContentEntry;
import sqldelight.com.intellij.openapi.roots.ModuleOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleRootModel;
import sqldelight.com.intellij.openapi.roots.ModuleSourceOrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEnumerationHandler;
import sqldelight.com.intellij.openapi.roots.OrderRootType;
import sqldelight.com.intellij.openapi.roots.OrderRootsEnumerator;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import sqldelight.com.intellij.openapi.roots.impl.OrderRootsCache;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.NotNullFunction;
import sqldelight.com.intellij.util.PathsList;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

class OrderRootsEnumeratorImpl
implements OrderRootsEnumerator {
    private static final Logger LOG = Logger.getInstance(OrderRootsEnumeratorImpl.class);
    private final OrderEnumeratorBase myOrderEnumerator;
    private final OrderRootType myRootType;
    private final NotNullFunction<? super OrderEntry, ? extends OrderRootType> myRootTypeProvider;
    private boolean myUsingCache;
    private NotNullFunction<? super OrderEntry, VirtualFile[]> myCustomRootProvider;
    private boolean myWithoutSelfModuleOutput;

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull OrderRootType rootType) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(0);
        }
        if (rootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(1);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = rootType;
        this.myRootTypeProvider = null;
    }

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(2);
        }
        if (rootTypeProvider == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(3);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = null;
        this.myRootTypeProvider = rootTypeProvider;
    }

    @Override
    public VirtualFile @NotNull [] getRoots() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            VirtualFile[] virtualFileArray = cache.getOrComputeRoots(this.myRootType, flags, this::computeRootsUrls);
            if (virtualFileArray == null) {
                OrderRootsEnumeratorImpl.$$$reportNull$$$0(4);
            }
            return virtualFileArray;
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.computeRoots());
        if (virtualFileArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    @Override
    public String @NotNull [] getUrls() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            String[] stringArray = cache.getOrComputeUrls(this.myRootType, flags, this::computeRootsUrls);
            if (stringArray == null) {
                OrderRootsEnumeratorImpl.$$$reportNull$$$0(6);
            }
            return stringArray;
        }
        String[] stringArray = ArrayUtilRt.toStringArray(this.computeRootsUrls());
        if (stringArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    private void checkCanUseCache() {
        LOG.assertTrue(this.myRootTypeProvider == null, "Caching not supported for OrderRootsEnumerator with root type provider");
        LOG.assertTrue(this.myCustomRootProvider == null, "Caching not supported for OrderRootsEnumerator with 'usingCustomRootProvider' option");
        LOG.assertTrue(!this.myWithoutSelfModuleOutput, "Caching not supported for OrderRootsEnumerator with 'withoutSelfModuleOutput' option");
    }

    @NotNull
    private Collection<VirtualFile> computeRoots() {
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        this.myOrderEnumerator.forEach((orderEntry, customHandlers) -> {
            OrderRootType type2 = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.collectModuleRoots(type2, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), (Collection<? super VirtualFile>)result, true, !this.myOrderEnumerator.isProductionOnly(), (List<? extends OrderEnumerationHandler>)customHandlers);
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module = moduleOrderEntry.getModule();
                if (module != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module);
                    boolean productionOnTests = ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRoots(type2, rootModel, (Collection<? super VirtualFile>)result, !productionOnTests, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers);
                }
            } else {
                if (this.myCustomRootProvider != null) {
                    Collections.addAll(result, this.myCustomRootProvider.fun((OrderEntry)orderEntry));
                    return true;
                }
                if (OrderEnumeratorBase.addCustomRootsForLibrary(orderEntry, type2, result, customHandlers)) {
                    return true;
                }
                Collections.addAll(result, orderEntry.getFiles(type2));
            }
            return true;
        });
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<String> computeRootsUrls() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.myOrderEnumerator.forEach((orderEntry, customHandlers) -> {
            OrderRootType type2 = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                boolean includeTests = !this.myOrderEnumerator.isProductionOnly();
                this.collectModuleRootsUrls(type2, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), result, true, includeTests);
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module = moduleOrderEntry.getModule();
                if (module != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module);
                    boolean productionOnTests = ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRootsUrls(type2, rootModel, result, !productionOnTests, includeTests);
                }
            } else {
                if (OrderEnumeratorBase.addCustomRootUrlsForLibrary(orderEntry, type2, result, customHandlers)) {
                    return true;
                }
                Collections.addAll(result, orderEntry.getUrls(type2));
            }
            return true;
        });
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public PathsList getPathsList() {
        PathsList list = new PathsList();
        this.collectPaths(list);
        PathsList pathsList = list;
        if (pathsList == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(10);
        }
        return pathsList;
    }

    @Override
    public void collectPaths(@NotNull PathsList list) {
        if (list == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(11);
        }
        list.addVirtualFiles(this.getRoots());
    }

    @Override
    @NotNull
    public OrderRootsEnumerator usingCache() {
        this.myUsingCache = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(12);
        }
        return orderRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(13);
        }
        return orderRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator usingCustomRootProvider(@NotNull NotNullFunction<? super OrderEntry, VirtualFile[]> provider) {
        if (provider == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(14);
        }
        this.myCustomRootProvider = provider;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(15);
        }
        return orderRootsEnumeratorImpl;
    }

    private void collectModuleRoots(@NotNull OrderRootType type2, ModuleRootModel rootModel, @NotNull Collection<? super VirtualFile> result, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        CompilerModuleExtension extension;
        if (type2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(16);
        }
        if (result == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(17);
        }
        if (customHandlers == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(18);
        }
        if (type2.equals(OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result, rootModel.getSourceRoots(includeTests));
            } else {
                result.addAll(rootModel.getSourceRoots(JavaModuleSourceRootTypes.TESTS));
            }
        } else if (type2.equals(OrderRootType.CLASSES) && (extension = rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result, extension.getOutputRoots(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result, extension.getOutputRoots(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result, extension.getCompilerOutputPathForTests());
            }
        }
        OrderEnumeratorBase.addCustomRootsForModule(type2, rootModel, result, includeProduction, includeTests, customHandlers);
    }

    private void collectModuleRootsUrls(@NotNull OrderRootType type2, @NotNull ModuleRootModel rootModel, @NotNull Collection<? super String> result, boolean includeProduction, boolean includeTests) {
        if (type2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(19);
        }
        if (rootModel == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(20);
        }
        if (result == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(21);
        }
        if (type2.equals(OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result, rootModel.getSourceRootUrls(includeTests));
            } else {
                for (ContentEntry entry : rootModel.getContentEntries()) {
                    for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.TESTS)) {
                        result.add(folder.getUrl());
                    }
                }
            }
        } else if (type2.equals(OrderRootType.CLASSES)) {
            boolean hasTests = false;
            boolean hasProduction = false;
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    if (sourceFolder.isTestSource()) {
                        hasTests = true;
                        continue;
                    }
                    hasProduction = true;
                }
            }
            includeTests &= hasTests;
            includeProduction &= hasProduction;
            CompilerModuleExtension extension = rootModel.getModuleExtension(CompilerModuleExtension.class);
            if (extension != null) {
                if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                    if (includeTests && includeProduction) {
                        Collections.addAll(result, extension.getOutputRootUrls(false));
                    }
                } else if (includeProduction) {
                    Collections.addAll(result, extension.getOutputRootUrls(includeTests));
                } else if (includeTests) {
                    ContainerUtil.addIfNotNull(result, extension.getCompilerOutputUrlForTests());
                }
            }
        }
    }

    @NotNull
    private OrderRootType getRootType(@NotNull OrderEntry e) {
        if (e == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(22);
        }
        OrderRootType orderRootType = this.myRootType != null ? this.myRootType : this.myRootTypeProvider.fun(e);
        if (orderRootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(23);
        }
        return orderRootType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEnumerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootsUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSelfModuleOutput";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCustomRootProvider";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "usingCustomRootProvider";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleRoots";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleRootsUrls";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRootType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

