/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.Objects;
import sqldelight.com.intellij.injected.editor.VirtualFileWindow;
import sqldelight.com.intellij.model.ModelBranch;
import sqldelight.com.intellij.notebook.editor.BackedVirtualFile;
import sqldelight.com.intellij.openapi.application.ReadAction;
import sqldelight.com.intellij.openapi.fileTypes.FileTypeRegistry;
import sqldelight.com.intellij.openapi.roots.ContentIterator;
import sqldelight.com.intellij.openapi.roots.ContentIteratorEx;
import sqldelight.com.intellij.openapi.roots.FileIndex;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryIndex;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfo;
import sqldelight.com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileFilter;
import sqldelight.com.intellij.openapi.vfs.VirtualFileVisitor;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.jps.model.module.JpsModuleSourceRootType;

abstract class FileIndexBase
implements FileIndex {
    private final FileTypeRegistry myFileTypeRegistry;
    final DirectoryIndex myDirectoryIndex;

    FileIndexBase(@NotNull DirectoryIndex directoryIndex) {
        if (directoryIndex == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = FileTypeRegistry.getInstance();
    }

    protected abstract boolean isScopeDisposed();

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        return this.iterateContent(processor, null);
    }

    @Override
    public boolean iterateContentUnderDirectory(final @NotNull VirtualFile dir, @NotNull ContentIterator processor, final @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        final ContentIteratorEx processorEx = FileIndexBase.toContentIteratorEx(processor);
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                ContentIteratorEx.Status status;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryInfo info = ReadAction.compute(() -> FileIndexBase.this.getInfoForFileOrDirectory(file));
                if (file.isDirectory()) {
                    if (info.isExcluded(file)) {
                        if (!info.processContentBeneathExcluded(file, content -> FileIndexBase.this.iterateContentUnderDirectory((VirtualFile)content, processorEx, customFilter))) {
                            VirtualFileVisitor.Result result = 1.skipTo(dir);
                            if (result == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result;
                        }
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result;
                    }
                    if (info.isIgnored()) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return result;
                    }
                }
                boolean accepted = ReadAction.compute(() -> !FileIndexBase.this.isScopeDisposed() && FileIndexBase.this.isInContent(file, info)) != false && (customFilter == null || customFilter.accept(file));
                ContentIteratorEx.Status status2 = status = accepted ? processorEx.processFileEx(file) : ContentIteratorEx.Status.CONTINUE;
                if (status == ContentIteratorEx.Status.CONTINUE) {
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return result;
                }
                if (status == ContentIteratorEx.Status.SKIP_CHILDREN) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = 1.skipTo(dir);
                if (result == null) {
                    1.$$$reportNull$$$0(6);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return !Comparing.equal(result.skipToParent, dir);
    }

    @NotNull
    private static ContentIteratorEx toContentIteratorEx(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        if (processor instanceof ContentIteratorEx) {
            ContentIteratorEx contentIteratorEx = (ContentIteratorEx)processor;
            if (contentIteratorEx == null) {
                FileIndexBase.$$$reportNull$$$0(5);
            }
            return contentIteratorEx;
        }
        ContentIteratorEx contentIteratorEx = fileOrDir -> processor.processFile(fileOrDir) ? ContentIteratorEx.Status.CONTINUE : ContentIteratorEx.Status.STOP;
        if (contentIteratorEx == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return contentIteratorEx;
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        return this.iterateContentUnderDirectory(dir, processor, null);
    }

    boolean isTestSourcesRoot(@NotNull DirectoryInfo info) {
        JpsModuleSourceRootType<?> rootType;
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        return (rootType = this.myDirectoryIndex.getSourceRootType(info)) != null && rootType.isForTests();
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file) {
        ModelBranch branch;
        if (file == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        if ((branch = ModelBranch.getFileBranch(file = BackedVirtualFile.getOriginFileIfBacked(file))) != null) {
            file = Objects.requireNonNull(branch.findOriginalFile(file));
        }
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file);
        if (directoryInfo == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        return directoryInfo;
    }

    @Override
    public boolean isContentSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            FileIndexBase.$$$reportNull$$$0(12);
        }
        return !file.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file) && this.isInSourceContent(file);
    }

    protected boolean isInContent(@NotNull VirtualFile file, @NotNull DirectoryInfo info) {
        if (file == null) {
            FileIndexBase.$$$reportNull$$$0(13);
        }
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(14);
        }
        return ProjectFileIndexImpl.isFileInContent(file, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toContentIteratorEx";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFileOrDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toContentIteratorEx";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourcesRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFileOrDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isContentSourceFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

