/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.List;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfo;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.Processor;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

class DirectoryInfoImpl
extends DirectoryInfo {
    protected final VirtualFile myRoot;
    private final Module module;
    private final VirtualFile libraryClassRoot;
    private final VirtualFile contentRoot;
    private final VirtualFile sourceRoot;
    private final SourceFolder sourceRootFolder;
    private final boolean myInModuleSource;
    private final boolean myInLibrarySource;
    private final boolean myExcluded;
    private final String myUnloadedModuleName;
    final List<DirectoryInfoImpl> myContentInfosBeneath;

    DirectoryInfoImpl(@NotNull VirtualFile root, Module module, VirtualFile contentRoot, VirtualFile sourceRoot, @Nullable SourceFolder sourceRootFolder, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, @Nullable String unloadedModuleName) {
        if (root == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(0);
        }
        this.myContentInfosBeneath = new SmartList<DirectoryInfoImpl>();
        this.myRoot = root;
        this.module = module;
        this.libraryClassRoot = libraryClassRoot;
        this.contentRoot = contentRoot;
        this.sourceRoot = sourceRoot;
        this.sourceRootFolder = sourceRootFolder;
        this.myInModuleSource = inModuleSource;
        this.myInLibrarySource = inLibrarySource;
        this.myExcluded = isExcluded;
        this.myUnloadedModuleName = unloadedModuleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myRoot.equals(((DirectoryInfoImpl)o).myRoot);
    }

    public int hashCode() {
        return this.myRoot.hashCode();
    }

    public String toString() {
        return "DirectoryInfo{module=" + this.getModule() + ", isInModuleSource=" + this.myInModuleSource + ", rootType=" + (this.sourceRootFolder == null ? null : this.sourceRootFolder.getRootType()) + ", isExcludedFromModule=" + this.myExcluded + ", libraryClassRoot=" + this.getLibraryClassRoot() + ", contentRoot=" + this.getContentRoot() + ", sourceRoot=" + this.getSourceRoot() + "}";
    }

    @Override
    public boolean isInProject(@NotNull VirtualFile file) {
        if (file == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(1);
        }
        return !this.isExcluded(file);
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    @Nullable
    public VirtualFile getSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    @Nullable
    public SourceFolder getSourceRootFolder() {
        return this.sourceRootFolder;
    }

    @Override
    public VirtualFile getLibraryClassRoot() {
        return this.libraryClassRoot;
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        return this.contentRoot;
    }

    public boolean isInModuleSource() {
        return this.myInModuleSource;
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(2);
        }
        return this.myInLibrarySource;
    }

    public boolean isExcluded() {
        return this.myExcluded;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file) {
        if (file == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(3);
        }
        return this.myExcluded;
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file) {
        if (file == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(4);
        }
        return this.myInModuleSource;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public String getUnloadedModuleName() {
        return this.myUnloadedModuleName;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @Override
    public boolean processContentBeneathExcluded(@NotNull VirtualFile dir, @NotNull Processor<? super VirtualFile> processor) {
        if (dir == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(7);
        }
        return this.isExcluded(dir) && ContainerUtil.process(this.myContentInfosBeneath, child -> !VfsUtilCore.isAncestor(dir, child.myRoot, false) || processor.process(child.myRoot));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/DirectoryInfoImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/DirectoryInfoImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInModuleSource";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processContentBeneathExcluded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

