/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.fileTypes;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.fileTypes.LanguageFileType;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class CharsetUtil {
    private static final Map<String, Boolean> ourSupportsCharsetDetection = new ConcurrentHashMap<String, Boolean>();

    private static boolean overridesExtractCharsetFromContent(LanguageFileType fileType) {
        Class<?> ftClass = fileType.getClass();
        String methodName = "extractCharsetFromFileContent";
        Class<?> declaring1 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, String.class);
        Class<?> declaring2 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, CharSequence.class);
        return !LanguageFileType.class.equals(declaring1) || !LanguageFileType.class.equals(declaring2);
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile virtualFile, @Nullable FileType fileType, @NotNull CharSequence text) {
        if (text == null) {
            CharsetUtil.$$$reportNull$$$0(0);
        }
        if (fileType instanceof LanguageFileType && ourSupportsCharsetDetection.computeIfAbsent(fileType.getName(), __ -> CharsetUtil.overridesExtractCharsetFromContent((LanguageFileType)fileType)).booleanValue()) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile, text);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "sqldelight/com/intellij/openapi/fileTypes/CharsetUtil", "extractCharsetFromFileContent"));
    }
}

