/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.editor.colors;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sqldelight.com.intellij.openapi.components.ServiceManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.editor.markup.TextAttributes;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.util.JDOMExternalizerUtil;
import sqldelight.com.intellij.openapi.util.NullableLazyValue;
import sqldelight.com.intellij.openapi.util.VolatileNullableLazyValue;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.containers.JBIterable;
import sqldelight.gnu.trove.THashSet;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    public static final TextAttributesKey[] EMPTY_ARRAY = new TextAttributesKey[0];
    private static final Logger LOG = Logger.getInstance(TextAttributesKey.class);
    private static final String TEMP_PREFIX = "TEMP::";
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = new ConcurrentHashMap<String, TextAttributesKey>();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        @Override
        @Nullable
        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    private final String myExternalName;
    private final TextAttributes myDefaultAttributes;
    private final TextAttributesKey myFallbackAttributeKey;
    private static final ThreadLocal<Set<String>> CALLED_RECURSIVELY = ThreadLocal.withInitial(() -> new THashSet());
    @Deprecated
    static final TextAttributesKey DUMMY_DEPRECATED_ATTRIBUTES = TextAttributesKey.createTextAttributesKey("__deprecated__");

    private TextAttributesKey(@NotNull String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        JBIterable<TextAttributesKey> it;
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(0);
        }
        this.myExternalName = externalName;
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = fallbackAttributeKey;
        if (fallbackAttributeKey != null && this.equals((it = JBIterable.generate(this.myFallbackAttributeKey, o -> o == this ? null : o.myFallbackAttributeKey)).find(o -> this.equals(o)))) {
            throw new IllegalArgumentException("Can't use this fallback key: " + fallbackAttributeKey + ": Cycle detected: " + StringUtil.join(it, "->"));
        }
    }

    public TextAttributesKey(@NotNull Element element) {
        if (element == null) {
            TextAttributesKey.$$$reportNull$$$0(1);
        }
        String name = JDOMExternalizerUtil.readField(element, "myExternalName");
        Element myDefaultAttributesElement = JDOMExternalizerUtil.readOption(element, "myDefaultAttributes");
        TextAttributes defaultAttributes = myDefaultAttributesElement == null ? null : new TextAttributes(myDefaultAttributesElement);
        this.myExternalName = name;
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = null;
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(2);
        }
        TextAttributesKey textAttributesKey = ourRegistry.computeIfAbsent(externalName, name -> new TextAttributesKey((String)name, null, null));
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(3);
        }
        return textAttributesKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @NotNull
    public String getExternalName() {
        String string = this.myExternalName;
        if (string == null) {
            TextAttributesKey.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        if (key == null) {
            TextAttributesKey.$$$reportNull$$$0(5);
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(6);
        }
        return TextAttributesKey.find(externalName);
    }

    public void writeExternal(Element element) {
        JDOMExternalizerUtil.writeField(element, "myExternalName", this.myExternalName);
        if (this.myDefaultAttributes != null) {
            Element option = JDOMExternalizerUtil.writeOption(element, "myDefaultAttributes");
            this.myDefaultAttributes.writeExternal(option);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextAttributes getDefaultAttributes() {
        TextAttributeKeyDefaultsProvider provider;
        TextAttributes defaultAttributes = this.myDefaultAttributes;
        if (defaultAttributes == null && (provider = ourDefaultsProvider.getValue()) != null) {
            Set<String> called = CALLED_RECURSIVELY.get();
            if (!called.add(this.myExternalName)) {
                return null;
            }
            try {
                TextAttributes textAttributes = ObjectUtils.notNull(provider.getDefaultAttributes(this), NULL_ATTRIBUTES);
                return textAttributes;
            }
            finally {
                called.remove(this.myExternalName);
            }
        }
        return defaultAttributes;
    }

    @Deprecated
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(7);
        }
        return TextAttributesKey.getOrCreate(externalName, defaultAttributes, null);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributesKey fallbackAttributeKey) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(8);
        }
        return TextAttributesKey.getOrCreate(externalName, null, fallbackAttributeKey);
    }

    @NotNull
    private static TextAttributesKey getOrCreate(@NotNull @NonNls String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        TextAttributesKey existing;
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(9);
        }
        if ((existing = (TextAttributesKey)ourRegistry.get(externalName)) != null && (defaultAttributes == null || Comparing.equal(existing.myDefaultAttributes, defaultAttributes)) && (fallbackAttributeKey == null || Comparing.equal(existing.myFallbackAttributeKey, fallbackAttributeKey))) {
            TextAttributesKey textAttributesKey = existing;
            if (textAttributesKey == null) {
                TextAttributesKey.$$$reportNull$$$0(10);
            }
            return textAttributesKey;
        }
        TextAttributesKey textAttributesKey = ourRegistry.compute(externalName, (oldName, oldKey) -> TextAttributesKey.mergeKeys(oldName, oldKey, defaultAttributes, fallbackAttributeKey));
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(11);
        }
        return textAttributesKey;
    }

    @NotNull
    private static TextAttributesKey mergeKeys(@NonNls @NotNull String externalName, @Nullable TextAttributesKey oldKey, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(12);
        }
        if (oldKey == null) {
            return new TextAttributesKey(externalName, defaultAttributes, fallbackAttributeKey);
        }
        if (oldKey.myFallbackAttributeKey != null && !oldKey.myFallbackAttributeKey.equals(fallbackAttributeKey)) {
            LOG.error(new IllegalStateException("TextAttributeKey(name:'" + externalName + "', fallbackAttributeKey:'" + fallbackAttributeKey + "')  was already registered with the other fallback attribute key: " + oldKey.myFallbackAttributeKey));
        }
        if (oldKey.myDefaultAttributes != null && !oldKey.myDefaultAttributes.equals(defaultAttributes)) {
            LOG.error(new IllegalStateException("TextAttributeKey(name:'" + externalName + "', defaultAttributes:'" + defaultAttributes + "')  was already registered with the other defaultAttributes: " + oldKey.myDefaultAttributes));
        }
        TextAttributes newDefaults = ObjectUtils.chooseNotNull(defaultAttributes, oldKey.myDefaultAttributes);
        TextAttributesKey newFallback = ObjectUtils.chooseNotNull(fallbackAttributeKey, oldKey.myFallbackAttributeKey);
        return new TextAttributesKey(externalName, newDefaults, newFallback);
    }

    @NotNull
    public static TextAttributesKey createTempTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(13);
        }
        return TextAttributesKey.createTextAttributesKey(TEMP_PREFIX + externalName, defaultAttributes);
    }

    @Nullable
    public TextAttributesKey getFallbackAttributeKey() {
        return this.myFallbackAttributeKey;
    }

    @Deprecated
    public void setFallbackAttributeKey(@Nullable TextAttributesKey fallbackAttributeKey) {
    }

    static void removeTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(14);
        }
        ourRegistry.remove(externalName);
    }

    public static boolean isTemp(@NotNull TextAttributesKey key) {
        if (key == null) {
            TextAttributesKey.$$$reportNull$$$0(15);
        }
        return key.getExternalName().startsWith(TEMP_PREFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTextAttributesKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergeKeys";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTempTextAttributesKey";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeTextAttributesKey";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTemp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface TextAttributeKeyDefaultsProvider {
        public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey var1);
    }
}

