/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.lang;

import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.lang.LanguageExtension;
import sqldelight.com.intellij.lang.LanguageParserDefinitions;
import sqldelight.com.intellij.lang.ParserDefinition;
import sqldelight.com.intellij.lang.TokenSeparatorGenerator;
import sqldelight.com.intellij.psi.PsiManager;
import sqldelight.com.intellij.psi.TokenType;
import sqldelight.com.intellij.psi.impl.source.tree.Factory;
import sqldelight.com.intellij.psi.impl.source.tree.LeafElement;
import sqldelight.com.intellij.psi.util.PsiUtilCore;

public class LanguageTokenSeparatorGenerators
extends LanguageExtension<TokenSeparatorGenerator> {
    public static final LanguageTokenSeparatorGenerators INSTANCE = new LanguageTokenSeparatorGenerators();

    private LanguageTokenSeparatorGenerators() {
        super("sqldelight.com.intellij.lang.tokenSeparatorGenerator", new TokenSeparatorGenerator(){

            @Override
            public ASTNode generateWhitespaceBetweenTokens(ASTNode left, ASTNode right) {
                ParserDefinition parserDefinition;
                Language l = PsiUtilCore.getNotAnyLanguage(left);
                Language rightLang = PsiUtilCore.getNotAnyLanguage(right);
                if (rightLang.isKindOf(l)) {
                    l = rightLang;
                }
                if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)) != null) {
                    LeafElement generatedWhitespace;
                    PsiManager manager = right.getTreeParent().getPsi().getManager();
                    switch (parserDefinition.spaceExistenceTypeBetweenTokens(left, right)) {
                        case MUST: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, null, manager);
                            break;
                        }
                        case MUST_LINE_BREAK: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager);
                            break;
                        }
                        default: {
                            generatedWhitespace = null;
                        }
                    }
                    return generatedWhitespace;
                }
                return null;
            }
        });
    }
}

