/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import sqldelight.com.intellij.diagnostic.PluginException;
import sqldelight.com.intellij.ide.plugins.ClassPathXmlPathResolver;
import sqldelight.com.intellij.ide.plugins.ContainerDescriptor;
import sqldelight.com.intellij.ide.plugins.DescriptorListLoadingContext;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.PathBasedJdomXIncluder;
import sqldelight.com.intellij.ide.plugins.PluginDependency;
import sqldelight.com.intellij.openapi.components.ServiceDescriptor;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import sqldelight.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import sqldelight.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import sqldelight.com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import sqldelight.com.intellij.openapi.util.JDOMUtil;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.messages.ListenerDescriptor;
import sqldelight.org.jdom.Attribute;
import sqldelight.org.jdom.Content;
import sqldelight.org.jdom.Element;
import sqldelight.org.jdom.JDOMException;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

final class XmlReader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
    static final String APPLICATION_SERVICE = "sqldelight.com.intellij.applicationService";
    static final String PROJECT_SERVICE = "sqldelight.com.intellij.projectService";
    static final String MODULE_SERVICE = "sqldelight.com.intellij.moduleService";
    private static final String ATTRIBUTE_AREA = "area";

    XmlReader() {
    }

    static boolean isSuitableForOs(@NotNull String os) {
        if (os == null) {
            XmlReader.$$$reportNull$$$0(0);
        }
        if (os.isEmpty()) {
            return true;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.mac.name())) {
            return SystemInfoRt.isMac;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.linux.name())) {
            return SystemInfoRt.isLinux;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.windows.name())) {
            return SystemInfoRt.isWindows;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.unix.name())) {
            return SystemInfoRt.isUnix;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.freebsd.name())) {
            return SystemInfoRt.isFreeBSD;
        }
        throw new IllegalArgumentException("Unknown OS '" + os + "'");
    }

    @NotNull
    private static ServiceDescriptor readServiceDescriptor(@NotNull Element element) {
        if (element == null) {
            XmlReader.$$$reportNull$$$0(1);
        }
        ServiceDescriptor descriptor = new ServiceDescriptor();
        descriptor.serviceInterface = element.getAttributeValue("serviceInterface");
        descriptor.serviceImplementation = StringUtil.nullize(element.getAttributeValue("serviceImplementation"));
        descriptor.testServiceImplementation = StringUtil.nullize(element.getAttributeValue("testServiceImplementation"));
        descriptor.headlessImplementation = StringUtil.nullize(element.getAttributeValue("headlessImplementation"));
        descriptor.configurationSchemaKey = element.getAttributeValue("configurationSchemaKey");
        String preload = element.getAttributeValue("preload");
        if (preload != null) {
            switch (preload) {
                case "true": {
                    descriptor.preload = ServiceDescriptor.PreloadMode.TRUE;
                    break;
                }
                case "await": {
                    descriptor.preload = ServiceDescriptor.PreloadMode.AWAIT;
                    break;
                }
                case "notHeadless": {
                    descriptor.preload = ServiceDescriptor.PreloadMode.NOT_HEADLESS;
                    break;
                }
                case "notLightEdit": {
                    descriptor.preload = ServiceDescriptor.PreloadMode.NOT_LIGHT_EDIT;
                    break;
                }
                default: {
                    LOG.error("Unknown preload mode value: " + JDOMUtil.writeElement(element));
                }
            }
        }
        descriptor.overrides = Boolean.parseBoolean(element.getAttributeValue("overrides"));
        ServiceDescriptor serviceDescriptor = descriptor;
        if (serviceDescriptor == null) {
            XmlReader.$$$reportNull$$$0(2);
        }
        return serviceDescriptor;
    }

    static void readListeners(@NotNull Element list, @NotNull ContainerDescriptor containerDescriptor, @NotNull IdeaPluginDescriptorImpl mainDescriptor) {
        if (list == null) {
            XmlReader.$$$reportNull$$$0(3);
        }
        if (containerDescriptor == null) {
            XmlReader.$$$reportNull$$$0(4);
        }
        if (mainDescriptor == null) {
            XmlReader.$$$reportNull$$$0(5);
        }
        List<Content> content = list.getContent();
        List<ListenerDescriptor> result = containerDescriptor.listeners;
        if (result == null) {
            containerDescriptor.listeners = result = new ArrayList<ListenerDescriptor>(content.size());
        } else {
            ((ArrayList)result).ensureCapacity(result.size() + content.size());
        }
        for (Content item : content) {
            Element child;
            String os;
            if (!(item instanceof Element) || (os = (child = (Element)item).getAttributeValue("os")) != null && !XmlReader.isSuitableForOs(os)) continue;
            String listenerClassName = child.getAttributeValue("class");
            String topicClassName = child.getAttributeValue("topic");
            if (listenerClassName == null || topicClassName == null) {
                LOG.error("Listener descriptor is not correct: " + JDOMUtil.writeElement(child));
                continue;
            }
            result.add(new ListenerDescriptor(listenerClassName, topicClassName, XmlReader.getBoolean("activeInTestMode", child), XmlReader.getBoolean("activeInHeadlessMode", child), mainDescriptor));
        }
    }

    static void readIdAndName(@NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Element element) {
        if (descriptor == null) {
            XmlReader.$$$reportNull$$$0(6);
        }
        if (element == null) {
            XmlReader.$$$reportNull$$$0(7);
        }
        String idString = descriptor.myId == null ? element.getChildTextTrim("id") : descriptor.myId.getIdString();
        String name = element.getChildTextTrim("name");
        if (idString == null) {
            idString = name;
        } else if (name == null) {
            name = idString;
        }
        descriptor.myName = name;
        if (descriptor.myId == null) {
            descriptor.myId = idString == null || idString.isEmpty() ? null : PluginId.getId(idString);
        }
    }

    static void readMetaInfo(@NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Element element) {
        if (descriptor == null) {
            XmlReader.$$$reportNull$$$0(8);
        }
        if (element == null) {
            XmlReader.$$$reportNull$$$0(9);
        }
        if (!element.hasAttributes()) {
            return;
        }
        List<Attribute> attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            switch (attribute.getName()) {
                case "url": {
                    descriptor.myUrl = StringUtil.nullize(attribute.getValue());
                    break;
                }
                case "use-idea-classloader": {
                    descriptor.myUseIdeaClassLoader = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "allow-bundled-update": {
                    descriptor.myAllowBundledUpdate = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "implementation-detail": {
                    descriptor.myImplementationDetail = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "require-restart": {
                    descriptor.myRequireRestart = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "version": {
                    String internalVersionString = StringUtil.nullize(attribute.getValue());
                    if (internalVersionString == null) break;
                    try {
                        Integer.parseInt(internalVersionString);
                        break;
                    }
                    catch (NumberFormatException e) {
                        LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, descriptor.myId));
                    }
                }
            }
        }
    }

    static <T> void readDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull IdeaPluginDescriptorImpl descriptor, @NotNull DescriptorListLoadingContext context, @NotNull PathBasedJdomXIncluder.PathResolver<T> pathResolver, @NotNull List<PluginDependency> dependencies) {
        if (rootDescriptor == null) {
            XmlReader.$$$reportNull$$$0(10);
        }
        if (descriptor == null) {
            XmlReader.$$$reportNull$$$0(11);
        }
        if (context == null) {
            XmlReader.$$$reportNull$$$0(12);
        }
        if (pathResolver == null) {
            XmlReader.$$$reportNull$$$0(13);
        }
        if (dependencies == null) {
            XmlReader.$$$reportNull$$$0(14);
        }
        List<String> visitedFiles = null;
        for (PluginDependency dependency : dependencies) {
            Element element;
            String configFile;
            if (dependency.isDisabledOrBroken || (configFile = dependency.configFile) == null || pathResolver instanceof ClassPathXmlPathResolver && context.checkOptionalConfigShortName(configFile, descriptor, rootDescriptor)) continue;
            try {
                element = pathResolver.resolvePath(descriptor.basePath, configFile, context.getXmlFactory());
            }
            catch (IOException | JDOMException e) {
                String message = "Plugin " + rootDescriptor + " misses optional descriptor " + configFile;
                if (context.ignoreMissingSubDescriptor) {
                    LOG.info(message, e);
                    continue;
                }
                throw new RuntimeException(message, e);
            }
            if (visitedFiles == null) {
                visitedFiles = context.getVisitedFiles();
            }
            XmlReader.checkCycle(rootDescriptor, configFile, visitedFiles);
            IdeaPluginDescriptorImpl subDescriptor = new IdeaPluginDescriptorImpl(descriptor.path, descriptor.basePath, false);
            visitedFiles.add(configFile);
            if (!subDescriptor.readExternal(element, pathResolver, context, rootDescriptor)) {
                subDescriptor = null;
            }
            visitedFiles.clear();
            if (subDescriptor == null) continue;
            dependency.subDescriptor = subDescriptor;
        }
    }

    private static void checkCycle(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull String configFile, @NotNull List<String> visitedFiles) {
        if (rootDescriptor == null) {
            XmlReader.$$$reportNull$$$0(15);
        }
        if (configFile == null) {
            XmlReader.$$$reportNull$$$0(16);
        }
        if (visitedFiles == null) {
            XmlReader.$$$reportNull$$$0(17);
        }
        int n = visitedFiles.size();
        for (int i = 0; i < n; ++i) {
            if (!configFile.equals(visitedFiles.get(i))) continue;
            List<String> cycle = visitedFiles.subList(i, visitedFiles.size());
            throw new RuntimeException("Plugin " + rootDescriptor + " optional descriptors form a cycle: " + String.join((CharSequence)", ", cycle));
        }
    }

    private static boolean getBoolean(@NotNull String name, @NotNull Element child) {
        String value;
        if (name == null) {
            XmlReader.$$$reportNull$$$0(18);
        }
        if (child == null) {
            XmlReader.$$$reportNull$$$0(19);
        }
        return (value = child.getAttributeValue(name)) == null || Boolean.parseBoolean(value);
    }

    @Nullable
    static LinkedHashMap<String, List<Element>> readExtensions(@NotNull IdeaPluginDescriptorImpl descriptor, @Nullable LinkedHashMap<String, List<Element>> epNameToExtensions, @NotNull DescriptorListLoadingContext loadingContext, @NotNull Element child) {
        if (descriptor == null) {
            XmlReader.$$$reportNull$$$0(20);
        }
        if (loadingContext == null) {
            XmlReader.$$$reportNull$$$0(21);
        }
        if (child == null) {
            XmlReader.$$$reportNull$$$0(22);
        }
        String ns = child.getAttributeValue("defaultExtensionNs");
        block10: for (Element extensionElement : child.getChildren()) {
            ContainerDescriptor containerDescriptor;
            String qualifiedExtensionPointName;
            String os = extensionElement.getAttributeValue("os");
            if (os != null) {
                extensionElement.removeAttribute("os");
                if (!XmlReader.isSuitableForOs(os)) continue;
            }
            switch (qualifiedExtensionPointName = loadingContext.internString(ExtensionsAreaImpl.extractPointName(extensionElement, ns))) {
                case "sqldelight.com.intellij.applicationService": {
                    containerDescriptor = descriptor.appContainerDescriptor;
                    break;
                }
                case "sqldelight.com.intellij.projectService": {
                    containerDescriptor = descriptor.projectContainerDescriptor;
                    break;
                }
                case "sqldelight.com.intellij.moduleService": {
                    containerDescriptor = descriptor.moduleContainerDescriptor;
                    break;
                }
                default: {
                    if (epNameToExtensions == null) {
                        epNameToExtensions = new LinkedHashMap();
                    }
                    epNameToExtensions.computeIfAbsent(qualifiedExtensionPointName, __ -> new SmartList()).add(extensionElement);
                    continue block10;
                }
            }
            containerDescriptor.addService(XmlReader.readServiceDescriptor(extensionElement));
        }
        return epNameToExtensions;
    }

    static void readExtensionPoints(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Element parentElement) {
        if (rootDescriptor == null) {
            XmlReader.$$$reportNull$$$0(23);
        }
        if (descriptor == null) {
            XmlReader.$$$reportNull$$$0(24);
        }
        if (parentElement == null) {
            XmlReader.$$$reportNull$$$0(25);
        }
        for (Content child : parentElement.getContent()) {
            ContainerDescriptor containerDescriptor;
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String area = element.getAttributeValue(ATTRIBUTE_AREA);
            if (area == null) {
                containerDescriptor = descriptor.appContainerDescriptor;
            } else if ("IDEA_PROJECT".equals(area)) {
                containerDescriptor = descriptor.projectContainerDescriptor;
            } else if ("IDEA_MODULE".equals(area)) {
                containerDescriptor = descriptor.moduleContainerDescriptor;
            } else {
                LOG.error("Unknown area: " + area);
                continue;
            }
            String pointName = XmlReader.getExtensionPointName(element, rootDescriptor.getPluginId());
            String beanClassName = element.getAttributeValue("beanClass");
            String interfaceClassName = element.getAttributeValue("interface");
            if (beanClassName == null && interfaceClassName == null) {
                throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + rootDescriptor.getPluginId() + "' plugin");
            }
            if (beanClassName != null && interfaceClassName != null) {
                throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + rootDescriptor.getPluginId() + "' plugin");
            }
            boolean dynamic = Boolean.parseBoolean(element.getAttributeValue("dynamic"));
            ExtensionPointImpl point = interfaceClassName == null ? new BeanExtensionPoint(pointName, beanClassName, rootDescriptor, dynamic) : new InterfaceExtensionPoint(pointName, interfaceClassName, rootDescriptor, dynamic);
            List<ExtensionPointImpl<?>> result = containerDescriptor.extensionPoints;
            if (result == null) {
                result = new ArrayList();
                containerDescriptor.extensionPoints = result;
            }
            result.add(point);
        }
    }

    @NotNull
    private static String getExtensionPointName(@NotNull Element extensionPointElement, @NotNull PluginId effectivePluginId) {
        String pointName;
        if (extensionPointElement == null) {
            XmlReader.$$$reportNull$$$0(26);
        }
        if (effectivePluginId == null) {
            XmlReader.$$$reportNull$$$0(27);
        }
        if ((pointName = extensionPointElement.getAttributeValue("qualifiedName")) == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + effectivePluginId + "' plugin");
            }
            pointName = effectivePluginId.getIdString() + '.' + name;
        }
        String string = pointName;
        if (string == null) {
            XmlReader.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ide/plugins/XmlReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDescriptor";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedFiles";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectivePluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ide/plugins/XmlReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readServiceDescriptor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForOs";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readServiceDescriptor";
                break;
            }
            case 2: 
            case 28: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readListeners";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readIdAndName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readMetaInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readDependencies";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkCycle";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readExtensions";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readExtensionPoints";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

