/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import sqldelight.com.intellij.ide.plugins.ClassPathXmlPathResolver;
import sqldelight.com.intellij.ide.plugins.DescriptorListLoadingContext;
import sqldelight.com.intellij.ide.plugins.DescriptorLoadingContext;
import sqldelight.com.intellij.ide.plugins.DisabledPluginsState;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.PathBasedJdomXIncluder;
import sqldelight.com.intellij.ide.plugins.PluginLoadingResult;
import sqldelight.com.intellij.ide.plugins.PluginManager;
import sqldelight.com.intellij.ide.plugins.PluginManagerCore;
import sqldelight.com.intellij.ide.plugins.PluginXmlPathResolver;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.util.BuildNumber;
import sqldelight.com.intellij.openapi.util.InvalidDataException;
import sqldelight.com.intellij.openapi.util.JDOMUtil;
import sqldelight.com.intellij.openapi.util.SafeJdomFactory;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.util.text.StringUtilRt;
import sqldelight.com.intellij.serialization.SerializationException;
import sqldelight.com.intellij.util.ExceptionUtil;
import sqldelight.com.intellij.util.io.Decompressor;
import sqldelight.org.jdom.Element;
import sqldelight.org.jdom.JDOMException;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginDescriptorLoader {
    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file, boolean isBundled, @NotNull DescriptorListLoadingContext parentContext) {
        if (file == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(0);
        }
        if (parentContext == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(1);
        }
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, isBundled, false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file, "plugin.xml", context, Files.isDirectory(file, new LinkOption[0]));
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull Path file, @NotNull String descriptorRelativePath, @Nullable Path pluginPath, @NotNull DescriptorLoadingContext context) {
        if (file == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(2);
        }
        if (descriptorRelativePath == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(4);
        }
        Path descriptorFile = file.resolve(descriptorRelativePath);
        try {
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(pluginPath == null ? file : pluginPath, descriptorFile.getParent(), context.isBundled);
            Element element = JDOMUtil.load(descriptorFile, context.parentContext.getXmlFactory());
            descriptor.readExternal(element, context.pathResolver, context.parentContext, descriptor);
            return descriptor;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException | SerializationException | JDOMException e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context.parentContext.result.reportCannotLoad(file, e);
        }
        catch (Throwable e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            DescriptorListLoadingContext.LOG.warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull Path file, @NotNull String fileName, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorLoadingContext context, @Nullable Path pluginPath) {
        if (file == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(6);
        }
        if (pathResolver == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(8);
        }
        SafeJdomFactory factory = context.parentContext.getXmlFactory();
        try {
            Element element;
            Path metaInf = context.open(file).getPath("/META-INF", new String[0]);
            try {
                element = JDOMUtil.load(metaInf.resolve(fileName), factory);
            }
            catch (NoSuchFileException ignore) {
                return null;
            }
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(pluginPath == null ? file : pluginPath, metaInf, context.isBundled);
            if (descriptor.readExternal(element, pathResolver, context.parentContext, descriptor)) {
                descriptor.jarFiles = Collections.singletonList(descriptor.getPluginPath());
            }
            return descriptor;
        }
        catch (InvalidDataException | SerializationException e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context.parentContext.result.reportCannotLoad(file, e);
        }
        catch (Throwable e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            DescriptorListLoadingContext.LOG.info("Cannot load " + file + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromFileOrDir(@NotNull Path file, @NotNull String pathName, @NotNull DescriptorLoadingContext context, boolean isDirectory) {
        if (file == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(9);
        }
        if (pathName == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(11);
        }
        if (isDirectory) {
            return PluginDescriptorLoader.loadDescriptorFromDirAndNormalize(file, pathName, context);
        }
        if (StringUtilRt.endsWithIgnoreCase(file.getFileName().toString(), ".jar")) {
            return PluginDescriptorLoader.loadDescriptorFromJar(file, pathName, context.pathResolver, context, null);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDirAndNormalize(@NotNull Path file, @NotNull String pathName, @NotNull DescriptorLoadingContext context) {
        String descriptorRelativePath;
        IdeaPluginDescriptorImpl descriptor;
        if (file == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(12);
        }
        if (pathName == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(14);
        }
        if ((descriptor = PluginDescriptorLoader.loadDescriptorFromDir(file, descriptorRelativePath = "META-INF/" + pathName, null, context)) != null) {
            return descriptor;
        }
        ArrayList<Path> pluginJarFiles = new ArrayList<Path>();
        ArrayList<Path> dirs = new ArrayList<Path>();
        if (!PluginDescriptorLoader.collectPluginDirectoryContents(file, pluginJarFiles, dirs)) {
            return null;
        }
        if (!pluginJarFiles.isEmpty()) {
            PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(pluginJarFiles, context);
            for (Path jarFile : pluginJarFiles) {
                descriptor = PluginDescriptorLoader.loadDescriptorFromJar(jarFile, pathName, pathResolver, context, file);
                if (descriptor == null) continue;
                descriptor.jarFiles = pluginJarFiles;
                return descriptor;
            }
        }
        for (Path dir : dirs) {
            IdeaPluginDescriptorImpl otherDescriptor = PluginDescriptorLoader.loadDescriptorFromDir(dir, descriptorRelativePath, file, context);
            if (otherDescriptor == null) continue;
            if (descriptor != null) {
                DescriptorListLoadingContext.LOG.info("Cannot load " + file + " because two or more plugin.xml's detected");
                return null;
            }
            descriptor = otherDescriptor;
        }
        return descriptor;
    }

    static boolean collectPluginDirectoryContents(@NotNull Path file, @NotNull List<Path> pluginJarFiles, @NotNull List<Path> dirs) {
        if (file == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(15);
        }
        if (pluginJarFiles == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(16);
        }
        if (dirs == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(17);
        }
        try (DirectoryStream<Path> s = Files.newDirectoryStream(file.resolve("lib"));){
            for (Path childFile : s) {
                if (Files.isDirectory(childFile, new LinkOption[0])) {
                    dirs.add(childFile);
                    continue;
                }
                String path = childFile.toString();
                if (!StringUtilRt.endsWithIgnoreCase(path, ".jar") && !StringUtilRt.endsWithIgnoreCase(path, ".zip")) continue;
                pluginJarFiles.add(childFile);
            }
        }
        catch (IOException e) {
            return false;
        }
        if (!pluginJarFiles.isEmpty()) {
            PluginDescriptorLoader.putMoreLikelyPluginJarsFirst(file, pluginJarFiles);
        }
        return true;
    }

    private static void putMoreLikelyPluginJarsFirst(@NotNull Path pluginDir, @NotNull List<Path> filesInLibUnderPluginDir) {
        if (pluginDir == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(18);
        }
        if (filesInLibUnderPluginDir == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(19);
        }
        String pluginDirName = pluginDir.getFileName().toString();
        filesInLibUnderPluginDir.sort((o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getFileName().toString();
            String o1Name = o1.getFileName().toString();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginDescriptorLoader.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginDescriptorLoader.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase(o2Name, pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase(o1Name, pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(@NotNull String name) {
        int i;
        if (name == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(20);
        }
        if ((i = name.lastIndexOf(45)) == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            return (c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2));
        }
        return false;
    }

    private static void loadDescriptorsFromDir(@NotNull Path dir, boolean isBundled, @NotNull DescriptorListLoadingContext context) throws ExecutionException, InterruptedException {
        if (dir == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(22);
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>();
        ExecutorService executorService = context.getExecutorService();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);){
            for (Path file : dirStream) {
                tasks.add(executorService.submit(() -> PluginDescriptorLoader.loadDescriptor(file, isBundled, context)));
            }
        }
        catch (IOException ignore) {
            return;
        }
        for (Future future : tasks) {
            IdeaPluginDescriptorImpl descriptor = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor == null) continue;
            context.result.add(descriptor, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName, @NotNull DescriptorLoadingContext loadingContext) {
        if (resource == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(23);
        }
        if (pathName == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(24);
        }
        if (loadingContext == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(25);
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                Path file = Paths.get(StringUtil.trimEnd(FileUtilRt.toSystemIndependentName(PluginDescriptorLoader.urlToFile(resource).toString()), pathName), new String[0]).getParent();
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file, pathName, loadingContext, Files.isDirectory(file, new LinkOption[0]));
                return ideaPluginDescriptorImpl;
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getFile();
                Path file = PluginDescriptorLoader.urlToFile(path.substring(0, path.indexOf("!/")));
                Path pluginPath = null;
                if (file.getParent() != null && file.getParent().endsWith("lib")) {
                    pluginPath = file.getParent().getParent();
                }
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromJar(file, pathName, loadingContext.pathResolver, loadingContext, pluginPath);
                return ideaPluginDescriptorImpl;
            }
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            DescriptorListLoadingContext.LOG.info("Cannot load " + resource, e);
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        finally {
            loadingContext.close();
        }
    }

    @NotNull
    private static Path urlToFile(@NotNull String url) throws URISyntaxException {
        Path path;
        if (url == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(26);
        }
        try {
            path = Paths.get(new URI(url));
        }
        catch (URISyntaxException e) {
            if (url.indexOf(32) > 0) {
                Path path2 = Paths.get(new URI(StringUtil.replace(url, " ", "%20")));
                if (path2 == null) {
                    PluginDescriptorLoader.$$$reportNull$$$0(28);
                }
                return path2;
            }
            throw e;
        }
        if (path == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(27);
        }
        return path;
    }

    @NotNull
    private static Path urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        Path path;
        try {
            path = Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                Path path2 = Paths.get(new URL(StringUtil.replace(str, " ", "%20")).toURI());
                if (path2 == null) {
                    PluginDescriptorLoader.$$$reportNull$$$0(30);
                }
                return path2;
            }
            throw e;
        }
        if (path == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(29);
        }
        return path;
    }

    private static void loadDescriptorsFromProperty(@NotNull PluginLoadingResult result, @NotNull DescriptorListLoadingContext context) {
        String pathProperty;
        if (result == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(32);
        }
        if ((pathProperty = System.getProperty("plugin.path")) == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl descriptor = PluginDescriptorLoader.loadDescriptor(Paths.get(s, new String[0]), false, context);
            if (descriptor == null) continue;
            result.add(descriptor, true);
        }
    }

    @NotNull
    static DescriptorListLoadingContext loadDescriptors() {
        int flags = 5;
        boolean isUnitTestMode = PluginManagerCore.isUnitTestMode;
        if (isUnitTestMode) {
            flags |= 2;
        }
        if (isUnitTestMode || PluginManagerCore.isRunningFromSources()) {
            flags |= 8;
        }
        PluginLoadingResult result = PluginManagerCore.createLoadingResult(null);
        try (DescriptorListLoadingContext context = new DescriptorListLoadingContext(flags, DisabledPluginsState.disabledPlugins(), result);){
            PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context, Paths.get(PathManager.getPluginsPath(), new String[0]));
            PluginDescriptorLoader.loadDescriptorsFromProperty(result, context);
            if (isUnitTestMode && result.enabledPluginCount() <= 1) {
                context.usePluginClassLoader = true;
                PluginDescriptorLoader.loadDescriptorsFromDir(context.getBundledPluginsPath(), true, context);
            }
        }
        context.result.finishLoading();
        DescriptorListLoadingContext descriptorListLoadingContext = context;
        if (descriptorListLoadingContext == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(33);
        }
        return descriptorListLoadingContext;
    }

    static void loadBundledDescriptorsAndDescriptorsFromDir(DescriptorListLoadingContext context, Path dir) throws ExecutionException, InterruptedException {
        ClassLoader classLoader = PluginManagerCore.class.getClassLoader();
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        URL platformPluginURL = PluginDescriptorLoader.computePlatformPluginUrlAndCollectPluginUrls(classLoader, urlsFromClassPath);
        try (DescriptorLoadingContext loadingContext = new DescriptorLoadingContext(context, true, true, new ClassPathXmlPathResolver(classLoader));){
            PluginDescriptorLoader.loadDescriptorsFromClassPath(urlsFromClassPath, loadingContext, platformPluginURL);
        }
        PluginDescriptorLoader.loadDescriptorsFromDir(dir, false, context);
        if (context.loadBundledPlugins) {
            PluginDescriptorLoader.loadDescriptorsFromDir(context.getBundledPluginsPath(), true, context);
        }
    }

    static void loadDescriptorsFromClassPath(@NotNull Map<URL, String> urls, @NotNull DescriptorLoadingContext context, @Nullable URL platformPluginURL) throws ExecutionException, InterruptedException {
        if (urls == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(34);
        }
        if (context == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(35);
        }
        if (urls.isEmpty()) {
            return;
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(urls.size());
        ExecutorService executorService = context.parentContext.getExecutorService();
        for (Map.Entry<URL, String> entry : urls.entrySet()) {
            URL uRL = entry.getKey();
            tasks.add(executorService.submit(() -> PluginDescriptorLoader.loadDescriptorFromResource(url, (String)entry.getValue(), context.copy(url.equals(platformPluginURL)))));
        }
        PluginLoadingResult result = context.parentContext.result;
        for (Future future : tasks) {
            IdeaPluginDescriptorImpl descriptor = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor == null) continue;
            if (!PluginManagerCore.usePluginClassLoader) {
                descriptor.setUseCoreClassLoader();
            }
            result.add(descriptor, false);
        }
    }

    @Nullable
    private static URL computePlatformPluginUrlAndCollectPluginUrls(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        if (loader == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(36);
        }
        if (urls == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(37);
        }
        String platformPrefix = System.getProperty("idea.platform.prefix");
        URL result = null;
        if (platformPrefix != null) {
            if ((platformPrefix.equals("idea") || platformPrefix.equals("WebStorm")) && !PluginManagerCore.isRunningFromSources()) {
                urls.put(loader.getResource("META-INF/plugin.xml"), "plugin.xml");
                return null;
            }
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource("META-INF/" + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
                result = resource;
            }
        }
        PluginDescriptorLoader.collectPluginFilesInClassPath(loader, urls);
        return result;
    }

    static void collectPluginFilesInClassPath(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        if (loader == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(38);
        }
        if (urls == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(39);
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), "plugin.xml");
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info(e);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> loadUncachedDescriptors() {
        List<IdeaPluginDescriptorImpl> list = PluginDescriptorLoader.loadDescriptors().result.getEnabledPlugins();
        if (list == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(40);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptorFromArtifact(@NotNull Path file, @Nullable BuildNumber buildNumber) throws IOException {
        if (file == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(41);
        }
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(4, DisabledPluginsState.disabledPlugins(), PluginManagerCore.createLoadingResult(buildNumber));
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, false, false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            IdeaPluginDescriptorImpl descriptor = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file, "plugin.xml", context, false);
            if (descriptor == null && file.getFileName().toString().endsWith(".zip")) {
                File outputDir = FileUtil.createTempDirectory("plugin", "");
                try {
                    new Decompressor.Zip(file.toFile()).extract(outputDir);
                    File[] files = outputDir.listFiles();
                    if (files != null && files.length == 1) {
                        descriptor = PluginDescriptorLoader.loadDescriptorFromFileOrDir(files[0].toPath(), "plugin.xml", context, true);
                    }
                }
                finally {
                    FileUtil.delete(outputDir);
                }
            }
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    public static IdeaPluginDescriptorImpl tryLoadFullDescriptor(@NotNull IdeaPluginDescriptorImpl descriptor) {
        if (descriptor == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(42);
        }
        PathBasedJdomXIncluder.PathResolver<?> resolver = PluginDescriptorLoader.createPathResolverForPlugin(descriptor, null);
        return PluginManager.loadDescriptor(descriptor.getPluginPath(), "plugin.xml", Collections.emptySet(), descriptor.isBundled(), resolver);
    }

    @NotNull
    static PathBasedJdomXIncluder.PathResolver<?> createPathResolverForPlugin(@NotNull IdeaPluginDescriptorImpl descriptor, @Nullable DescriptorLoadingContext context) {
        PathBasedJdomXIncluder.PathResolver<Path> resolver;
        if (descriptor == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(43);
        }
        if (PluginManagerCore.isRunningFromSources() && descriptor.getPluginPath().getFileSystem().equals(FileSystems.getDefault()) && descriptor.getPluginPath().toString().contains("out/classes")) {
            return new ClassPathXmlPathResolver(descriptor.getPluginClassLoader());
        }
        if (context != null && (resolver = PluginManagerCore.createPluginJarsPathResolver(descriptor.getPluginPath(), context)) != null) {
            PathBasedJdomXIncluder.PathResolver<Path> pathResolver = resolver;
            if (pathResolver == null) {
                PluginDescriptorLoader.$$$reportNull$$$0(44);
            }
            return pathResolver;
        }
        PathBasedJdomXIncluder.PathResolver<Path> pathResolver = PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER;
        if (pathResolver == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(45);
        }
        return pathResolver;
    }

    @NotNull
    public static IdeaPluginDescriptorImpl loadFullDescriptor(@NotNull IdeaPluginDescriptorImpl descriptor) {
        IdeaPluginDescriptorImpl fullDescriptor;
        if (descriptor == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(46);
        }
        if ((fullDescriptor = PluginDescriptorLoader.tryLoadFullDescriptor(descriptor)) == null) {
            PluginManagerCore.getLogger().error("Could not load full descriptor for plugin " + descriptor.getPluginPath());
            fullDescriptor = descriptor;
        }
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = fullDescriptor;
        if (ideaPluginDescriptorImpl == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(47);
        }
        return ideaPluginDescriptorImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorRelativePath";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 10: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginJarFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInLibUnderPluginDir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ide/plugins/PluginDescriptorLoader";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 42: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ide/plugins/PluginDescriptorLoader";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUncachedDescriptors";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathResolverForPlugin";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFullDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromFileOrDir";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDirAndNormalize";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginDirectoryContents";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putMoreLikelyPluginJarsFirst";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fileNameIsLikeVersionedLibraryName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromDir";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromClassPath";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformPluginUrlAndCollectPluginUrls";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginFilesInClassPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromArtifact";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFullDescriptor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createPathResolverForPlugin";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadFullDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

