/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight.completion.impl;

import sqldelight.com.intellij.codeInsight.CodeInsightSettings;
import sqldelight.com.intellij.codeInsight.completion.CompletionUtil;
import sqldelight.com.intellij.codeInsight.completion.PrefixMatcher;
import sqldelight.com.intellij.codeInsight.lookup.LookupElement;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.openapi.util.TextRange;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.psi.codeStyle.MinusculeMatcher;
import sqldelight.com.intellij.psi.codeStyle.NameUtil;
import sqldelight.com.intellij.util.containers.FList;
import sqldelight.com.intellij.util.text.CharArrayUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class CamelHumpMatcher
extends PrefixMatcher {
    private final MinusculeMatcher myMatcher;
    private final MinusculeMatcher myCaseInsensitiveMatcher;
    private final boolean myCaseSensitive;
    private static boolean ourForceStartMatching;
    private final boolean myTypoTolerant;

    public CamelHumpMatcher(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(0);
        }
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        this(prefix, caseSensitive, false);
    }

    @ApiStatus.Internal
    public CamelHumpMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        super(prefix);
        this.myCaseSensitive = caseSensitive;
        this.myTypoTolerant = typoTolerant;
        this.myMatcher = this.createMatcher(this.myCaseSensitive);
        this.myCaseInsensitiveMatcher = this.createMatcher(false);
    }

    @Override
    public boolean isStartMatch(String name) {
        return this.myMatcher.isStartMatch(name);
    }

    @Override
    public boolean isStartMatch(LookupElement element) {
        for (String s : CompletionUtil.iterateLookupStrings(element)) {
            FList<TextRange> ranges = this.myCaseInsensitiveMatcher.matchingFragments(s);
            if (ranges == null || !ranges.isEmpty() && CamelHumpMatcher.skipUnderscores(s) < ranges.get(0).getStartOffset()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isTypoTolerant() {
        return this.myTypoTolerant;
    }

    private static int skipUnderscores(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(1);
        }
        return CharArrayUtil.shiftForward(name, 0, "_");
    }

    @Override
    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(2);
        }
        if (name.startsWith("_") && CodeInsightSettings.getInstance().getCompletionCaseSensitive() == 3 && this.firstLetterCaseDiffers(name)) {
            return false;
        }
        return this.myMatcher.matches(name);
    }

    private boolean firstLetterCaseDiffers(String name) {
        int nameFirst = CamelHumpMatcher.skipUnderscores(name);
        int prefixFirst = CamelHumpMatcher.skipUnderscores(this.myPrefix);
        return nameFirst < name.length() && prefixFirst < this.myPrefix.length() && CamelHumpMatcher.caseDiffers(name.charAt(nameFirst), this.myPrefix.charAt(prefixFirst));
    }

    private static boolean caseDiffers(char c1, char c2) {
        return Character.isLowerCase(c1) != Character.isLowerCase(c2) || Character.isUpperCase(c1) != Character.isUpperCase(c2);
    }

    @Override
    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            CamelHumpMatcher.$$$reportNull$$$0(3);
        }
        return this.prefixMatchersInternal(element, !element.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element, boolean itemCaseInsensitive) {
        for (String name : element.getAllLookupStrings()) {
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase(name, this.myPrefix) || this.prefixMatches(name)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().getCompletionCaseSensitive() || !this.myCaseInsensitiveMatcher.matches(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(4);
        }
        if (prefix.equals(this.myPrefix)) {
            CamelHumpMatcher camelHumpMatcher = this;
            if (camelHumpMatcher == null) {
                CamelHumpMatcher.$$$reportNull$$$0(5);
            }
            return camelHumpMatcher;
        }
        return new CamelHumpMatcher(prefix, this.myCaseSensitive, this.myTypoTolerant);
    }

    private MinusculeMatcher createMatcher(boolean caseSensitive) {
        String prefix = CamelHumpMatcher.applyMiddleMatching(this.myPrefix);
        NameUtil.MatcherBuilder builder = NameUtil.buildMatcher(prefix);
        if (caseSensitive) {
            int setting = CodeInsightSettings.getInstance().getCompletionCaseSensitive();
            if (setting == 3) {
                builder = builder.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.FIRST_LETTER);
            } else if (setting == 1) {
                builder = builder.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.ALL);
            }
        }
        if (this.myTypoTolerant) {
            builder = builder.typoTolerant();
        }
        return builder.build();
    }

    public static String applyMiddleMatching(String prefix) {
        if (Registry.is("ide.completion.middle.matching") && !prefix.isEmpty() && !ourForceStartMatching) {
            return "*" + StringUtil.replace(prefix, ".", ". ").trim();
        }
        return prefix;
    }

    public String toString() {
        return this.myPrefix;
    }

    @Deprecated
    public static void forceStartMatching(Disposable parent) {
        ourForceStartMatching = true;
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                ourForceStartMatching = false;
            }
        });
    }

    @Override
    public int matchingDegree(String string) {
        return this.matchingDegree(string, this.matchingFragments(string));
    }

    @Nullable
    public FList<TextRange> matchingFragments(String string) {
        return this.myMatcher.matchingFragments(string);
    }

    public int matchingDegree(String string, @Nullable FList<? extends TextRange> fragments) {
        int matchStart;
        FList<TextRange> ciRanges;
        int underscoreEnd = CamelHumpMatcher.skipUnderscores(string);
        if (underscoreEnd > 0 && (ciRanges = this.myCaseInsensitiveMatcher.matchingFragments(string)) != null && !ciRanges.isEmpty() && (matchStart = ciRanges.get(0).getStartOffset()) > 0 && matchStart <= underscoreEnd) {
            return this.myCaseInsensitiveMatcher.matchingDegree(string.substring(matchStart), true) - 1;
        }
        return this.myMatcher.matchingDegree(string, true, fragments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipUnderscores";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

