/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import sqldelight.com.intellij.codeInsight.AnnotationInvocationHandler;
import sqldelight.com.intellij.codeInsight.AnnotationTargetUtil;
import sqldelight.com.intellij.codeInsight.ExternalAnnotationsManager;
import sqldelight.com.intellij.codeInsight.InferredAnnotationsManager;
import sqldelight.com.intellij.codeInsight.NullableNotNullManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.psi.HierarchicalMethodSignature;
import sqldelight.com.intellij.psi.JavaPsiFacade;
import sqldelight.com.intellij.psi.LambdaUtil;
import sqldelight.com.intellij.psi.PsiAnnotation;
import sqldelight.com.intellij.psi.PsiAnnotationMemberValue;
import sqldelight.com.intellij.psi.PsiAnnotationMethod;
import sqldelight.com.intellij.psi.PsiAnnotationParameterList;
import sqldelight.com.intellij.psi.PsiArrayInitializerMemberValue;
import sqldelight.com.intellij.psi.PsiClass;
import sqldelight.com.intellij.psi.PsiClassType;
import sqldelight.com.intellij.psi.PsiConstantEvaluationHelper;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiLambdaExpression;
import sqldelight.com.intellij.psi.PsiLocalVariable;
import sqldelight.com.intellij.psi.PsiMember;
import sqldelight.com.intellij.psi.PsiMethod;
import sqldelight.com.intellij.psi.PsiModifierList;
import sqldelight.com.intellij.psi.PsiModifierListOwner;
import sqldelight.com.intellij.psi.PsiNameValuePair;
import sqldelight.com.intellij.psi.PsiParameter;
import sqldelight.com.intellij.psi.PsiParameterList;
import sqldelight.com.intellij.psi.PsiReference;
import sqldelight.com.intellij.psi.PsiResolveHelper;
import sqldelight.com.intellij.psi.PsiType;
import sqldelight.com.intellij.psi.PsiTypeParameter;
import sqldelight.com.intellij.psi.PsiVariable;
import sqldelight.com.intellij.psi.util.CachedValueProvider;
import sqldelight.com.intellij.psi.util.CachedValuesManager;
import sqldelight.com.intellij.psi.util.InheritanceUtil;
import sqldelight.com.intellij.psi.util.PsiModificationTracker;
import sqldelight.com.intellij.psi.util.PsiTreeUtil;
import sqldelight.com.intellij.psi.util.PsiUtil;
import sqldelight.com.intellij.psi.util.PsiUtilCore;
import sqldelight.com.intellij.util.ArrayUtil;
import sqldelight.com.intellij.util.BitUtil;
import sqldelight.com.intellij.util.Consumer;
import sqldelight.com.intellij.util.Processors;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.containers.ConcurrentFactoryMap;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.gnu.trove.THashMap;
import sqldelight.gnu.trove.THashSet;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final String NULLABLE = "sqldelight.org.jetbrains.annotations.Nullable";
    public static final String NOT_NULL = "sqldelight.org.jetbrains.annotations.NotNull";
    public static final String NON_NLS = "sqldelight.org.jetbrains.annotations.NonNls";
    public static final String NLS = "sqldelight.org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "sqldelight.org.jetbrains.annotations.PropertyKey";
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    public static final String TEST_ONLY = "sqldelight.org.jetbrains.annotations.TestOnly";
    public static final String LANGUAGE = "sqldelight.org.intellij.lang.annotations.Language";
    public static final int CHECK_HIERARCHY = 1;
    public static final int CHECK_EXTERNAL = 2;
    public static final int CHECK_INFERRED = 4;
    public static final int CHECK_TYPE = 8;
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet(annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(2);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(3);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (listOwner == null) {
            return null;
        }
        List<PsiAnnotation> result = AnnotationUtil.findAllAnnotations(listOwner, annotationNames, skipExternal);
        return result.isEmpty() ? null : result.get(0);
    }

    @NotNull
    public static List<PsiAnnotation> findAllAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(5);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(6);
        }
        List<PsiAnnotation> ownAnnotations = AnnotationUtil.findOwnAnnotations(listOwner, annotationNames);
        List<PsiAnnotation> nonCodeAnnotations = skipExternal ? null : AnnotationUtil.findNonCodeAnnotations(listOwner, annotationNames);
        SmartList annotations = null;
        if (ownAnnotations != null || nonCodeAnnotations != null) {
            annotations = new SmartList();
            if (ownAnnotations != null) {
                annotations.addAll(ownAnnotations);
            }
            if (nonCodeAnnotations != null) {
                annotations.addAll(nonCodeAnnotations);
            }
        }
        List<PsiAnnotation> list = annotations == null ? Collections.emptyList() : annotations;
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static List<PsiAnnotation> findOwnAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        PsiModifierList list;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(8);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(9);
        }
        if ((list = listOwner.getModifierList()) == null) {
            return null;
        }
        SmartList<PsiAnnotation> result = null;
        for (PsiAnnotation annotation : list.getAnnotations()) {
            if (!ContainerUtil.exists(annotationNames, annotation::hasQualifiedName) || !AnnotationUtil.isApplicableToDeclaration(annotation, list)) continue;
            if (result == null) {
                result = new SmartList<PsiAnnotation>();
            }
            result.add(annotation);
        }
        return result;
    }

    private static boolean isApplicableToDeclaration(PsiAnnotation annotation, PsiModifierList list) {
        PsiAnnotation.TargetType[] allTargets = AnnotationTargetUtil.getTargetsForLocation(list);
        if (allTargets.length == 0) {
            return true;
        }
        PsiAnnotation.TargetType[] nonTypeUse = (PsiAnnotation.TargetType[])Stream.of(allTargets).filter(t -> t != PsiAnnotation.TargetType.TYPE_USE).toArray(PsiAnnotation.TargetType[]::new);
        return AnnotationTargetUtil.findAnnotationTarget(annotation, nonTypeUse) != null;
    }

    @Nullable
    private static List<PsiAnnotation> findNonCodeAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(10);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(11);
        }
        if (listOwner instanceof PsiLocalVariable) {
            return null;
        }
        Map map = (Map)CachedValuesManager.getCachedValue(listOwner, () -> {
            ConcurrentMap<Collection, List> value = ConcurrentFactoryMap.createMap(annotationNames1 -> {
                PsiUtilCore.ensureValid(listOwner);
                Project project = listOwner.getProject();
                SmartList<PsiAnnotation> annotations = null;
                ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    List<PsiAnnotation> externalAnnotations = externalAnnotationsManager.findExternalAnnotations(listOwner, annotationName);
                    if (externalAnnotations.isEmpty()) continue;
                    if (annotations == null) {
                        annotations = new SmartList<PsiAnnotation>();
                    }
                    annotations.addAll(externalAnnotations);
                }
                InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                    if (annotation == null) continue;
                    if (annotations == null) {
                        annotations = new SmartList();
                    }
                    annotations.add(annotation);
                }
                return annotations;
            });
            return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (List)map.get(annotationNames);
    }

    public static PsiAnnotation @NotNull [] findAnnotations(@Nullable PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(12);
        }
        if (modifierListOwner == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                AnnotationUtil.$$$reportNull$$$0(13);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                AnnotationUtil.$$$reportNull$$$0(14);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] annotations = modifierList.getAnnotations();
        ArrayList<PsiAnnotation> result = null;
        for (PsiAnnotation psiAnnotation : annotations) {
            if (!annotationNames.contains(psiAnnotation.getQualifiedName())) continue;
            if (result == null) {
                result = new ArrayList<PsiAnnotation>();
            }
            result.add(psiAnnotation);
        }
        PsiAnnotation[] psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            AnnotationUtil.$$$reportNull$$$0(15);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        List list = (List)CachedValuesManager.getCachedValue(element, () -> {
            List<Object> list;
            LinkedHashSet result = new LinkedHashSet();
            if (element instanceof PsiMethod) {
                if (!element.hasModifierProperty("static")) {
                    AnnotationUtil.collectSuperMethods(result, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
                }
            } else if (element instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)element, false, Processors.cancelableCollectProcessor(result));
            } else if (element instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result, (PsiParameter)element);
            }
            if (result.isEmpty()) {
                list = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result.toArray(new PsiModifierListOwner[0]);
                list = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list, PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(18);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(19);
        }
        return AnnotationUtil.findAnnotationInHierarchy(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames, boolean skipExternal) {
        PsiAnnotation directAnnotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(20);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(21);
        }
        if ((directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames, skipExternal)) != null) {
            return directAnnotation;
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation(superOwner, annotationNames, skipExternal);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<? super PsiModifierListOwner> result, @NotNull PsiParameter parameter) {
        block7: {
            PsiElement scope;
            Consumer<PsiMethod> forEachSuperMethod;
            block6: {
                PsiElement parent;
                if (result == null) {
                    AnnotationUtil.$$$reportNull$$$0(22);
                }
                if (parameter == null) {
                    AnnotationUtil.$$$reportNull$$$0(23);
                }
                if (!((parent = parameter.getParent()) instanceof PsiParameterList)) {
                    return;
                }
                int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters = method.getParameterList().getParameters();
                    if (index < superParameters.length) {
                        result.add(superParameters[index]);
                    }
                };
                scope = parent.getParent();
                if (!(scope instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume(method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume(superMethod);
                }
                break block7;
            }
            if (scope instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope)) {
                    forEachSuperMethod.consume(superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<? super PsiModifierListOwner> result, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result == null) {
            AnnotationUtil.$$$reportNull$$$0(24);
        }
        if (signature == null) {
            AnnotationUtil.$$$reportNull$$$0(25);
        }
        if (place == null) {
            AnnotationUtil.$$$reportNull$$$0(26);
        }
        if (resolveHelper == null) {
            AnnotationUtil.$$$reportNull$$$0(27);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result, superSignature, place, resolveHelper);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiAnnotation findAnnotationInTypeHierarchy(@Nullable PsiType type2, @NotNull Set<String> qualifiedNames) {
        if (qualifiedNames == null) {
            AnnotationUtil.$$$reportNull$$$0(28);
        }
        if (type2 == null) {
            return null;
        }
        Ref<Object> result = Ref.create(null);
        InheritanceUtil.processSuperTypes(type2, true, eachType -> {
            for (PsiAnnotation annotation : eachType.getAnnotations()) {
                String qualifiedName = annotation.getQualifiedName();
                if (!qualifiedNames.contains(qualifiedName)) continue;
                result.set(annotation);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly(eachType) instanceof PsiTypeParameter;
        });
        return result.get();
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, @Flags int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(29);
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(30);
        }
        return annotations.stream().anyMatch(annotation -> AnnotationUtil.isAnnotated(listOwner, annotation, flags, null));
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFqn, @Flags int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(31);
        }
        if (annotationFqn == null) {
            AnnotationUtil.$$$reportNull$$$0(32);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFqn, flags, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Flags int flags, @Nullable Set<? super PsiMember> processed) {
        block20: {
            block21: {
                Project project;
                PsiModifierList modifierList;
                if (listOwner == null) {
                    AnnotationUtil.$$$reportNull$$$0(33);
                }
                if (annotationFQN == null) {
                    AnnotationUtil.$$$reportNull$$$0(34);
                }
                if ((modifierList = listOwner.getModifierList()) == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 8)) {
                    PsiType type2 = null;
                    if (listOwner instanceof PsiMethod) {
                        type2 = ((PsiMethod)listOwner).getReturnType();
                    } else if (listOwner instanceof PsiParameter && listOwner.getParent() instanceof PsiParameterList && listOwner.getParent().getParent() instanceof PsiLambdaExpression) {
                        if (((PsiParameter)listOwner).getTypeElement() != null) {
                            type2 = ((PsiParameter)listOwner).getType();
                        }
                    } else if (listOwner instanceof PsiVariable) {
                        type2 = ((PsiVariable)listOwner).getType();
                    }
                    if (type2 != null && type2.hasAnnotation(annotationFQN)) {
                        return true;
                    }
                }
                if (BitUtil.isSet(flags, 2) && ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 4) && InferredAnnotationsManager.getInstance(project = listOwner.getProject()).findInferredAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!BitUtil.isSet(flags, 1)) break block20;
                if (!(listOwner instanceof PsiMethod)) break block21;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet<PsiMember>();
                }
                if (!processed.add(method)) {
                    return false;
                }
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, annotationFQN, flags, processed)) continue;
                    return true;
                }
                break block20;
            }
            if (!(listOwner instanceof PsiClass)) break block20;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superClass, annotationFQN, flags, processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt) {
        if (elt == null) {
            AnnotationUtil.$$$reportNull$$$0(35);
        }
        return AnnotationUtil.isAnnotatingApplicable(elt, NullableNotNullManager.getInstance(elt.getProject()).getDefaultNullable());
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt, @NotNull String annotationFQN) {
        if (elt == null) {
            AnnotationUtil.$$$reportNull$$$0(36);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(37);
        }
        Project project = elt.getProject();
        return PsiUtil.isLanguageLevel5OrHigher(elt) && JavaPsiFacade.getInstance(project).findClass(annotationFQN, elt.getResolveScope()) != null;
    }

    @Contract(value="null,_ -> false")
    public static boolean checkAnnotatedUsingPatterns(@Nullable PsiModifierListOwner owner, @NotNull Collection<String> annotations) {
        PsiModifierList modList;
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(38);
        }
        if (owner == null || (modList = owner.getModifierList()) == null) {
            return false;
        }
        ArrayList<String> fqns = null;
        for (String fqn : annotations) {
            boolean isPattern = fqn.endsWith("*");
            if (!isPattern && AnnotationUtil.isAnnotated(owner, fqn, 0)) {
                return true;
            }
            if (!isPattern) continue;
            if (fqns == null) {
                PsiAnnotation[] ownAnnotations;
                fqns = new ArrayList<String>();
                for (PsiAnnotation anno : ownAnnotations = modList.getAnnotations()) {
                    String qName = anno.getQualifiedName();
                    if (qName == null) continue;
                    fqns.add(qName);
                }
                if (fqns.isEmpty()) {
                    return false;
                }
            }
            fqn = fqn.substring(0, fqn.length() - 2);
            for (String annoFQN : fqns) {
                if (!annoFQN.startsWith(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            AnnotationUtil.$$$reportNull$$$0(39);
        }
        PsiAnnotation annotation = PsiTreeUtil.getParentOfType(pair.getParent(), PsiAnnotation.class);
        assert (annotation != null);
        String fqn = annotation.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance(pair.getProject()).findClass(fqn, pair.getResolveScope());
        if (psiClass != null && psiClass.isAnnotationType()) {
            String name = pair.getName();
            return ArrayUtil.getFirstElement(psiClass.findMethodsByName(name != null ? name : "value", false));
        }
        return null;
    }

    public static PsiAnnotation @NotNull [] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited) {
        if (owner == null) {
            AnnotationUtil.$$$reportNull$$$0(40);
        }
        return AnnotationUtil.getAllAnnotations(owner, inHierarchy, visited, true);
    }

    public static PsiAnnotation @NotNull [] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited, boolean withInferred) {
        Project project;
        PsiAnnotation[] externalAnnotations;
        if (owner == null) {
            AnnotationUtil.$$$reportNull$$$0(41);
        }
        PsiModifierList list = owner.getModifierList();
        PsiAnnotation[] annotations = PsiAnnotation.EMPTY_ARRAY;
        if (list != null) {
            annotations = list.getAnnotations();
        }
        if ((externalAnnotations = ExternalAnnotationsManager.getInstance(project = owner.getProject()).findExternalAnnotations(owner)) != null) {
            annotations = ArrayUtil.mergeArrays(annotations, externalAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (withInferred) {
            PsiElement[] inferredAnnotations = InferredAnnotationsManager.getInstance(project).findInferredAnnotations(owner);
            annotations = ArrayUtil.mergeArrays(annotations, inferredAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (inHierarchy) {
            PsiParameter parameter;
            PsiElement scope;
            if (owner instanceof PsiClass) {
                for (PsiElement psiElement : ((PsiClass)owner).getSupers()) {
                    if (visited == null) {
                        visited = new THashSet<PsiModifierListOwner>();
                    }
                    if (!visited.add((PsiModifierListOwner)psiElement)) continue;
                    annotations = ArrayUtil.mergeArrays(annotations, AnnotationUtil.getAllAnnotations((PsiModifierListOwner)psiElement, true, visited, withInferred));
                }
            } else if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                PsiClass aClass = method.getContainingClass();
                if (aClass != null) {
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> list2 = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : list2) {
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet<PsiModifierListOwner>();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null)) continue;
                        annotations = ArrayUtil.mergeArrays(annotations, AnnotationUtil.getAllAnnotations(superMethod, true, visited, withInferred));
                    }
                }
            } else if (owner instanceof PsiParameter && (scope = (parameter = (PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiClass psiClass = method.getContainingClass();
                PsiElement parent = parameter.getParent();
                if (psiClass != null && parent instanceof PsiParameterList) {
                    int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(psiClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiParameter[] superParameters;
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet<PsiModifierListOwner>();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length) continue;
                        annotations = ArrayUtil.mergeArrays(annotations, AnnotationUtil.getAllAnnotations(superParameters[index], true, visited, withInferred));
                    }
                }
            }
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(42);
        }
        return annotations;
    }

    public static boolean isInsideAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(43);
        }
        for (int level = 0; level < 4; ++level) {
            if (element instanceof PsiNameValuePair) {
                return true;
            }
            if ((element = element.getParent()) != null) continue;
            return false;
        }
        return false;
    }

    public static boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(44);
        }
        return InferredAnnotationsManager.getInstance(annotation.getProject()).isInferredAnnotation(annotation);
    }

    public static boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(45);
        }
        return ExternalAnnotationsManager.getInstance(annotation.getProject()).isExternalAnnotation(annotation);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue;
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(46);
        }
        return (attrValue = anno.findAttributeValue(attributeName)) == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static Boolean getBooleanAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(47);
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Boolean ? (Boolean)constValue : null;
    }

    @Nullable
    public static Long getLongAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(48);
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Number ? Long.valueOf(((Number)constValue).longValue()) : null;
    }

    @Nullable
    public static String getDeclaredStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue;
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(49);
        }
        return (attrValue = anno.findDeclaredAttributeValue(attributeName)) == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotationMemberValue attrValue) {
        PsiConstantEvaluationHelper evaluationHelper;
        Object constValue;
        if (attrValue == null) {
            AnnotationUtil.$$$reportNull$$$0(50);
        }
        return (constValue = (evaluationHelper = JavaPsiFacade.getInstance(attrValue.getProject()).getConstantEvaluationHelper()).computeConstantExpression(attrValue)) instanceof String ? (String)constValue : null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Class<T> annotationClass) {
        PsiAnnotation annotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(51);
        }
        if (annotationClass == null) {
            AnnotationUtil.$$$reportNull$$$0(52);
        }
        if ((annotation = AnnotationUtil.findAnnotationInHierarchy(listOwner, Collections.singleton(annotationClass.getName()))) == null) {
            return null;
        }
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annotationClass, annotation);
        Annotation t = (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)handler);
        return (T)t;
    }

    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation, @Nullable(value="null means 'value'") @Nullable(value="null means 'value'") String attributeName) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(53);
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Objects.equals(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute;
        }
        return null;
    }

    public static boolean equal(@Nullable PsiAnnotation a, @Nullable PsiAnnotation b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        String name = a.getQualifiedName();
        if (name == null || !name.equals(b.getQualifiedName())) {
            return false;
        }
        THashMap<String, PsiAnnotationMemberValue> valueMap1 = new THashMap<String, PsiAnnotationMemberValue>(2);
        THashMap<String, PsiAnnotationMemberValue> valueMap2 = new THashMap<String, PsiAnnotationMemberValue>(2);
        if (!AnnotationUtil.fillValueMap(a.getParameterList(), valueMap1) || !AnnotationUtil.fillValueMap(b.getParameterList(), valueMap2) || valueMap1.size() != valueMap2.size()) {
            return false;
        }
        for (Map.Entry entry : valueMap1.entrySet()) {
            if (AnnotationUtil.equal((PsiAnnotationMemberValue)entry.getValue(), (PsiAnnotationMemberValue)valueMap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean fillValueMap(@NotNull PsiAnnotationParameterList parameterList, @NotNull Map<String, PsiAnnotationMemberValue> valueMap) {
        PsiNameValuePair[] attributes1;
        if (parameterList == null) {
            AnnotationUtil.$$$reportNull$$$0(54);
        }
        if (valueMap == null) {
            AnnotationUtil.$$$reportNull$$$0(55);
        }
        for (PsiNameValuePair attribute : attributes1 = parameterList.getAttributes()) {
            PsiReference reference = attribute.getReference();
            if (reference == null) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiAnnotationMethod)) {
                return false;
            }
            PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)target;
            PsiAnnotationMemberValue defaultValue = annotationMethod.getDefaultValue();
            PsiAnnotationMemberValue value = attribute.getValue();
            if (AnnotationUtil.equal(value, defaultValue)) continue;
            String name1 = attribute.getName();
            valueMap.put(name1 == null ? "value" : name1, value);
        }
        return true;
    }

    public static boolean equal(@Nullable PsiAnnotationMemberValue value1, @Nullable PsiAnnotationMemberValue value2) {
        if (value1 instanceof PsiArrayInitializerMemberValue && value2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers2;
            PsiAnnotationMemberValue[] initializers1 = ((PsiArrayInitializerMemberValue)value1).getInitializers();
            if (initializers1.length != (initializers2 = ((PsiArrayInitializerMemberValue)value2).getInitializers()).length) {
                return false;
            }
            for (int i = 0; i < initializers1.length; ++i) {
                if (AnnotationUtil.equal(initializers1[i], initializers2[i])) continue;
                return false;
            }
            return true;
        }
        if (value1 != null && value2 != null) {
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance(value1.getProject()).getConstantEvaluationHelper();
            Object const1 = constantEvaluationHelper.computeConstantExpression(value1);
            Object const2 = constantEvaluationHelper.computeConstantExpression(value2);
            return const1 != null && const1.equals(const2);
        }
        return false;
    }

    public static boolean equal(PsiAnnotation @NotNull [] annotations1, PsiAnnotation @NotNull [] annotations2) {
        if (annotations1 == null) {
            AnnotationUtil.$$$reportNull$$$0(56);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(57);
        }
        Map<String, PsiAnnotation> map1 = AnnotationUtil.buildAnnotationMap(annotations1);
        Map<String, PsiAnnotation> map2 = AnnotationUtil.buildAnnotationMap(annotations2);
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, PsiAnnotation> entry : map1.entrySet()) {
            if (AnnotationUtil.equal(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, PsiAnnotation> buildAnnotationMap(PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(58);
        }
        HashMap<String, PsiAnnotation> map = new HashMap<String, PsiAnnotation>();
        for (PsiAnnotation annotation : annotations) {
            map.put(annotation.getQualifiedName(), annotation);
        }
        map.remove("java.lang.Override");
        map.remove("java.lang.SuppressWarnings");
        HashMap<String, PsiAnnotation> hashMap = map;
        if (hashMap == null) {
            AnnotationUtil.$$$reportNull$$$0(59);
        }
        return hashMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isJetbrainsAnnotation(@NotNull String simpleName) {
        if (simpleName == null) {
            AnnotationUtil.$$$reportNull$$$0(60);
        }
        return ArrayUtil.find(SIMPLE_NAMES, simpleName) != -1;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(61);
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(62);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations, 8);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, boolean checkHierarchy) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(63);
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(64);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations, AnnotationUtil.flags(checkHierarchy, true, true));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(65);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(66);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, true, true));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(67);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(68);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, skipExternal, skipExternal));
    }

    @Flags
    private static int flags(boolean checkHierarchy, boolean skipExternal, boolean skipInferred) {
        int flags = 8;
        if (checkHierarchy) {
            flags |= 1;
        }
        if (!skipExternal) {
            flags |= 2;
        }
        if (!skipInferred) {
            flags |= 4;
        }
        return flags;
    }

    @NotNull
    public static List<PsiAnnotationMemberValue> arrayAttributeValues(@Nullable PsiAnnotationMemberValue attributeValue) {
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            List<PsiAnnotationMemberValue> list = Arrays.asList(((PsiArrayInitializerMemberValue)attributeValue).getInitializers());
            if (list == null) {
                AnnotationUtil.$$$reportNull$$$0(69);
            }
            return list;
        }
        List<PsiAnnotationMemberValue> list = ContainerUtil.createMaybeSingletonList(attributeValue);
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(70);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 18: 
            case 20: 
            case 29: 
            case 31: 
            case 33: 
            case 51: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 16: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 30: 
            case 38: 
            case 58: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
            case 34: 
            case 37: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 44: 
            case 45: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations1";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations2";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAnnotations";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperAnnotationOwners";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotationMap";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayAttributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllAnnotations";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOwnAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findNonCodeAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuperAnnotationOwners";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInHierarchy";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperParameters";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInTypeHierarchy";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatingApplicable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedUsingPatterns";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMethod";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnnotation";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 46: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttributeValue";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAttributeValue";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLongAttributeValue";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredStringAttributeValue";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttribute";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fillValueMap";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotationMap";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isJetbrainsAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Flags {
    }
}

