/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.scala;

import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import scala.concurrent.Future;
import scala.concurrent.Promise;

final class ResponseCallAdapter<T>
implements CallAdapter<T, Future<Response<T>>> {
    private final Type responseType;

    ResponseCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Future<Response<T>> adapt(Call<T> call) {
        final Promise promise = Promise.apply();
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                promise.success(response);
            }

            public void onFailure(Call<T> call, Throwable t) {
                promise.failure(t);
            }
        });
        return promise.future();
    }
}

