/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.proto;

import com.squareup.proto.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EnumType
implements Type {
    private final String name;
    private final String documentation;
    private final List<Value> values;

    EnumType(String name, String documentation, List<Value> values) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.name = name;
        this.documentation = documentation;
        this.values = Collections.unmodifiableList(new ArrayList<Value>(values));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Value> getValues() {
        return this.values;
    }

    @Override
    public List<Type> getNestedTypes() {
        return Collections.emptyList();
    }

    public boolean equals(Object other) {
        if (other instanceof EnumType) {
            EnumType that = (EnumType)other;
            return this.name.equals(that.name) && this.documentation.equals(that.documentation) && ((Object)this.values).equals(that.values);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        for (Value value : this.values) {
            result.append("\n  ").append(value);
        }
        return result.toString();
    }

    public static final class Value {
        private final String name;
        private final int tag;
        private final String documentation;

        Value(String name, int tag, String documentation) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            this.name = name;
            this.tag = tag;
            this.documentation = documentation;
        }

        public String getName() {
            return this.name;
        }

        public int getTag() {
            return this.tag;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean equals(Object other) {
            if (other instanceof Value) {
                Value that = (Value)other;
                return this.name.equals(that.name) && this.tag == that.tag && this.documentation.equals(that.documentation);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return String.format("%s = %d", this.name, this.tag);
        }
    }
}

