/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import com.squareup.otto.AnnotatedHandlerFinder;
import com.squareup.otto.DeadEvent;
import com.squareup.otto.EventHandler;
import com.squareup.otto.EventProducer;
import com.squareup.otto.ThreadEnforcer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;

public class Bus {
    public static final String DEFAULT_IDENTIFIER = "default";
    private final Map<Class<?>, Set<EventHandler>> handlersByType = new ConcurrentHashMap();
    private final Map<Class<?>, EventProducer> producersByType = new ConcurrentHashMap();
    private final String identifier;
    private final ThreadEnforcer enforcer;
    private final ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>> eventsToDispatch = new ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>>(){

        @Override
        protected ConcurrentLinkedQueue<EventWithHandler> initialValue() {
            return new ConcurrentLinkedQueue<EventWithHandler>();
        }
    };
    private final ThreadLocal<Boolean> isDispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final Map<Class<?>, Set<Class<?>>> flattenHierarchyCache = new HashMap();

    public Bus() {
        this(DEFAULT_IDENTIFIER);
    }

    public Bus(String identifier) {
        this(ThreadEnforcer.MAIN, identifier);
    }

    public Bus(ThreadEnforcer enforcer) {
        this(enforcer, DEFAULT_IDENTIFIER);
    }

    public Bus(ThreadEnforcer enforcer, String identifier) {
        this.enforcer = enforcer;
        this.identifier = identifier;
    }

    public String toString() {
        return "[Bus \"" + this.identifier + "\"]";
    }

    public void register(Object object) {
        Set<EventHandler> handlers;
        this.enforcer.enforce(this);
        Map<Class<?>, EventProducer> foundProducers = AnnotatedHandlerFinder.findAllProducers(object);
        for (Class<?> type : foundProducers.keySet()) {
            if (this.producersByType.containsKey(type)) {
                throw new IllegalArgumentException("Producer method for type " + type + " already registered.");
            }
            EventProducer producer = foundProducers.get(type);
            this.producersByType.put(type, producer);
            handlers = this.handlersByType.get(type);
            if (handlers == null || handlers.isEmpty()) continue;
            for (EventHandler handler : handlers) {
                this.dispatchProducerResultToHandler(handler, producer);
            }
        }
        Map<Class<?>, Set<EventHandler>> foundHandlersMap = AnnotatedHandlerFinder.findAllSubscribers(object);
        for (Class<?> type : foundHandlersMap.keySet()) {
            handlers = this.handlersByType.get(type);
            if (handlers == null) {
                handlers = new CopyOnWriteArraySet<EventHandler>();
                this.handlersByType.put(type, handlers);
            }
            Set<EventHandler> foundHandlers = foundHandlersMap.get(type);
            handlers.addAll(foundHandlers);
            EventProducer producer = this.producersByType.get(type);
            if (producer == null) continue;
            for (EventHandler foundHandler : foundHandlers) {
                this.dispatchProducerResultToHandler(foundHandler, producer);
            }
        }
    }

    private void dispatchProducerResultToHandler(EventHandler handler, EventProducer producer) {
        Object event = null;
        try {
            event = producer.produceEvent();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Producer " + producer + " threw an exception.", e);
        }
        if (event == null) {
            return;
        }
        try {
            handler.handleEvent(event);
        }
        catch (InvocationTargetException e) {
            String type = event.getClass().toString();
            throw new RuntimeException("Could not dispatch event " + type + " from " + producer + " to handler " + handler, e);
        }
    }

    public void unregister(Object object) {
        this.enforcer.enforce(this);
        Map<Class<?>, EventProducer> producersInListener = AnnotatedHandlerFinder.findAllProducers(object);
        for (Map.Entry<Class<?>, EventProducer> entry : producersInListener.entrySet()) {
            Class<?> key = entry.getKey();
            EventProducer producer = this.getProducerForEventType(key);
            EventProducer value = entry.getValue();
            if (value == null || !value.equals(producer)) {
                throw new IllegalArgumentException("Missing event producer for an annotated method. Is " + object.getClass() + " registered?");
            }
            this.producersByType.remove(key);
        }
        Map<Class<?>, Set<EventHandler>> handlersInListener = AnnotatedHandlerFinder.findAllSubscribers(object);
        for (Map.Entry<Class<?>, Set<EventHandler>> entry : handlersInListener.entrySet()) {
            Set<EventHandler> currentHandlers = this.getHandlersForEventType(entry.getKey());
            Collection eventMethodsInListener = entry.getValue();
            if (currentHandlers != null && currentHandlers.removeAll(eventMethodsInListener)) continue;
            throw new IllegalArgumentException("Missing event handler for an annotated method. Is " + object.getClass() + " registered?");
        }
    }

    public void post(Object event) {
        this.enforcer.enforce(this);
        Set<Class<?>> dispatchTypes = this.flattenHierarchy(event.getClass());
        boolean dispatched = false;
        for (Class<?> eventType : dispatchTypes) {
            Set<EventHandler> wrappers = this.getHandlersForEventType(eventType);
            if (wrappers == null || wrappers.isEmpty()) continue;
            dispatched = true;
            for (EventHandler wrapper : wrappers) {
                this.enqueueEvent(event, wrapper);
            }
        }
        if (!dispatched && !(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
        this.dispatchQueuedEvents();
    }

    protected void enqueueEvent(Object event, EventHandler handler) {
        this.eventsToDispatch.get().offer(new EventWithHandler(event, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventWithHandler eventWithHandler;
            while ((eventWithHandler = this.eventsToDispatch.get().poll()) != null) {
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.set(false);
        }
    }

    protected void dispatch(Object event, EventHandler wrapper) {
        try {
            wrapper.handleEvent(event);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not dispatch event: " + event.getClass() + " to handler " + wrapper, e);
        }
    }

    EventProducer getProducerForEventType(Class<?> type) {
        return this.producersByType.get(type);
    }

    Set<EventHandler> getHandlersForEventType(Class<?> type) {
        return this.handlersByType.get(type);
    }

    Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        Set<Class<?>> classes = this.flattenHierarchyCache.get(concreteClass);
        if (classes == null) {
            classes = this.getClassesFor(concreteClass);
            this.flattenHierarchyCache.put(concreteClass, classes);
        }
        return classes;
    }

    private Set<Class<?>> getClassesFor(Class<?> concreteClass) {
        LinkedList parents = new LinkedList();
        HashSet classes = new HashSet();
        parents.add(concreteClass);
        while (!parents.isEmpty()) {
            Class clazz = (Class)parents.remove(0);
            classes.add(clazz);
            Class parent = clazz.getSuperclass();
            if (parent == null) continue;
            parents.add(parent);
        }
        return classes;
    }

    static class EventWithHandler {
        final Object event;
        final EventHandler handler;

        public EventWithHandler(Object event, EventHandler handler) {
            this.event = event;
            this.handler = handler;
        }
    }
}

