/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010J0\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0010H\u0002J8\u0010#\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010%\u001a\u00020\u0010H\u0002J\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lokhttp3/internal/connection/ExchangeFinder;", "", "transmitter", "Lokhttp3/internal/connection/Transmitter;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "address", "Lokhttp3/Address;", "call", "Lokhttp3/Call;", "eventListener", "Lokhttp3/EventListener;", "(Lokhttp3/internal/connection/Transmitter;Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Address;Lokhttp3/Call;Lokhttp3/EventListener;)V", "connectingConnection", "Lokhttp3/internal/connection/RealConnection;", "hasStreamFailure", "", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "find", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "chain", "Lokhttp3/Interceptor$Chain;", "doExtensiveHealthChecks", "findConnection", "connectTimeout", "", "readTimeout", "writeTimeout", "pingIntervalMillis", "connectionRetryEnabled", "findHealthyConnection", "hasRouteToTry", "retryCurrentRoute", "trackFailure", "", "okhttp"})
public final class ExchangeFinder {
    private RouteSelector.Selection routeSelection;
    private final RouteSelector routeSelector;
    private RealConnection connectingConnection;
    private boolean hasStreamFailure;
    private final Transmitter transmitter;
    private final RealConnectionPool connectionPool;
    private final Address address;
    private final Call call;
    private final EventListener eventListener;

    @NotNull
    public final ExchangeCodec find(@NotNull OkHttpClient client, @NotNull Interceptor.Chain chain, boolean doExtensiveHealthChecks) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        int connectTimeout = chain.connectTimeoutMillis();
        int readTimeout = chain.readTimeoutMillis();
        int writeTimeout = chain.writeTimeoutMillis();
        int pingIntervalMillis = client.pingIntervalMillis();
        boolean connectionRetryEnabled = client.retryOnConnectionFailure();
        try {
            RealConnection resultConnection = this.findHealthyConnection(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled, doExtensiveHealthChecks);
            ExchangeCodec exchangeCodec = resultConnection.newCodec(client, chain);
            Intrinsics.checkExpressionValueIsNotNull((Object)exchangeCodec, (String)"resultConnection.newCodec(client, chain)");
            return exchangeCodec;
        }
        catch (RouteException e) {
            this.trackFailure();
            throw (Throwable)e;
        }
        catch (IOException e) {
            this.trackFailure();
            throw (Throwable)new RouteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws IOException {
        RealConnection candidate;
        while (true) {
            candidate = this.findConnection(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled);
            RealConnectionPool realConnectionPool = this.connectionPool;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (realConnectionPool) {
                block5: {
                    boolean bl3 = false;
                    if (candidate.successCount != 0) break block5;
                    RealConnection realConnection = candidate;
                    return realConnection;
                }
                Unit unit = Unit.INSTANCE;
            }
            if (candidate.isHealthy(doExtensiveHealthChecks)) break;
            candidate.noNewExchanges();
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled) throws IOException {
        block50: {
            block51: {
                foundPooledConnection = false;
                result = null;
                selectedRoute = null;
                releasedConnection = new Ref.ObjectRef();
                toClose = null;
                var11_11 = this.connectionPool;
                var12_13 = false;
                var13_15 = false;
                synchronized (var11_11) {
                    $i$a$-synchronized-ExchangeFinder$findConnection$1 = false;
                    if (this.transmitter.isCanceled()) {
                        throw (Throwable)new IOException("Canceled");
                    }
                    this.hasStreamFailure = false;
                    if (this.retryCurrentRoute()) {
                        v0 = this.transmitter.getConnection();
                        if (v0 == null) {
                            Intrinsics.throwNpe();
                        }
                        v1 = v0.route();
                    } else {
                        v1 = null;
                    }
                    previousRoute = v1;
                    releasedConnection.element = this.transmitter.getConnection();
                    if (this.transmitter.getConnection() == null) ** GOTO lbl-1000
                    v2 = this.transmitter.getConnection();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (v2.noNewExchanges) {
                        v3 = this.transmitter.releaseConnectionNoEvents();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = toClose = null;
                    }
                    if (this.transmitter.getConnection() != null) {
                        result = this.transmitter.getConnection();
                        releasedConnection.element = null;
                    }
                    if (result == null) {
                        if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, null, false)) {
                            foundPooledConnection = true;
                            result = this.transmitter.getConnection();
                        } else {
                            selectedRoute = previousRoute;
                        }
                    }
                    var13_16 /* !! */  = Unit.INSTANCE;
                }
                Util.closeQuietly(toClose);
                if ((RealConnection)releasedConnection.element != null) {
                    v4 = (RealConnection)releasedConnection.element;
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.eventListener.connectionReleased(this.call, v4);
                }
                if (foundPooledConnection) {
                    v5 = result;
                    if (v5 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.eventListener.connectionAcquired(this.call, v5);
                }
                if (result != null) {
                    v6 = result;
                    if (v6 == null) {
                        Intrinsics.throwNpe();
                    }
                    return v6;
                }
                newRouteSelection = false;
                if (selectedRoute != null) break block50;
                if (this.routeSelection == null) break block51;
                v7 = this.routeSelection;
                if (v7 == null) {
                    Intrinsics.throwNpe();
                }
                if (v7.hasNext()) break block50;
            }
            newRouteSelection = true;
            this.routeSelection = this.routeSelector.next();
        }
        routes = null;
        var13_16 /* !! */  = this.connectionPool;
        var14_18 = false;
        var15_21 = false;
        synchronized (var13_16 /* !! */ ) {
            $i$a$-synchronized-ExchangeFinder$findConnection$2 = false;
            if (this.transmitter.isCanceled()) {
                throw (Throwable)new IOException("Canceled");
            }
            if (newRouteSelection) {
                v8 = this.routeSelection;
                if (v8 == null) {
                    Intrinsics.throwNpe();
                }
                if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, routes = v8.getRoutes(), false)) {
                    foundPooledConnection = true;
                    result = this.transmitter.getConnection();
                }
            }
            if (!foundPooledConnection) {
                if (selectedRoute == null) {
                    v9 = this.routeSelection;
                    if (v9 == null) {
                        Intrinsics.throwNpe();
                    }
                    selectedRoute = v9.next();
                }
                this.connectingConnection = result = new RealConnection(this.connectionPool, selectedRoute);
            }
            var15_22 = Unit.INSTANCE;
        }
        if (foundPooledConnection) {
            v10 = result;
            if (v10 == null) {
                Intrinsics.throwNpe();
            }
            this.eventListener.connectionAcquired(this.call, v10);
            v11 = result;
            if (v11 == null) {
                Intrinsics.throwNpe();
            }
            return v11;
        }
        v12 = result;
        if (v12 == null) {
            Intrinsics.throwNpe();
        }
        v12.connect(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled, this.call, this.eventListener);
        v13 = this.connectionPool.getRouteDatabase();
        v14 = result;
        if (v14 == null) {
            Intrinsics.throwNpe();
        }
        v15 = v14.route();
        Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"result!!.route()");
        v13.connected(v15);
        socket = null;
        var14_19 = this.connectionPool;
        var15_24 = false;
        var16_25 = false;
        synchronized (var14_19) {
            $i$a$-synchronized-ExchangeFinder$findConnection$3 = false;
            this.connectingConnection = null;
            if (this.connectionPool.transmitterAcquirePooledConnection(this.address, this.transmitter, routes, true)) {
                if (result == null) {
                    Intrinsics.throwNpe();
                }
                result.noNewExchanges = true;
                v16 = result;
                if (v16 == null) {
                    Intrinsics.throwNpe();
                }
                socket = v16.socket();
                result = this.transmitter.getConnection();
            } else {
                v17 = result;
                if (v17 == null) {
                    Intrinsics.throwNpe();
                }
                this.connectionPool.put(v17);
                v18 = result;
                if (v18 == null) {
                    Intrinsics.throwNpe();
                }
                this.transmitter.acquireConnectionNoEvents(v18);
            }
            var16_26 = Unit.INSTANCE;
        }
        Util.closeQuietly(socket);
        v19 = result;
        if (v19 == null) {
            Intrinsics.throwNpe();
        }
        this.eventListener.connectionAcquired(this.call, v19);
        v20 = result;
        if (v20 == null) {
            Intrinsics.throwNpe();
        }
        return v20;
    }

    @Nullable
    public final RealConnection connectingConnection() {
        boolean bl = Thread.holdsLock(this.connectionPool);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.connectingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackFailure() {
        boolean bl = !Thread.holdsLock(this.connectionPool);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        RealConnectionPool realConnectionPool = this.connectionPool;
        bl2 = false;
        bl3 = false;
        synchronized (realConnectionPool) {
            boolean bl5 = false;
            this.hasStreamFailure = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStreamFailure() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            boolean bl4 = this.hasStreamFailure;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasRouteToTry() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            if (this.retryCurrentRoute()) return true;
            if (this.routeSelection != null) {
                RouteSelector.Selection selection = this.routeSelection;
                if (selection == null) {
                    Intrinsics.throwNpe();
                }
                if (selection.hasNext()) return true;
            }
            if (!this.routeSelector.hasNext()) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean retryCurrentRoute() {
        if (this.transmitter.getConnection() == null) return false;
        RealConnection realConnection = this.transmitter.getConnection();
        if (realConnection == null) {
            Intrinsics.throwNpe();
        }
        if (realConnection.routeFailureCount != 0) return false;
        RealConnection realConnection2 = this.transmitter.getConnection();
        if (realConnection2 == null) {
            Intrinsics.throwNpe();
        }
        if (!Util.sameConnection(realConnection2.route().address().url(), this.address.url())) return false;
        return true;
    }

    public ExchangeFinder(@NotNull Transmitter transmitter, @NotNull RealConnectionPool connectionPool, @NotNull Address address, @NotNull Call call, @NotNull EventListener eventListener) {
        Intrinsics.checkParameterIsNotNull((Object)transmitter, (String)"transmitter");
        Intrinsics.checkParameterIsNotNull((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)eventListener, (String)"eventListener");
        this.transmitter = transmitter;
        this.connectionPool = connectionPool;
        this.address = address;
        this.call = call;
        this.eventListener = eventListener;
        this.routeSelector = new RouteSelector(this.address, this.connectionPool.getRouteDatabase(), this.call, this.eventListener);
    }
}

