/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.x500.X500Principal;

public final class CertificateAuthorityCouncil {
    private final Map<X500Principal, List<X509Certificate>> subjectToCaCerts = new LinkedHashMap<X500Principal, List<X509Certificate>>();

    public CertificateAuthorityCouncil(X509Certificate ... caCerts) {
        for (X509Certificate caCert : caCerts) {
            X500Principal subject = caCert.getSubjectX500Principal();
            List<X509Certificate> subjectCaCerts = this.subjectToCaCerts.get(subject);
            if (subjectCaCerts == null) {
                subjectCaCerts = new ArrayList<X509Certificate>(1);
                this.subjectToCaCerts.put(subject, subjectCaCerts);
            }
            subjectCaCerts.add(caCert);
        }
    }

    public List<Certificate> normalizeCertificateChain(List<Certificate> chain) throws SSLPeerUnverifiedException {
        X509Certificate toVerify;
        ArrayDeque<Certificate> queue = new ArrayDeque<Certificate>(chain);
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        result.add((Certificate)queue.removeFirst());
        block0: while (true) {
            X509Certificate caCert;
            if ((caCert = this.findByIssuerAndSignature(toVerify = (X509Certificate)result.get(result.size() - 1))) != null && this.verifySignature(toVerify, caCert)) {
                if (result.size() > 1 || !toVerify.equals(caCert)) {
                    result.add(caCert);
                }
                return result;
            }
            Iterator i = queue.iterator();
            while (i.hasNext()) {
                X509Certificate signingCert = (X509Certificate)i.next();
                if (!toVerify.getIssuerDN().equals(signingCert.getSubjectDN()) || !this.verifySignature(toVerify, signingCert)) continue;
                i.remove();
                result.add(signingCert);
                continue block0;
            }
            break;
        }
        throw new SSLPeerUnverifiedException("Failed to find a cert that signed " + toVerify);
    }

    private boolean verifySignature(X509Certificate toVerify, X509Certificate signingCert) {
        try {
            toVerify.verify(signingCert.getPublicKey());
            return true;
        }
        catch (GeneralSecurityException verifyFailed) {
            return false;
        }
    }

    private X509Certificate findByIssuerAndSignature(X509Certificate cert) {
        X500Principal issuer = cert.getIssuerX500Principal();
        List<X509Certificate> subjectCaCerts = this.subjectToCaCerts.get(issuer);
        if (subjectCaCerts == null) {
            return null;
        }
        for (X509Certificate caCert : subjectCaCerts) {
            PublicKey publicKey = caCert.getPublicKey();
            try {
                cert.verify(publicKey);
                return caCert;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

