/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.net.ProtocolException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okhttp3.tls.internal.der.Adapters;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AnyValue;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BasicConstraints;
import okhttp3.tls.internal.der.BasicDerAdapter;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.Certificate;
import okhttp3.tls.internal.der.DerAdapter;
import okhttp3.tls.internal.der.DerHeader;
import okhttp3.tls.internal.der.DerReader;
import okhttp3.tls.internal.der.DerWriter;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.PrivateKeyInfo;
import okhttp3.tls.internal.der.SubjectPublicKeyInfo;
import okhttp3.tls.internal.der.TbsCertificate;
import okhttp3.tls.internal.der.Validity;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R,\u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR,\u0010\u001c\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a0\u001d0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u001d0\u001d0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0010R,\u0010&\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\bR\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0010R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0010R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0010R\u001a\u00101\u001a\b\u0012\u0004\u0012\u0002020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0010\u00a8\u00064"}, d2={"Lokhttp3/tls/internal/der/CertificateAdapters;", "", "<init>", "()V", "time", "Lokhttp3/tls/internal/der/DerAdapter;", "", "getTime$okhttp_tls", "()Lokhttp3/tls/internal/der/DerAdapter;", "validity", "Lokhttp3/tls/internal/der/BasicDerAdapter;", "Lokhttp3/tls/internal/der/Validity;", "algorithmParameters", "algorithmIdentifier", "Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "getAlgorithmIdentifier$okhttp_tls", "()Lokhttp3/tls/internal/der/BasicDerAdapter;", "basicConstraints", "Lokhttp3/tls/internal/der/BasicConstraints;", "generalNameDnsName", "", "getGeneralNameDnsName$okhttp_tls", "generalNameIpAddress", "Lokio/ByteString;", "getGeneralNameIpAddress$okhttp_tls", "generalName", "Lkotlin/Pair;", "getGeneralName$okhttp_tls", "subjectAlternativeName", "", "extensionValue", "extension", "Lokhttp3/tls/internal/der/Extension;", "getExtension$okhttp_tls", "attributeTypeAndValue", "Lokhttp3/tls/internal/der/AttributeTypeAndValue;", "rdnSequence", "getRdnSequence$okhttp_tls", "name", "getName$okhttp_tls", "subjectPublicKeyInfo", "Lokhttp3/tls/internal/der/SubjectPublicKeyInfo;", "getSubjectPublicKeyInfo$okhttp_tls", "tbsCertificate", "Lokhttp3/tls/internal/der/TbsCertificate;", "getTbsCertificate$okhttp_tls", "certificate", "Lokhttp3/tls/internal/der/Certificate;", "getCertificate$okhttp_tls", "privateKeyInfo", "Lokhttp3/tls/internal/der/PrivateKeyInfo;", "getPrivateKeyInfo$okhttp_tls", "okhttp-tls"})
public final class CertificateAdapters {
    @NotNull
    public static final CertificateAdapters INSTANCE = new CertificateAdapters();
    @NotNull
    private static final DerAdapter<Long> time = new DerAdapter<Long>(){

        public boolean matches(DerHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            return Adapters.INSTANCE.getUTC_TIME().matches(header) || Adapters.INSTANCE.getGENERALIZED_TIME().matches(header);
        }

        public Long fromDer(DerReader reader) {
            long l;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            DerHeader derHeader = reader.peekHeader();
            if (derHeader == null) {
                throw new ProtocolException("expected time but was exhausted at " + reader);
            }
            DerHeader peekHeader = derHeader;
            if (peekHeader.getTagClass() == Adapters.INSTANCE.getUTC_TIME().getTagClass() && peekHeader.getTag() == Adapters.INSTANCE.getUTC_TIME().getTag()) {
                l = ((Number)Adapters.INSTANCE.getUTC_TIME().fromDer(reader)).longValue();
            } else if (peekHeader.getTagClass() == Adapters.INSTANCE.getGENERALIZED_TIME().getTagClass() && peekHeader.getTag() == Adapters.INSTANCE.getGENERALIZED_TIME().getTag()) {
                l = ((Number)Adapters.INSTANCE.getGENERALIZED_TIME().fromDer(reader)).longValue();
            } else {
                throw new ProtocolException("expected time but was " + peekHeader + " at " + reader);
            }
            return l;
        }

        public void toDer(DerWriter writer, long value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            boolean bl = -631152000000L <= value ? value < 2524608000000L : false;
            if (bl) {
                Adapters.INSTANCE.getUTC_TIME().toDer(writer, value);
            } else {
                Adapters.INSTANCE.getGENERALIZED_TIME().toDer(writer, value);
            }
        }
    };
    @NotNull
    private static final BasicDerAdapter<Validity> validity;
    @NotNull
    private static final DerAdapter<Object> algorithmParameters;
    @NotNull
    private static final BasicDerAdapter<AlgorithmIdentifier> algorithmIdentifier;
    @NotNull
    private static final BasicDerAdapter<BasicConstraints> basicConstraints;
    @NotNull
    private static final BasicDerAdapter<String> generalNameDnsName;
    @NotNull
    private static final BasicDerAdapter<ByteString> generalNameIpAddress;
    @NotNull
    private static final DerAdapter<Pair<DerAdapter<?>, Object>> generalName;
    @NotNull
    private static final BasicDerAdapter<List<Pair<DerAdapter<?>, Object>>> subjectAlternativeName;
    @NotNull
    private static final BasicDerAdapter<Object> extensionValue;
    @NotNull
    private static final BasicDerAdapter<Extension> extension;
    @NotNull
    private static final BasicDerAdapter<AttributeTypeAndValue> attributeTypeAndValue;
    @NotNull
    private static final BasicDerAdapter<List<List<AttributeTypeAndValue>>> rdnSequence;
    @NotNull
    private static final DerAdapter<Pair<DerAdapter<?>, Object>> name;
    @NotNull
    private static final BasicDerAdapter<SubjectPublicKeyInfo> subjectPublicKeyInfo;
    @NotNull
    private static final BasicDerAdapter<TbsCertificate> tbsCertificate;
    @NotNull
    private static final BasicDerAdapter<Certificate> certificate;
    @NotNull
    private static final BasicDerAdapter<PrivateKeyInfo> privateKeyInfo;

    private CertificateAdapters() {
    }

    @NotNull
    public final DerAdapter<Long> getTime$okhttp_tls() {
        return time;
    }

    @NotNull
    public final BasicDerAdapter<AlgorithmIdentifier> getAlgorithmIdentifier$okhttp_tls() {
        return algorithmIdentifier;
    }

    @NotNull
    public final BasicDerAdapter<String> getGeneralNameDnsName$okhttp_tls() {
        return generalNameDnsName;
    }

    @NotNull
    public final BasicDerAdapter<ByteString> getGeneralNameIpAddress$okhttp_tls() {
        return generalNameIpAddress;
    }

    @NotNull
    public final DerAdapter<Pair<DerAdapter<?>, Object>> getGeneralName$okhttp_tls() {
        return generalName;
    }

    @NotNull
    public final BasicDerAdapter<Extension> getExtension$okhttp_tls() {
        return extension;
    }

    @NotNull
    public final BasicDerAdapter<List<List<AttributeTypeAndValue>>> getRdnSequence$okhttp_tls() {
        return rdnSequence;
    }

    @NotNull
    public final DerAdapter<Pair<DerAdapter<?>, Object>> getName$okhttp_tls() {
        return name;
    }

    @NotNull
    public final BasicDerAdapter<SubjectPublicKeyInfo> getSubjectPublicKeyInfo$okhttp_tls() {
        return subjectPublicKeyInfo;
    }

    @NotNull
    public final BasicDerAdapter<TbsCertificate> getTbsCertificate$okhttp_tls() {
        return tbsCertificate;
    }

    @NotNull
    public final BasicDerAdapter<Certificate> getCertificate$okhttp_tls() {
        return certificate;
    }

    @NotNull
    public final BasicDerAdapter<PrivateKeyInfo> getPrivateKeyInfo$okhttp_tls() {
        return privateKeyInfo;
    }

    private static final List validity$lambda$0(Validity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Long[]{it.getNotBefore(), it.getNotAfter()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Validity validity$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Long");
        long l = (Long)e;
        Object e2 = it.get(1);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.Long");
        return new Validity(l, (Long)e2);
    }

    private static final DerAdapter algorithmParameters$lambda$0(Object typeHint) {
        Object object = typeHint;
        return Intrinsics.areEqual((Object)object, (Object)"1.2.840.113549.1.1.11") ? (DerAdapter)Adapters.INSTANCE.getNULL() : (Intrinsics.areEqual((Object)object, (Object)"1.2.840.113549.1.1.1") ? (DerAdapter)Adapters.INSTANCE.getNULL() : (Intrinsics.areEqual((Object)object, (Object)"1.2.840.10045.2.1") ? (DerAdapter)Adapters.INSTANCE.getOBJECT_IDENTIFIER() : null));
    }

    private static final List algorithmIdentifier$lambda$0(AlgorithmIdentifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getAlgorithm(), it.getParameters()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final AlgorithmIdentifier algorithmIdentifier$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
        return new AlgorithmIdentifier((String)e, it.get(1));
    }

    private static final List basicConstraints$lambda$0(BasicConstraints it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getCa(), it.getMaxIntermediateCas()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final BasicConstraints basicConstraints$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return new BasicConstraints((Boolean)e, (Long)it.get(1));
    }

    private static final DerAdapter extensionValue$lambda$0(Object typeHint) {
        Object object = typeHint;
        return Intrinsics.areEqual((Object)object, (Object)"2.5.29.17") ? (DerAdapter)subjectAlternativeName : (Intrinsics.areEqual((Object)object, (Object)"2.5.29.19") ? (DerAdapter)basicConstraints : null);
    }

    private static final List extension$lambda$0(Extension it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getId(), it.getCritical(), it.getValue()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Extension extension$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)e;
        Object e2 = it.get(1);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return new Extension(string, (Boolean)e2, it.get(2));
    }

    private static final List attributeTypeAndValue$lambda$0(AttributeTypeAndValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getType(), it.getValue()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final AttributeTypeAndValue attributeTypeAndValue$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
        return new AttributeTypeAndValue((String)e, it.get(1));
    }

    private static final List subjectPublicKeyInfo$lambda$0(SubjectPublicKeyInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getAlgorithm(), it.getSubjectPublicKey()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final SubjectPublicKeyInfo subjectPublicKeyInfo$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.AlgorithmIdentifier");
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)e;
        Object e2 = it.get(1);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.BitString");
        return new SubjectPublicKeyInfo(algorithmIdentifier, (BitString)e2);
    }

    private static final List tbsCertificate$lambda$0(TbsCertificate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[10];
        objectArray[0] = it.getVersion();
        objectArray[1] = it.getSerialNumber();
        objectArray[2] = it.getSignature();
        objectArray[3] = TuplesKt.to(rdnSequence, it.getIssuer());
        objectArray[4] = it.getValidity();
        objectArray[5] = TuplesKt.to(rdnSequence, it.getSubject());
        objectArray[6] = it.getSubjectPublicKeyInfo();
        objectArray[7] = it.getIssuerUniqueID();
        objectArray[8] = it.getSubjectUniqueID();
        objectArray[9] = it.getExtensions();
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final TbsCertificate tbsCertificate$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Long");
        long l = (Long)e;
        Object e2 = it.get(1);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type java.math.BigInteger");
        BigInteger bigInteger = (BigInteger)e2;
        Object e3 = it.get(2);
        Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.AlgorithmIdentifier");
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)e3;
        Object e4 = it.get(3);
        Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type kotlin.Pair<*, *>");
        Object object = ((Pair)e4).getSecond();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.List<okhttp3.tls.internal.der.AttributeTypeAndValue>>");
        List list = (List)object;
        Object e5 = it.get(4);
        Intrinsics.checkNotNull(e5, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.Validity");
        Validity validity = (Validity)e5;
        Object e6 = it.get(5);
        Intrinsics.checkNotNull(e6, (String)"null cannot be cast to non-null type kotlin.Pair<*, *>");
        Object object2 = ((Pair)e6).getSecond();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.List<okhttp3.tls.internal.der.AttributeTypeAndValue>>");
        List list2 = (List)object2;
        Object e7 = it.get(6);
        Intrinsics.checkNotNull(e7, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.SubjectPublicKeyInfo");
        SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)e7;
        BitString bitString = (BitString)it.get(7);
        BitString bitString2 = (BitString)it.get(8);
        Object e8 = it.get(9);
        Intrinsics.checkNotNull(e8, (String)"null cannot be cast to non-null type kotlin.collections.List<okhttp3.tls.internal.der.Extension>");
        return new TbsCertificate(l, bigInteger, algorithmIdentifier, list, validity, list2, subjectPublicKeyInfo, bitString, bitString2, (List)e8);
    }

    private static final List certificate$lambda$0(Certificate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getTbsCertificate(), it.getSignatureAlgorithm(), it.getSignatureValue()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Certificate certificate$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.TbsCertificate");
        TbsCertificate tbsCertificate = (TbsCertificate)e;
        Object e2 = it.get(1);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.AlgorithmIdentifier");
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)e2;
        Object e3 = it.get(2);
        Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.BitString");
        return new Certificate(tbsCertificate, algorithmIdentifier, (BitString)e3);
    }

    private static final List privateKeyInfo$lambda$0(PrivateKeyInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getVersion(), it.getAlgorithmIdentifier(), it.getPrivateKey()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final PrivateKeyInfo privateKeyInfo$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = it.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Long");
        long l = (Long)e;
        Object e2 = it.get(1);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.AlgorithmIdentifier");
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)e2;
        Object e3 = it.get(2);
        Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type okio.ByteString");
        return new PrivateKeyInfo(l, algorithmIdentifier, (ByteString)e3);
    }

    static {
        DerAdapter[] derAdapterArray = new DerAdapter[2];
        derAdapterArray[0] = time;
        derAdapterArray[1] = time;
        validity = Adapters.INSTANCE.sequence("Validity", derAdapterArray, CertificateAdapters::validity$lambda$0, CertificateAdapters::validity$lambda$1);
        algorithmParameters = Adapters.INSTANCE.usingTypeHint(CertificateAdapters::algorithmParameters$lambda$0);
        derAdapterArray = new DerAdapter[]{Adapters.INSTANCE.getOBJECT_IDENTIFIER().asTypeHint(), algorithmParameters};
        algorithmIdentifier = Adapters.INSTANCE.sequence("AlgorithmIdentifier", derAdapterArray, CertificateAdapters::algorithmIdentifier$lambda$0, CertificateAdapters::algorithmIdentifier$lambda$1);
        derAdapterArray = new DerAdapter[]{Adapters.INSTANCE.getBOOLEAN().optional(false), BasicDerAdapter.optional$default(Adapters.INSTANCE.getINTEGER_AS_LONG(), null, 1, null)};
        basicConstraints = Adapters.INSTANCE.sequence("BasicConstraints", derAdapterArray, CertificateAdapters::basicConstraints$lambda$0, CertificateAdapters::basicConstraints$lambda$1);
        generalNameDnsName = BasicDerAdapter.withTag$default(Adapters.INSTANCE.getIA5_STRING(), 0, 2L, 1, null);
        generalNameIpAddress = BasicDerAdapter.withTag$default(Adapters.INSTANCE.getOCTET_STRING(), 0, 7L, 1, null);
        derAdapterArray = new DerAdapter[3];
        derAdapterArray[0] = generalNameDnsName;
        derAdapterArray[1] = generalNameIpAddress;
        derAdapterArray[2] = Adapters.INSTANCE.getANY_VALUE();
        generalName = Adapters.INSTANCE.choice(derAdapterArray);
        subjectAlternativeName = DerAdapter.asSequenceOf$default(generalName, null, 0, 0L, 7, null);
        extensionValue = Adapters.INSTANCE.usingTypeHint(CertificateAdapters::extensionValue$lambda$0).withExplicitBox(Adapters.INSTANCE.getOCTET_STRING().getTagClass(), Adapters.INSTANCE.getOCTET_STRING().getTag(), false);
        derAdapterArray = new DerAdapter[]{Adapters.INSTANCE.getOBJECT_IDENTIFIER().asTypeHint(), Adapters.INSTANCE.getBOOLEAN().optional(false), extensionValue};
        extension = Adapters.INSTANCE.sequence("Extension", derAdapterArray, CertificateAdapters::extension$lambda$0, CertificateAdapters::extension$lambda$1);
        derAdapterArray = new DerAdapter[2];
        derAdapterArray[0] = Adapters.INSTANCE.getOBJECT_IDENTIFIER();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(String.class), Adapters.INSTANCE.getUTF8_STRING()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), Adapters.INSTANCE.getPRINTABLE_STRING()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(AnyValue.class), Adapters.INSTANCE.getANY_VALUE())};
        derAdapterArray[1] = Adapters.any$default(Adapters.INSTANCE, pairArray, false, null, 6, null);
        attributeTypeAndValue = Adapters.INSTANCE.sequence("AttributeTypeAndValue", derAdapterArray, CertificateAdapters::attributeTypeAndValue$lambda$0, CertificateAdapters::attributeTypeAndValue$lambda$1);
        rdnSequence = DerAdapter.asSequenceOf$default(attributeTypeAndValue.asSetOf(), null, 0, 0L, 7, null);
        derAdapterArray = new DerAdapter[1];
        derAdapterArray[0] = rdnSequence;
        name = Adapters.INSTANCE.choice(derAdapterArray);
        derAdapterArray = new DerAdapter[2];
        derAdapterArray[0] = algorithmIdentifier;
        derAdapterArray[1] = Adapters.INSTANCE.getBIT_STRING();
        subjectPublicKeyInfo = Adapters.INSTANCE.sequence("SubjectPublicKeyInfo", derAdapterArray, CertificateAdapters::subjectPublicKeyInfo$lambda$0, CertificateAdapters::subjectPublicKeyInfo$lambda$1);
        derAdapterArray = new DerAdapter[10];
        derAdapterArray[0] = DerAdapter.withExplicitBox$default(Adapters.INSTANCE.getINTEGER_AS_LONG(), 0, 0L, null, 5, null).optional(0L);
        derAdapterArray[1] = Adapters.INSTANCE.getINTEGER_AS_BIG_INTEGER();
        derAdapterArray[2] = algorithmIdentifier;
        derAdapterArray[3] = name;
        derAdapterArray[4] = validity;
        derAdapterArray[5] = name;
        derAdapterArray[6] = subjectPublicKeyInfo;
        derAdapterArray[7] = BasicDerAdapter.optional$default(BasicDerAdapter.withTag$default(Adapters.INSTANCE.getBIT_STRING(), 0, 1L, 1, null), null, 1, null);
        derAdapterArray[8] = BasicDerAdapter.optional$default(BasicDerAdapter.withTag$default(Adapters.INSTANCE.getBIT_STRING(), 0, 2L, 1, null), null, 1, null);
        derAdapterArray[9] = DerAdapter.withExplicitBox$default(DerAdapter.asSequenceOf$default(extension, null, 0, 0L, 7, null), 0, 3L, null, 5, null).optional(CollectionsKt.emptyList());
        tbsCertificate = Adapters.INSTANCE.sequence("TBSCertificate", derAdapterArray, CertificateAdapters::tbsCertificate$lambda$0, CertificateAdapters::tbsCertificate$lambda$1);
        derAdapterArray = new DerAdapter[3];
        derAdapterArray[0] = tbsCertificate;
        derAdapterArray[1] = algorithmIdentifier;
        derAdapterArray[2] = Adapters.INSTANCE.getBIT_STRING();
        certificate = Adapters.INSTANCE.sequence("Certificate", derAdapterArray, CertificateAdapters::certificate$lambda$0, CertificateAdapters::certificate$lambda$1);
        derAdapterArray = new DerAdapter[3];
        derAdapterArray[0] = Adapters.INSTANCE.getINTEGER_AS_LONG();
        derAdapterArray[1] = algorithmIdentifier;
        derAdapterArray[2] = Adapters.INSTANCE.getOCTET_STRING();
        privateKeyInfo = Adapters.INSTANCE.sequence("PrivateKeyInfo", derAdapterArray, CertificateAdapters::privateKeyInfo$lambda$0, CertificateAdapters::privateKeyInfo$lambda$1);
    }
}

