/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.net.ProtocolException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import okhttp3.tls.internal.der.Adapters;
import okhttp3.tls.internal.der.AnyValue;
import okhttp3.tls.internal.der.BasicDerAdapter;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.DerAdapter;
import okhttp3.tls.internal.der.DerHeader;
import okhttp3.tls.internal.der.DerReader;
import okhttp3.tls.internal.der.DerWriter;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b(J\u0015\u00100\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b3Jk\u00104\u001a\b\u0012\u0004\u0012\u0002H50\u0005\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\u00192\u001a\u00107\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030,08\"\u0006\u0012\u0002\b\u00030,2\u0016\u00109\u001a\u0012\u0012\u0004\u0012\u0002H5\u0012\b\u0012\u0006\u0012\u0002\b\u00030;0:2\u0016\u0010<\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030;\u0012\u0004\u0012\u0002H50:\u00a2\u0006\u0002\u0010=J?\u0010>\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030,\u0012\u0006\u0012\u0004\u0018\u00010\u00010?0,2\u001a\u0010@\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030,08\"\u0006\u0012\u0002\b\u00030,\u00a2\u0006\u0002\u0010AJ*\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010,2\u001a\u0010C\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010,0:Jg\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010,2<\b\u0002\u0010@\u001a\u001e\u0012\u001a\b\u0001\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030E\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0?08\"\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030E\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0?2\b\b\u0002\u0010G\u001a\u00020\u00062\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010IR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\bR\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\bR\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R2\u0010D\u001a&\u0012\"\u0012 \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010E\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010,0?0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lokhttp3/tls/internal/der/Adapters;", "", "<init>", "()V", "BOOLEAN", "Lokhttp3/tls/internal/der/BasicDerAdapter;", "", "getBOOLEAN", "()Lokhttp3/tls/internal/der/BasicDerAdapter;", "INTEGER_AS_LONG", "", "getINTEGER_AS_LONG", "INTEGER_AS_BIG_INTEGER", "Ljava/math/BigInteger;", "getINTEGER_AS_BIG_INTEGER", "BIT_STRING", "Lokhttp3/tls/internal/der/BitString;", "getBIT_STRING", "OCTET_STRING", "Lokio/ByteString;", "getOCTET_STRING", "NULL", "", "getNULL", "OBJECT_IDENTIFIER", "", "getOBJECT_IDENTIFIER", "UTF8_STRING", "getUTF8_STRING", "PRINTABLE_STRING", "getPRINTABLE_STRING", "IA5_STRING", "getIA5_STRING", "UTC_TIME", "getUTC_TIME", "parseUtcTime", "string", "parseUtcTime$okhttp_tls", "formatUtcTime", "date", "formatUtcTime$okhttp_tls", "GENERALIZED_TIME", "getGENERALIZED_TIME", "ANY_VALUE", "Lokhttp3/tls/internal/der/DerAdapter;", "Lokhttp3/tls/internal/der/AnyValue;", "getANY_VALUE", "()Lokhttp3/tls/internal/der/DerAdapter;", "parseGeneralizedTime", "parseGeneralizedTime$okhttp_tls", "formatGeneralizedTime", "formatGeneralizedTime$okhttp_tls", "sequence", "T", "name", "members", "", "decompose", "Lkotlin/Function1;", "", "construct", "(Ljava/lang/String;[Lokhttp3/tls/internal/der/DerAdapter;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lokhttp3/tls/internal/der/BasicDerAdapter;", "choice", "Lkotlin/Pair;", "choices", "([Lokhttp3/tls/internal/der/DerAdapter;)Lokhttp3/tls/internal/der/DerAdapter;", "usingTypeHint", "chooser", "defaultAnyChoices", "Lkotlin/reflect/KClass;", "any", "isOptional", "optionalValue", "([Lkotlin/Pair;ZLjava/lang/Object;)Lokhttp3/tls/internal/der/DerAdapter;", "okhttp-tls"})
@SourceDebugExtension(value={"SMAP\nAdapters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Adapters.kt\nokhttp3/tls/internal/der/Adapters\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,530:1\n37#2:531\n36#2,3:532\n*S KotlinDebug\n*F\n+ 1 Adapters.kt\nokhttp3/tls/internal/der/Adapters\n*L\n486#1:531\n486#1:532,3\n*E\n"})
public final class Adapters {
    @NotNull
    public static final Adapters INSTANCE = new Adapters();
    @NotNull
    private static final BasicDerAdapter<Boolean> BOOLEAN = new BasicDerAdapter("BOOLEAN", 0, 1L, new BasicDerAdapter.Codec<Boolean>(){

        public Boolean decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readBoolean();
        }

        public void encode(DerWriter writer, boolean value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.writeBoolean(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Long> INTEGER_AS_LONG = new BasicDerAdapter("INTEGER", 0, 2L, new BasicDerAdapter.Codec<Long>(){

        public Long decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readLong();
        }

        public void encode(DerWriter writer, long value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.writeLong(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<BigInteger> INTEGER_AS_BIG_INTEGER = new BasicDerAdapter("INTEGER", 0, 2L, new BasicDerAdapter.Codec<BigInteger>(){

        public BigInteger decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readBigInteger();
        }

        public void encode(DerWriter writer, BigInteger value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.writeBigInteger(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<BitString> BIT_STRING = new BasicDerAdapter("BIT STRING", 0, 3L, new BasicDerAdapter.Codec<BitString>(){

        public BitString decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readBitString();
        }

        public void encode(DerWriter writer, BitString value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.writeBitString(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<ByteString> OCTET_STRING = new BasicDerAdapter("OCTET STRING", 0, 4L, new BasicDerAdapter.Codec<ByteString>(){

        public ByteString decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readOctetString();
        }

        public void encode(DerWriter writer, ByteString value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.writeOctetString(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Unit> NULL = new BasicDerAdapter("NULL", 0, 5L, new BasicDerAdapter.Codec<Unit>(){

        public Unit decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return null;
        }

        public void encode(DerWriter writer, Unit value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> OBJECT_IDENTIFIER = new BasicDerAdapter("OBJECT IDENTIFIER", 0, 6L, new BasicDerAdapter.Codec<String>(){

        public String decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readObjectIdentifier();
        }

        public void encode(DerWriter writer, String value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.writeObjectIdentifier(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> UTF8_STRING = new BasicDerAdapter("UTF8", 0, 12L, new BasicDerAdapter.Codec<String>(){

        public String decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readUtf8String();
        }

        public void encode(DerWriter writer, String value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.writeUtf8(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> PRINTABLE_STRING = new BasicDerAdapter("PRINTABLE STRING", 0, 19L, new BasicDerAdapter.Codec<String>(){

        public String decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readUtf8String();
        }

        public void encode(DerWriter writer, String value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.writeUtf8(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> IA5_STRING = new BasicDerAdapter("IA5 STRING", 0, 22L, new BasicDerAdapter.Codec<String>(){

        public String decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return reader.readUtf8String();
        }

        public void encode(DerWriter writer, String value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.writeUtf8(value);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Long> UTC_TIME = new BasicDerAdapter("UTC TIME", 0, 23L, new BasicDerAdapter.Codec<Long>(){

        public Long decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            String string = reader.readUtf8String();
            return Adapters.INSTANCE.parseUtcTime$okhttp_tls(string);
        }

        public void encode(DerWriter writer, long value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            String string = Adapters.INSTANCE.formatUtcTime$okhttp_tls(value);
            writer.writeUtf8(string);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Long> GENERALIZED_TIME = new BasicDerAdapter("GENERALIZED TIME", 0, 24L, new BasicDerAdapter.Codec<Long>(){

        public Long decode(DerReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            String string = reader.readUtf8String();
            return Adapters.INSTANCE.parseGeneralizedTime$okhttp_tls(string);
        }

        public void encode(DerWriter writer, long value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            String string = Adapters.INSTANCE.formatGeneralizedTime$okhttp_tls(value);
            writer.writeUtf8(string);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final DerAdapter<AnyValue> ANY_VALUE = new DerAdapter<AnyValue>(){

        public boolean matches(DerHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public AnyValue fromDer(DerReader reader) {
            long newLimit$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            DerReader derReader = reader;
            String name$iv = "ANY";
            boolean $i$f$read$okhttp_tls = false;
            if (!this_$iv.hasNext()) {
                throw new ProtocolException("expected a value");
            }
            DerHeader derHeader = DerReader.access$getPeekedHeader$p((DerReader)this_$iv);
            Intrinsics.checkNotNull((Object)derHeader);
            DerHeader header$iv = derHeader;
            DerReader.access$setPeekedHeader$p((DerReader)this_$iv, null);
            long pushedLimit$iv = DerReader.access$getLimit$p((DerReader)this_$iv);
            boolean pushedConstructed$iv = DerReader.access$getConstructed$p((DerReader)this_$iv);
            long l = newLimit$iv = header$iv.getLength() != -1L ? DerReader.access$getByteCount((DerReader)this_$iv) + header$iv.getLength() : -1L;
            if (pushedLimit$iv != -1L && newLimit$iv > pushedLimit$iv) {
                throw new ProtocolException("enclosed object too large");
            }
            DerReader.access$setLimit$p((DerReader)this_$iv, newLimit$iv);
            DerReader.access$setConstructed$p((DerReader)this_$iv, header$iv.getConstructed());
            ((Collection)DerReader.access$getPath$p((DerReader)this_$iv)).add(name$iv);
            try {
                DerHeader header = header$iv;
                boolean bl = false;
                ByteString bytes = reader.readUnknown();
                AnyValue anyValue = new AnyValue(header.getTagClass(), header.getTag(), header.getConstructed(), header.getLength(), bytes);
                return anyValue;
            }
            finally {
                DerReader.access$setPeekedHeader$p((DerReader)this_$iv, null);
                DerReader.access$setLimit$p((DerReader)this_$iv, pushedLimit$iv);
                DerReader.access$setConstructed$p((DerReader)this_$iv, pushedConstructed$iv);
                DerReader.access$getPath$p((DerReader)this_$iv).remove(DerReader.access$getPath$p((DerReader)this_$iv).size() - 1);
            }
        }

        public void toDer(DerWriter writer, AnyValue value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            writer.write("ANY", value.getTagClass(), value.getTag(), (Function1<? super BufferedSink, Unit>)((Function1)arg_0 -> ANY_VALUE.1.toDer$lambda$1(writer, value, arg_0)));
        }

        private static final Unit toDer$lambda$1(DerWriter $writer, AnyValue $value, BufferedSink it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $writer.writeOctetString($value.getBytes());
            $writer.setConstructed($value.getConstructed());
            return Unit.INSTANCE;
        }
    };
    @NotNull
    private static final List<Pair<KClass<? extends Object>, DerAdapter<? extends Object>>> defaultAnyChoices;

    private Adapters() {
    }

    @NotNull
    public final BasicDerAdapter<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public final BasicDerAdapter<Long> getINTEGER_AS_LONG() {
        return INTEGER_AS_LONG;
    }

    @NotNull
    public final BasicDerAdapter<BigInteger> getINTEGER_AS_BIG_INTEGER() {
        return INTEGER_AS_BIG_INTEGER;
    }

    @NotNull
    public final BasicDerAdapter<BitString> getBIT_STRING() {
        return BIT_STRING;
    }

    @NotNull
    public final BasicDerAdapter<ByteString> getOCTET_STRING() {
        return OCTET_STRING;
    }

    @NotNull
    public final BasicDerAdapter<Unit> getNULL() {
        return NULL;
    }

    @NotNull
    public final BasicDerAdapter<String> getOBJECT_IDENTIFIER() {
        return OBJECT_IDENTIFIER;
    }

    @NotNull
    public final BasicDerAdapter<String> getUTF8_STRING() {
        return UTF8_STRING;
    }

    @NotNull
    public final BasicDerAdapter<String> getPRINTABLE_STRING() {
        return PRINTABLE_STRING;
    }

    @NotNull
    public final BasicDerAdapter<String> getIA5_STRING() {
        return IA5_STRING;
    }

    @NotNull
    public final BasicDerAdapter<Long> getUTC_TIME() {
        return UTC_TIME;
    }

    public final long parseUtcTime$okhttp_tls(@NotNull String string) {
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$parseUtcTime_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        boolean bl = false;
        $this$parseUtcTime_u24lambda_u240.setTimeZone(utc);
        $this$parseUtcTime_u24lambda_u240.set2DigitYearStart(new Date(-631152000000L));
        SimpleDateFormat dateFormat = simpleDateFormat;
        try {
            Date parsed = dateFormat.parse(string);
            return parsed.getTime();
        }
        catch (ParseException e) {
            throw new ProtocolException("Failed to parse UTCTime " + string);
        }
    }

    @NotNull
    public final String formatUtcTime$okhttp_tls(long date) {
        SimpleDateFormat simpleDateFormat;
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$formatUtcTime_u24lambda_u241 = simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        boolean bl = false;
        $this$formatUtcTime_u24lambda_u241.setTimeZone(utc);
        $this$formatUtcTime_u24lambda_u241.set2DigitYearStart(new Date(-631152000000L));
        SimpleDateFormat dateFormat = simpleDateFormat;
        String string = dateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final BasicDerAdapter<Long> getGENERALIZED_TIME() {
        return GENERALIZED_TIME;
    }

    @NotNull
    public final DerAdapter<AnyValue> getANY_VALUE() {
        return ANY_VALUE;
    }

    public final long parseGeneralizedTime$okhttp_tls(@NotNull String string) {
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$parseGeneralizedTime_u24lambda_u242 = simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        boolean bl = false;
        $this$parseGeneralizedTime_u24lambda_u242.setTimeZone(utc);
        SimpleDateFormat dateFormat = simpleDateFormat;
        try {
            Date parsed = dateFormat.parse(string);
            return parsed.getTime();
        }
        catch (ParseException e) {
            throw new ProtocolException("Failed to parse GeneralizedTime " + string);
        }
    }

    @NotNull
    public final String formatGeneralizedTime$okhttp_tls(long date) {
        SimpleDateFormat simpleDateFormat;
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$formatGeneralizedTime_u24lambda_u243 = simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        boolean bl = false;
        $this$formatGeneralizedTime_u24lambda_u243.setTimeZone(utc);
        SimpleDateFormat dateFormat = simpleDateFormat;
        String string = dateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final <T> BasicDerAdapter<T> sequence(@NotNull String name, @NotNull DerAdapter<?>[] members, @NotNull Function1<? super T, ? extends List<?>> decompose, @NotNull Function1<? super List<?>, ? extends T> construct) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter(decompose, (String)"decompose");
        Intrinsics.checkNotNullParameter(construct, (String)"construct");
        BasicDerAdapter.Codec codec2 = new BasicDerAdapter.Codec<T>(members, construct, decompose){
            final /* synthetic */ DerAdapter<?>[] $members;
            final /* synthetic */ Function1<List<?>, T> $construct;
            final /* synthetic */ Function1<T, List<?>> $decompose;
            {
                this.$members = $members;
                this.$construct = $construct;
                this.$decompose = $decompose;
            }

            public T decode(DerReader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                return reader.withTypeHint(() -> sequence.codec.1.decode$lambda$0(this.$members, reader, this.$construct));
            }

            public void encode(DerWriter writer, T value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                List list = (List)this.$decompose.invoke(value);
                writer.withTypeHint(() -> sequence.codec.1.encode$lambda$1(list, this.$members, writer));
            }

            private static final Object decode$lambda$0(DerAdapter[] $members, DerReader $reader, Function1 $construct) {
                List list = new ArrayList<E>();
                while (list.size() < $members.length) {
                    DerAdapter member = $members[list.size()];
                    ((Collection)list).add(member.fromDer($reader));
                }
                if ($reader.hasNext()) {
                    throw new ProtocolException("unexpected " + $reader.peekHeader() + " at " + $reader);
                }
                return $construct.invoke((Object)list);
            }

            private static final Unit encode$lambda$1(List $list, DerAdapter[] $members, DerWriter $writer) {
                int n = ((Collection)$list).size();
                for (int i = 0; i < n; ++i) {
                    DerAdapter adapter;
                    Intrinsics.checkNotNull((Object)$members[i], (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.DerAdapter<kotlin.Any?>");
                    adapter.toDer($writer, $list.get(i));
                }
                return Unit.INSTANCE;
            }
        };
        return new BasicDerAdapter(name, 0, 16L, codec2, false, null, false, 112, null);
    }

    @NotNull
    public final DerAdapter<Pair<DerAdapter<?>, Object>> choice(DerAdapter<?> ... choices) {
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        return new DerAdapter<Pair<? extends DerAdapter<?>, ? extends Object>>(choices){
            final /* synthetic */ DerAdapter<?>[] $choices;
            {
                this.$choices = $choices;
            }

            public boolean matches(DerHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return true;
            }

            public Pair<DerAdapter<?>, Object> fromDer(DerReader reader) {
                DerAdapter<?> derAdapter;
                DerHeader peekedHeader;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                    DerHeader derHeader = reader.peekHeader();
                    if (derHeader == null) {
                        throw new ProtocolException("expected a value at " + reader);
                    }
                    peekedHeader = derHeader;
                    DerAdapter<?>[] $this$firstOrNull$iv = this.$choices;
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        DerAdapter<?> element$iv;
                        DerAdapter<?> it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!it.matches(peekedHeader)) continue;
                        derAdapter = element$iv;
                        break block3;
                    }
                    derAdapter = null;
                }
                if (derAdapter == null) {
                    throw new ProtocolException("expected a matching choice but was " + peekedHeader + " at " + reader);
                }
                DerAdapter<?> choice2 = derAdapter;
                return TuplesKt.to((Object)choice2, choice2.fromDer(reader));
            }

            public void toDer(DerWriter writer, Pair<? extends DerAdapter<?>, ? extends Object> value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter(value, (String)"value");
                DerAdapter adapter = (DerAdapter)value.component1();
                Object v = value.component2();
                Intrinsics.checkNotNull((Object)adapter, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.DerAdapter<kotlin.Any?>");
                adapter.toDer(writer, v);
            }

            public String toString() {
                return ArraysKt.joinToString$default((Object[])this.$choices, (CharSequence)" OR ", null, null, (int)0, null, null, (int)62, null);
            }
        };
    }

    @NotNull
    public final DerAdapter<Object> usingTypeHint(@NotNull Function1<Object, ? extends DerAdapter<?>> chooser) {
        Intrinsics.checkNotNullParameter(chooser, (String)"chooser");
        return new DerAdapter<Object>(chooser){
            final /* synthetic */ Function1<Object, DerAdapter<?>> $chooser;
            {
                this.$chooser = $chooser;
            }

            public boolean matches(DerHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return true;
            }

            public void toDer(DerWriter writer, Object value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                DerAdapter adapter = (DerAdapter)this.$chooser.invoke(writer.getTypeHint());
                DerAdapter derAdapter = adapter;
                if (derAdapter != null) {
                    derAdapter.toDer(writer, value);
                } else {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type okio.ByteString");
                    writer.writeOctetString((ByteString)value);
                }
            }

            public Object fromDer(DerReader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                DerAdapter adapter = (DerAdapter)this.$chooser.invoke(reader.getTypeHint());
                DerAdapter derAdapter = adapter;
                return derAdapter != null ? derAdapter.fromDer(reader) : reader.readUnknown();
            }
        };
    }

    @NotNull
    public final DerAdapter<Object> any(@NotNull Pair<? extends KClass<?>, ? extends DerAdapter<?>>[] choices, boolean isOptional, @Nullable Object optionalValue) {
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        return new DerAdapter<Object>(isOptional, optionalValue, choices){
            final /* synthetic */ boolean $isOptional;
            final /* synthetic */ Object $optionalValue;
            final /* synthetic */ Pair<KClass<?>, DerAdapter<?>>[] $choices;
            {
                this.$isOptional = $isOptional;
                this.$optionalValue = $optionalValue;
                this.$choices = $choices;
            }

            public boolean matches(DerHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return true;
            }

            public void toDer(DerWriter writer, Object value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                if (!this.$isOptional || !Intrinsics.areEqual((Object)value, (Object)this.$optionalValue)) {
                    for (Pair<KClass<?>, DerAdapter<?>> pair : this.$choices) {
                        KClass type = (KClass)pair.component1();
                        DerAdapter adapter = (DerAdapter)pair.component2();
                        if (!type.isInstance(value) && (value != null || !Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Unit.class)))) continue;
                        Intrinsics.checkNotNull((Object)adapter, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.DerAdapter<kotlin.Any?>");
                        adapter.toDer(writer, value);
                        return;
                    }
                }
            }

            public Object fromDer(DerReader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                if (this.$isOptional && !reader.hasNext()) {
                    return this.$optionalValue;
                }
                DerHeader derHeader = reader.peekHeader();
                if (derHeader == null) {
                    throw new ProtocolException("expected a value at " + reader);
                }
                DerHeader peekedHeader = derHeader;
                Pair<KClass<?>, DerAdapter<?>>[] pairArray = this.$choices;
                int n = pairArray.length;
                for (int i = 0; i < n; ++i) {
                    DerAdapter adapter = (DerAdapter)pairArray[i].component2();
                    if (!adapter.matches(peekedHeader)) continue;
                    return adapter.fromDer(reader);
                }
                throw new ProtocolException("expected any but was " + peekedHeader + " at " + reader);
            }
        };
    }

    public static /* synthetic */ DerAdapter any$default(Adapters adapters, Pair[] pairArray, boolean bl, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            Collection $this$toTypedArray$iv = defaultAnyChoices;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            pairArray = thisCollection$iv.toArray(new Pair[0]);
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            object = null;
        }
        return adapters.any(pairArray, bl, object);
    }

    static {
        Object[] objectArray = new Pair[12];
        objectArray[0] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), BOOLEAN);
        objectArray[1] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BigInteger.class), INTEGER_AS_BIG_INTEGER);
        objectArray[2] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BitString.class), BIT_STRING);
        objectArray[3] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ByteString.class), OCTET_STRING);
        objectArray[4] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Unit.class), NULL);
        objectArray[5] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), OBJECT_IDENTIFIER);
        objectArray[6] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), UTF8_STRING);
        objectArray[7] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(String.class), PRINTABLE_STRING);
        objectArray[8] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), IA5_STRING);
        objectArray[9] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), UTC_TIME);
        objectArray[10] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), GENERALIZED_TIME);
        objectArray[11] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(AnyValue.class), ANY_VALUE);
        defaultAnyChoices = CollectionsKt.listOf((Object[])objectArray);
    }
}

