/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.InsecureAndroidTrustManager;
import okhttp3.tls.internal.InsecureExtendedTrustManager;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J.\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0007J5\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u001b\"\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lokhttp3/tls/internal/TlsUtil;", "", "<init>", "()V", "password", "", "getPassword", "()[C", "localhost", "Lokhttp3/tls/HandshakeCertificates;", "getLocalhost", "()Lokhttp3/tls/HandshakeCertificates;", "localhost$delegate", "Lkotlin/Lazy;", "newTrustManager", "Ljavax/net/ssl/X509TrustManager;", "keyStoreType", "", "trustedCertificates", "", "Ljava/security/cert/X509Certificate;", "insecureHosts", "newKeyManager", "Ljavax/net/ssl/X509KeyManager;", "heldCertificate", "Lokhttp3/tls/HeldCertificate;", "intermediates", "", "(Ljava/lang/String;Lokhttp3/tls/HeldCertificate;[Ljava/security/cert/X509Certificate;)Ljavax/net/ssl/X509KeyManager;", "newEmptyKeyStore", "Ljava/security/KeyStore;", "okhttp-tls"})
public final class TlsUtil {
    @NotNull
    public static final TlsUtil INSTANCE = new TlsUtil();
    @NotNull
    private static final char[] password;
    @NotNull
    private static final Lazy localhost$delegate;

    private TlsUtil() {
    }

    @NotNull
    public final char[] getPassword() {
        return password;
    }

    private final HandshakeCertificates getLocalhost() {
        Lazy lazy = localhost$delegate;
        return (HandshakeCertificates)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final HandshakeCertificates localhost() {
        return INSTANCE.getLocalhost();
    }

    @JvmStatic
    @IgnoreJRERequirement
    @NotNull
    public static final X509TrustManager newTrustManager(@Nullable String keyStoreType, @NotNull List<? extends X509Certificate> trustedCertificates, @NotNull List<String> insecureHosts) {
        Intrinsics.checkNotNullParameter(trustedCertificates, (String)"trustedCertificates");
        Intrinsics.checkNotNullParameter(insecureHosts, (String)"insecureHosts");
        KeyStore trustStore = INSTANCE.newEmptyKeyStore(keyStoreType);
        int n = ((Collection)trustedCertificates).size();
        for (int i = 0; i < n; ++i) {
            trustStore.setCertificateEntry("cert_" + i, trustedCertificates.get(i));
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(trustStore);
        Object[] objectArray = factory.getTrustManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] result = objectArray;
        if (!(result.length == 1 && result[0] instanceof X509TrustManager)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected trust managers: ");
            String string = Arrays.toString(result);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalStateException(string2.toString());
        }
        TrustManager trustManager = result[0];
        Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        X509TrustManager trustManager2 = (X509TrustManager)trustManager;
        return insecureHosts.isEmpty() ? trustManager2 : (Platform.Companion.isAndroid() ? (X509TrustManager)new InsecureAndroidTrustManager(trustManager2, insecureHosts) : (X509TrustManager)new InsecureExtendedTrustManager((X509ExtendedTrustManager)trustManager2, insecureHosts));
    }

    @JvmStatic
    @NotNull
    public static final X509KeyManager newKeyManager(@Nullable String keyStoreType, @Nullable HeldCertificate heldCertificate, X509Certificate ... intermediates) {
        boolean isBouncyCastle;
        Intrinsics.checkNotNullParameter((Object)intermediates, (String)"intermediates");
        KeyStore keyStore = INSTANCE.newEmptyKeyStore(keyStoreType);
        if (heldCertificate != null) {
            Object[] chain = new Certificate[1 + intermediates.length];
            chain[0] = heldCertificate.certificate();
            ArraysKt.copyInto$default((Object[])intermediates, (Object[])chain, (int)1, (int)0, (int)0, (int)12, null);
            keyStore.setKeyEntry("private", heldCertificate.keyPair().getPrivate(), password, (Certificate[])chain);
        }
        String algorithm = (isBouncyCastle = Intrinsics.areEqual((Object)keyStore.getProvider().getName(), (Object)"BC")) ? "PKIX" : KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(keyStore, password);
        Object[] objectArray = factory.getKeyManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] result = objectArray;
        if (!(result.length == 1 && result[0] instanceof X509KeyManager)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected key managers:");
            String string = Arrays.toString(result);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalStateException(string2.toString());
        }
        KeyManager keyManager = result[0];
        Intrinsics.checkNotNull((Object)keyManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509KeyManager");
        return (X509KeyManager)keyManager;
    }

    private final KeyStore newEmptyKeyStore(String keyStoreType) {
        KeyStore keyStore;
        String string = keyStoreType;
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        KeyStore $this$newEmptyKeyStore_u24lambda_u243 = keyStore = KeyStore.getInstance(string);
        boolean bl = false;
        InputStream inputStream = null;
        $this$newEmptyKeyStore_u24lambda_u243.load(inputStream, password);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"apply(...)");
        return keyStore2;
    }

    private static final HandshakeCertificates localhost_delegate$lambda$0() {
        HeldCertificate heldCertificate = new HeldCertificate.Builder().commonName("localhost").addSubjectAlternativeName("localhost").addSubjectAlternativeName("localhost.localdomain").build();
        return new HandshakeCertificates.Builder().heldCertificate(heldCertificate, new X509Certificate[0]).addTrustedCertificate(heldCertificate.certificate()).build();
    }

    static {
        char[] cArray = "password".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        password = cArray;
        localhost$delegate = LazyKt.lazy(TlsUtil::localhost_delegate$lambda$0);
    }
}

