/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.math.BigInteger;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import okhttp3.internal.Util;
import okhttp3.tls.Certificates;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BasicConstraints;
import okhttp3.tls.internal.der.BasicDerAdapter;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.Certificate;
import okhttp3.tls.internal.der.CertificateAdapters;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.PrivateKeyInfo;
import okhttp3.tls.internal.der.SubjectPublicKeyInfo;
import okhttp3.tls.internal.der.TbsCertificate;
import okhttp3.tls.internal.der.Validity;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\u000bJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\u0013"}, d2={"Lokhttp3/tls/HeldCertificate;", "", "keyPair", "Ljava/security/KeyPair;", "certificate", "Ljava/security/cert/X509Certificate;", "(Ljava/security/KeyPair;Ljava/security/cert/X509Certificate;)V", "()Ljava/security/cert/X509Certificate;", "()Ljava/security/KeyPair;", "-deprecated_certificate", "certificatePem", "", "-deprecated_keyPair", "pkcs1Bytes", "Lokio/ByteString;", "privateKeyPkcs1Pem", "privateKeyPkcs8Pem", "Builder", "Companion", "okhttp-tls"})
public final class HeldCertificate {
    @NotNull
    private final KeyPair keyPair;
    @NotNull
    private final X509Certificate certificate;
    private static final Regex PEM_REGEX;
    public static final Companion Companion;

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="certificate"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_certificate")
    @NotNull
    public final X509Certificate -deprecated_certificate() {
        return this.certificate;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="keyPair"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_keyPair")
    @NotNull
    public final KeyPair -deprecated_keyPair() {
        return this.keyPair;
    }

    @NotNull
    public final String certificatePem() {
        return Certificates.certificatePem(this.certificate);
    }

    @NotNull
    public final String privateKeyPkcs8Pem() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append("-----BEGIN PRIVATE KEY-----\n");
        PrivateKey privateKey = this.keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyPair.private");
        byte[] byArray = privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.private.encoded");
        Certificates.encodeBase64Lines($this$buildString, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$buildString.append("-----END PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String privateKeyPkcs1Pem() {
        boolean bl = this.keyPair.getPrivate() instanceof RSAPrivateKey;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "PKCS1 only supports RSA keys";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = false;
        bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        bl3 = false;
        boolean bl5 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl6 = false;
        $this$buildString.append("-----BEGIN RSA PRIVATE KEY-----\n");
        Certificates.encodeBase64Lines($this$buildString, this.pkcs1Bytes());
        $this$buildString.append("-----END RSA PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final ByteString pkcs1Bytes() {
        BasicDerAdapter<PrivateKeyInfo> basicDerAdapter = CertificateAdapters.INSTANCE.getPrivateKeyInfo$okhttp_tls();
        PrivateKey privateKey = this.keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyPair.private");
        byte[] byArray = privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.private.encoded");
        PrivateKeyInfo decoded = basicDerAdapter.fromDer(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        return decoded.getPrivateKey();
    }

    @JvmName(name="keyPair")
    @NotNull
    public final KeyPair keyPair() {
        return this.keyPair;
    }

    @JvmName(name="certificate")
    @NotNull
    public final X509Certificate certificate() {
        return this.certificate;
    }

    public HeldCertificate(@NotNull KeyPair keyPair, @NotNull X509Certificate certificate2) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
        this.keyPair = keyPair;
        this.certificate = certificate2;
    }

    static {
        Companion = new Companion(null);
        PEM_REGEX = new Regex("-----BEGIN ([!-,.-~ ]*)-----([^-]*)-----END \\1-----");
    }

    @JvmStatic
    @NotNull
    public static final HeldCertificate decode(@NotNull String certificateAndPrivateKeyPem) {
        return Companion.decode(certificateAndPrivateKeyPem);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0004H\u0002J\b\u0010 \u001a\u00020\tH\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0014\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0+0+H\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lokhttp3/tls/HeldCertificate$Builder;", "", "()V", "altNames", "", "", "commonName", "keyAlgorithm", "keyPair", "Ljava/security/KeyPair;", "keySize", "", "maxIntermediateCas", "notAfter", "", "notBefore", "organizationalUnit", "serialNumber", "Ljava/math/BigInteger;", "signedBy", "Lokhttp3/tls/HeldCertificate;", "addSubjectAlternativeName", "altName", "build", "certificateAuthority", "cn", "duration", "unit", "Ljava/util/concurrent/TimeUnit;", "ecdsa256", "extensions", "Lokhttp3/tls/internal/der/Extension;", "generateKeyPair", "publicKey", "Ljava/security/PublicKey;", "privateKey", "Ljava/security/PrivateKey;", "ou", "rsa2048", "signatureAlgorithm", "Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "signedByKeyPair", "subject", "", "Lokhttp3/tls/internal/der/AttributeTypeAndValue;", "validity", "Lokhttp3/tls/internal/der/Validity;", "validityInterval", "Companion", "okhttp-tls"})
    public static final class Builder {
        private long notBefore = -1L;
        private long notAfter = -1L;
        private String commonName;
        private String organizationalUnit;
        private final List<String> altNames;
        private BigInteger serialNumber;
        private KeyPair keyPair;
        private HeldCertificate signedBy;
        private int maxIntermediateCas;
        private String keyAlgorithm;
        private int keySize;
        private static final long DEFAULT_DURATION_MILLIS = 86400000L;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Builder validityInterval(long notBefore, long notAfter) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = notBefore <= notAfter && notBefore == -1L == (notAfter == -1L);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "invalid interval: " + notBefore + ".." + notAfter;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.notBefore = notBefore;
            $this$apply.notAfter = notAfter;
            return builder;
        }

        @NotNull
        public final Builder duration(long duration, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            long now = System.currentTimeMillis();
            $this$apply.validityInterval(now, now + unit.toMillis(duration));
            return builder;
        }

        @NotNull
        public final Builder addSubjectAlternativeName(@NotNull String altName) {
            Intrinsics.checkNotNullParameter((Object)altName, (String)"altName");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Collection collection = $this$apply.altNames;
            String string = altName;
            boolean bl4 = false;
            collection.add(string);
            return builder;
        }

        @NotNull
        public final Builder commonName(@NotNull String cn) {
            Intrinsics.checkNotNullParameter((Object)cn, (String)"cn");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.commonName = cn;
            return builder;
        }

        @NotNull
        public final Builder organizationalUnit(@NotNull String ou) {
            Intrinsics.checkNotNullParameter((Object)ou, (String)"ou");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.organizationalUnit = ou;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(@NotNull BigInteger serialNumber) {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.serialNumber = serialNumber;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(long serialNumber) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            BigInteger bigInteger = BigInteger.valueOf(serialNumber);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(serialNumber)");
            $this$apply.serialNumber(bigInteger);
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull KeyPair keyPair) {
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyPair = keyPair;
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull PublicKey publicKey, @NotNull PrivateKey privateKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyPair(new KeyPair(publicKey, privateKey));
            return builder;
        }

        @NotNull
        public final Builder signedBy(@Nullable HeldCertificate signedBy) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.signedBy = signedBy;
            return builder;
        }

        @NotNull
        public final Builder certificateAuthority(int maxIntermediateCas) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = maxIntermediateCas >= 0;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "maxIntermediateCas < 0: " + maxIntermediateCas;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.maxIntermediateCas = maxIntermediateCas;
            return builder;
        }

        @NotNull
        public final Builder ecdsa256() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyAlgorithm = "EC";
            $this$apply.keySize = 256;
            return builder;
        }

        @NotNull
        public final Builder rsa2048() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyAlgorithm = "RSA";
            $this$apply.keySize = 2048;
            return builder;
        }

        @NotNull
        public final HeldCertificate build() {
            KeyPair keyPair = this.keyPair;
            if (keyPair == null) {
                keyPair = this.generateKeyPair();
            }
            KeyPair subjectKeyPair = keyPair;
            BasicDerAdapter<SubjectPublicKeyInfo> basicDerAdapter = CertificateAdapters.INSTANCE.getSubjectPublicKeyInfo$okhttp_tls();
            PublicKey publicKey = subjectKeyPair.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"subjectKeyPair.public");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"subjectKeyPair.public.encoded");
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = basicDerAdapter.fromDer(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
            List<List<AttributeTypeAndValue>> subject = this.subject();
            KeyPair issuerKeyPair = null;
            List<List<AttributeTypeAndValue>> issuer = null;
            if (this.signedBy != null) {
                HeldCertificate heldCertificate = this.signedBy;
                Intrinsics.checkNotNull((Object)heldCertificate);
                issuerKeyPair = heldCertificate.keyPair();
                BasicDerAdapter<List<List<AttributeTypeAndValue>>> basicDerAdapter2 = CertificateAdapters.INSTANCE.getRdnSequence$okhttp_tls();
                HeldCertificate heldCertificate2 = this.signedBy;
                Intrinsics.checkNotNull((Object)heldCertificate2);
                X500Principal x500Principal = heldCertificate2.certificate().getSubjectX500Principal();
                Intrinsics.checkNotNullExpressionValue((Object)x500Principal, (String)"signedBy!!.certificate.subjectX500Principal");
                byte[] byArray2 = x500Principal.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"signedBy!!.certificate.s\u2026jectX500Principal.encoded");
                issuer = basicDerAdapter2.fromDer(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray2, (int)0, (int)0, (int)3, null));
            } else {
                issuerKeyPair = subjectKeyPair;
                issuer = subject;
            }
            AlgorithmIdentifier signatureAlgorithm = this.signatureAlgorithm(issuerKeyPair);
            BigInteger bigInteger = this.serialNumber;
            if (bigInteger == null) {
                bigInteger = BigInteger.ONE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"serialNumber ?: BigInteger.ONE");
            TbsCertificate tbsCertificate2 = new TbsCertificate(2L, bigInteger, signatureAlgorithm, issuer, this.validity(), subject, subjectPublicKeyInfo2, null, null, this.extensions());
            Signature signature = Signature.getInstance(tbsCertificate2.getSignatureAlgorithmName());
            boolean bl = false;
            boolean bl2 = false;
            Signature $this$run = signature;
            boolean bl3 = false;
            $this$run.initSign(issuerKeyPair.getPrivate());
            $this$run.update(CertificateAdapters.INSTANCE.getTbsCertificate$okhttp_tls().toDer(tbsCertificate2).toByteArray());
            byte[] byArray3 = $this$run.sign();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"sign()");
            ByteString signature2 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray3, (int)0, (int)0, (int)3, null);
            Certificate certificate2 = new Certificate(tbsCertificate2, signatureAlgorithm, new BitString(signature2, 0));
            return new HeldCertificate(subjectKeyPair, certificate2.toX509Certificate());
        }

        private final List<List<AttributeTypeAndValue>> subject() {
            boolean bl;
            List list;
            boolean bl2 = false;
            List result = new ArrayList();
            if (this.organizationalUnit != null) {
                Collection collection = result;
                list = CollectionsKt.listOf((Object)new AttributeTypeAndValue("2.5.4.11", this.organizationalUnit));
                bl = false;
                collection.add(list);
            }
            Collection collection = result;
            String string = this.commonName;
            if (string == null) {
                String string2 = UUID.randomUUID().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
            }
            list = CollectionsKt.listOf((Object)new AttributeTypeAndValue("2.5.4.3", string));
            bl = false;
            collection.add(list);
            return result;
        }

        private final Validity validity() {
            long notBefore = this.notBefore != -1L ? this.notBefore : System.currentTimeMillis();
            long notAfter = this.notAfter != -1L ? this.notAfter : notBefore + 86400000L;
            return new Validity(notBefore, notAfter);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Extension> extensions() {
            boolean bl = false;
            List result = new ArrayList();
            if (this.maxIntermediateCas != -1) {
                Collection collection = result;
                Extension extension2 = new Extension("2.5.29.19", true, new BasicConstraints(true, Long.valueOf(this.maxIntermediateCas)));
                boolean bl2 = false;
                collection.add(extension2);
            }
            Collection collection = this.altNames;
            boolean bl3 = false;
            if (!collection.isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.altNames;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair;
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    if (Util.canParseAsIpAddress((String)it)) {
                        BasicDerAdapter<ByteString> basicDerAdapter = CertificateAdapters.INSTANCE.getGeneralNameIpAddress$okhttp_tls();
                        InetAddress inetAddress = InetAddress.getByName((String)it);
                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getByName(it)");
                        byte[] byArray = inetAddress.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"InetAddress.getByName(it).address");
                        pair = TuplesKt.to(basicDerAdapter, (Object)ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
                    } else {
                        pair = TuplesKt.to(CertificateAdapters.INSTANCE.getGeneralNameDnsName$okhttp_tls(), (Object)it);
                    }
                    Pair pair2 = pair;
                    collection2.add(pair2);
                }
                List extensionValue2 = (List)destination$iv$iv;
                Collection collection3 = result;
                Extension extension3 = new Extension("2.5.29.17", true, extensionValue2);
                boolean bl5 = false;
                collection3.add(extension3);
            }
            return result;
        }

        private final AlgorithmIdentifier signatureAlgorithm(KeyPair signedByKeyPair) {
            PrivateKey privateKey = signedByKeyPair.getPrivate();
            return privateKey instanceof RSAPrivateKey ? new AlgorithmIdentifier("1.2.840.113549.1.1.11", null) : new AlgorithmIdentifier("1.2.840.10045.4.3.2", ByteString.EMPTY);
        }

        private final KeyPair generateKeyPair() {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlgorithm);
            boolean bl = false;
            boolean bl2 = false;
            KeyPairGenerator $this$run = keyPairGenerator;
            boolean bl3 = false;
            $this$run.initialize(this.keySize, new SecureRandom());
            KeyPair keyPair = $this$run.generateKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"KeyPairGenerator.getInst\u2026generateKeyPair()\n      }");
            return keyPair;
        }

        public Builder() {
            boolean bl = false;
            this.altNames = new ArrayList();
            this.maxIntermediateCas = -1;
            this.ecdsa256();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/tls/HeldCertificate$Builder$Companion;", "", "()V", "DEFAULT_DURATION_MILLIS", "", "okhttp-tls"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/tls/HeldCertificate$Companion;", "", "()V", "PEM_REGEX", "Lkotlin/text/Regex;", "decode", "Lokhttp3/tls/HeldCertificate;", "certificateAndPrivateKeyPem", "", "certificatePem", "pkcs8Base64Text", "decodePkcs8", "Ljava/security/PrivateKey;", "data", "Lokio/ByteString;", "keyAlgorithm", "okhttp-tls"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HeldCertificate decode(@NotNull String certificateAndPrivateKeyPem) {
            Intrinsics.checkNotNullParameter((Object)certificateAndPrivateKeyPem, (String)"certificateAndPrivateKeyPem");
            String certificatePem = null;
            String pkcs8Base64 = null;
            block8: for (MatchResult match : Regex.findAll$default((Regex)PEM_REGEX, (CharSequence)certificateAndPrivateKeyPem, (int)0, (int)2, null)) {
                void label;
                String string;
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                switch (string = matchGroup.getValue()) {
                    case "CERTIFICATE": {
                        boolean bl = certificatePem == null;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (!bl) {
                            boolean bl4 = false;
                            String string2 = "string includes multiple certificates";
                            throw (Throwable)new IllegalArgumentException(string2.toString());
                        }
                        MatchGroup matchGroup2 = match.getGroups().get(0);
                        Intrinsics.checkNotNull((Object)matchGroup2);
                        certificatePem = matchGroup2.getValue();
                        continue block8;
                    }
                    case "PRIVATE KEY": {
                        boolean bl = pkcs8Base64 == null;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (!bl) {
                            boolean bl5 = false;
                            String string3 = "string includes multiple private keys";
                            throw (Throwable)new IllegalArgumentException(string3.toString());
                        }
                        MatchGroup matchGroup3 = match.getGroups().get(2);
                        Intrinsics.checkNotNull((Object)matchGroup3);
                        pkcs8Base64 = matchGroup3.getValue();
                        continue block8;
                    }
                }
                throw (Throwable)new IllegalArgumentException("unexpected type: " + (String)label);
            }
            boolean bl = certificatePem != null;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "string does not include a certificate";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = pkcs8Base64 != null;
            bl6 = false;
            bl7 = false;
            if (!bl) {
                boolean bl9 = false;
                String string = "string does not include a private key";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.decode(certificatePem, pkcs8Base64);
        }

        private final HeldCertificate decode(String certificatePem, String pkcs8Base64Text) {
            String string;
            X509Certificate certificate2 = Certificates.decodeCertificatePem(certificatePem);
            ByteString byteString = ByteString.Companion.decodeBase64(pkcs8Base64Text);
            if (byteString == null) {
                throw (Throwable)new IllegalArgumentException("failed to decode private key");
            }
            ByteString pkcs8Bytes = byteString;
            PublicKey publicKey = certificate2.getPublicKey();
            if (publicKey instanceof ECPublicKey) {
                string = "EC";
            } else if (publicKey instanceof RSAPublicKey) {
                string = "RSA";
            } else {
                throw (Throwable)new IllegalArgumentException("unexpected key type: " + certificate2.getPublicKey());
            }
            String keyType = string;
            PrivateKey privateKey = this.decodePkcs8(pkcs8Bytes, keyType);
            KeyPair keyPair = new KeyPair(certificate2.getPublicKey(), privateKey);
            return new HeldCertificate(keyPair, certificate2);
        }

        private final PrivateKey decodePkcs8(ByteString data, String keyAlgorithm) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
                PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(data.toByteArray()));
                Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyFactory.generatePriva\u2026Spec(data.toByteArray()))");
                return privateKey;
            }
            catch (GeneralSecurityException e) {
                throw (Throwable)new IllegalArgumentException("failed to decode private key", e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

