/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.content.Context;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.ContextAwarePlatform;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/platform/PlatformRegistry;", "", "<init>", "()V", "findPlatform", "Lokhttp3/internal/platform/Platform;", "isAndroid", "", "()Z", "value", "Landroid/content/Context;", "applicationContext", "getApplicationContext", "()Landroid/content/Context;", "setApplicationContext", "(Landroid/content/Context;)V", "okhttp_release"})
public final class PlatformRegistry {
    @NotNull
    public static final PlatformRegistry INSTANCE = new PlatformRegistry();

    private PlatformRegistry() {
    }

    @NotNull
    public final Platform findPlatform() {
        AndroidLog.INSTANCE.enable();
        Platform platform = Android10Platform.Companion.buildIfSupported();
        if (platform == null) {
            Platform platform2 = AndroidPlatform.Companion.buildIfSupported();
            platform = platform2;
            Intrinsics.checkNotNull((Object)platform2);
        }
        return platform;
    }

    public final boolean isAndroid() {
        return true;
    }

    @Nullable
    public final Context getApplicationContext() {
        Platform platform = Platform.Companion.get();
        ContextAwarePlatform contextAwarePlatform = platform instanceof ContextAwarePlatform ? (ContextAwarePlatform)((Object)platform) : null;
        return contextAwarePlatform != null ? contextAwarePlatform.getApplicationContext() : null;
    }

    public final void setApplicationContext(@Nullable Context value) {
        block0: {
            Platform platform = Platform.Companion.get();
            ContextAwarePlatform contextAwarePlatform = platform instanceof ContextAwarePlatform ? (ContextAwarePlatform)((Object)platform) : null;
            if (contextAwarePlatform == null) break block0;
            contextAwarePlatform.setApplicationContext(value);
        }
    }
}

