/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3.internal.duplex;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mockwebserver3.Stream;
import mockwebserver3.StreamHandler;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u001a\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007J\u0006\u0010\u0017\u001a\u00020\u0000J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0006\u0010 \u001a\u00020\bR$\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lmockwebserver3/internal/duplex/MockStreamHandler;", "Lmockwebserver3/StreamHandler;", "<init>", "()V", "actions", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function1;", "Lmockwebserver3/Stream;", "", "Lmockwebserver3/internal/duplex/Action;", "results", "Ljava/util/concurrent/FutureTask;", "Ljava/lang/Void;", "receiveRequest", "expected", "", "exhaustRequest", "cancelStream", "requestIOException", "sendResponse", "s", "responseSent", "Ljava/util/concurrent/CountDownLatch;", "exhaustResponse", "sleep", "duration", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handle", "stream", "serviceStreamTask", "awaitSuccess", "mockwebserver3"})
public final class MockStreamHandler
implements StreamHandler {
    @NotNull
    private final LinkedBlockingQueue<Function1<Stream, Unit>> actions = new LinkedBlockingQueue();
    @NotNull
    private final LinkedBlockingQueue<FutureTask<Void>> results = new LinkedBlockingQueue();

    @NotNull
    public final MockStreamHandler receiveRequest(@NotNull String expected) {
        MockStreamHandler mockStreamHandler;
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        MockStreamHandler $this$receiveRequest_u24lambda_u241 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$receiveRequest_u24lambda_u241.actions).add(arg_0 -> MockStreamHandler.receiveRequest$lambda$1$lambda$0(expected, arg_0));
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler exhaustRequest() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$exhaustRequest_u24lambda_u243 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$exhaustRequest_u24lambda_u243.actions).add(MockStreamHandler::exhaustRequest$lambda$3$lambda$2);
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler cancelStream() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$cancelStream_u24lambda_u245 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$cancelStream_u24lambda_u245.actions).add(MockStreamHandler::cancelStream$lambda$5$lambda$4);
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler requestIOException() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$requestIOException_u24lambda_u247 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$requestIOException_u24lambda_u247.actions).add(MockStreamHandler::requestIOException$lambda$7$lambda$6);
        return mockStreamHandler;
    }

    @JvmOverloads
    @NotNull
    public final MockStreamHandler sendResponse(@NotNull String s, @NotNull CountDownLatch responseSent) {
        MockStreamHandler mockStreamHandler;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)responseSent, (String)"responseSent");
        MockStreamHandler $this$sendResponse_u24lambda_u249 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$sendResponse_u24lambda_u249.actions).add(arg_0 -> MockStreamHandler.sendResponse$lambda$9$lambda$8(s, responseSent, arg_0));
        return mockStreamHandler;
    }

    public static /* synthetic */ MockStreamHandler sendResponse$default(MockStreamHandler mockStreamHandler, String string, CountDownLatch countDownLatch, int n, Object object) {
        if ((n & 2) != 0) {
            countDownLatch = new CountDownLatch(0);
        }
        return mockStreamHandler.sendResponse(string, countDownLatch);
    }

    @NotNull
    public final MockStreamHandler exhaustResponse() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$exhaustResponse_u24lambda_u2411 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$exhaustResponse_u24lambda_u2411.actions).add(MockStreamHandler::exhaustResponse$lambda$11$lambda$10);
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler sleep(long duration, @NotNull TimeUnit unit) {
        MockStreamHandler mockStreamHandler;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockStreamHandler $this$sleep_u24lambda_u2413 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$sleep_u24lambda_u2413.actions).add(arg_0 -> MockStreamHandler.sleep$lambda$13$lambda$12(unit, duration, arg_0));
        return mockStreamHandler;
    }

    @Override
    public void handle(@NotNull Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        FutureTask<Void> task = this.serviceStreamTask(stream);
        this.results.add(task);
        task.run();
    }

    private final FutureTask<Void> serviceStreamTask(Stream stream) {
        return new FutureTask<Void>(() -> MockStreamHandler.serviceStreamTask$lambda$16(stream, this));
    }

    public final void awaitSuccess() {
        FutureTask<Void> futureTask = this.results.poll(5L, TimeUnit.SECONDS);
        if (futureTask == null) {
            throw new AssertionError((Object)"no onRequest call received");
        }
        FutureTask<Void> futureTask2 = futureTask;
        futureTask2.get(5L, TimeUnit.SECONDS);
    }

    @JvmOverloads
    @NotNull
    public final MockStreamHandler sendResponse(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return MockStreamHandler.sendResponse$default(this, s, null, 2, null);
    }

    private static final Unit receiveRequest$lambda$1$lambda$0(String $expected, Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        String actual = stream.getRequestBody().readUtf8(Utf8.size$default((String)$expected, (int)0, (int)0, (int)3, null));
        if (!Intrinsics.areEqual((Object)actual, (Object)$expected)) {
            throw new AssertionError((Object)(actual + " != " + $expected));
        }
        return Unit.INSTANCE;
    }

    private static final Unit exhaustRequest$lambda$3$lambda$2(Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        if (!stream.getRequestBody().exhausted()) {
            throw new AssertionError((Object)"expected exhausted");
        }
        return Unit.INSTANCE;
    }

    private static final Unit cancelStream$lambda$5$lambda$4(Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.cancel();
        return Unit.INSTANCE;
    }

    private static final Unit requestIOException$lambda$7$lambda$6(Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try {
            stream.getRequestBody().exhausted();
            throw new AssertionError((Object)"expected IOException");
        }
        catch (IOException iOException) {
            return Unit.INSTANCE;
        }
    }

    private static final Unit sendResponse$lambda$9$lambda$8(String $s, CountDownLatch $responseSent, Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.getResponseBody().writeUtf8($s);
        stream.getResponseBody().flush();
        $responseSent.countDown();
        return Unit.INSTANCE;
    }

    private static final Unit exhaustResponse$lambda$11$lambda$10(Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.getResponseBody().close();
        return Unit.INSTANCE;
    }

    private static final Unit sleep$lambda$13$lambda$12(TimeUnit $unit, long $duration, Stream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Thread.sleep($unit.toMillis($duration));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void serviceStreamTask$lambda$16(Stream $stream, MockStreamHandler this$0) {
        Closeable closeable = (Closeable)$stream.getRequestBody();
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)$stream.getResponseBody();
            Throwable throwable2 = null;
            try {
                BufferedSink it2 = (BufferedSink)closeable2;
                boolean bl2 = false;
                while (this$0.actions.poll() != null) {
                    Function1<Stream, Unit> action;
                    action.invoke((Object)$stream);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return null;
    }
}

