/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.TlsVersion;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001Bo\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016BQ\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0019J\u0010\u00106\u001a\u0004\u0018\u00010\u00032\u0006\u00107\u001a\u00020\u0003J\b\u00108\u001a\u00020\u0003H\u0007J\b\u00109\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0013\u0010.\u001a\u0004\u0018\u00010/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u00038GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b3\u00104\u001a\u0004\b5\u0010'\u00a8\u0006:"}, d2={"Lokhttp3/mockwebserver/RecordedRequest;", "", "requestLine", "", "headers", "Lokhttp3/Headers;", "chunkSizes", "", "", "bodySize", "", "body", "Lokio/Buffer;", "sequenceNumber", "failure", "Ljava/io/IOException;", "method", "path", "handshake", "Lokhttp3/Handshake;", "requestUrl", "Lokhttp3/HttpUrl;", "(Ljava/lang/String;Lokhttp3/Headers;Ljava/util/List;JLokio/Buffer;ILjava/io/IOException;Ljava/lang/String;Ljava/lang/String;Lokhttp3/Handshake;Lokhttp3/HttpUrl;)V", "socket", "Ljava/net/Socket;", "(Ljava/lang/String;Lokhttp3/Headers;Ljava/util/List;JLokio/Buffer;ILjava/net/Socket;Ljava/io/IOException;)V", "getBody", "()Lokio/Buffer;", "getBodySize", "()J", "getChunkSizes", "()Ljava/util/List;", "getFailure", "()Ljava/io/IOException;", "getHandshake", "()Lokhttp3/Handshake;", "getHeaders", "()Lokhttp3/Headers;", "getMethod", "()Ljava/lang/String;", "getPath", "getRequestLine", "getRequestUrl", "()Lokhttp3/HttpUrl;", "getSequenceNumber", "()I", "tlsVersion", "Lokhttp3/TlsVersion;", "getTlsVersion", "()Lokhttp3/TlsVersion;", "utf8Body", "-deprecated_utf8Body$annotations", "()V", "-deprecated_utf8Body", "getHeader", "name", "getUtf8Body", "toString", "mockwebserver-deprecated"})
public final class RecordedRequest {
    @NotNull
    private final String requestLine;
    @NotNull
    private final Headers headers;
    @NotNull
    private final List<Integer> chunkSizes;
    private final long bodySize;
    @NotNull
    private final Buffer body;
    private final int sequenceNumber;
    @Nullable
    private final IOException failure;
    @Nullable
    private final String method;
    @Nullable
    private final String path;
    @Nullable
    private final Handshake handshake;
    @Nullable
    private final HttpUrl requestUrl;

    @NotNull
    public final String getRequestLine() {
        return this.requestLine;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final List<Integer> getChunkSizes() {
        return this.chunkSizes;
    }

    public final long getBodySize() {
        return this.bodySize;
    }

    @NotNull
    public final Buffer getBody() {
        return this.body;
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Nullable
    public final IOException getFailure() {
        return this.failure;
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final Handshake getHandshake() {
        return this.handshake;
    }

    @Nullable
    public final HttpUrl getRequestUrl() {
        return this.requestUrl;
    }

    @Deprecated(message="Use body.readUtf8()", replaceWith=@ReplaceWith(imports={}, expression="body.readUtf8()"), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void -deprecated_utf8Body$annotations() {
    }

    @JvmName(name="-deprecated_utf8Body")
    @NotNull
    public final String -deprecated_utf8Body() {
        return this.body.readUtf8();
    }

    @Nullable
    public final TlsVersion getTlsVersion() {
        Handshake handshake = this.handshake;
        return handshake != null ? handshake.tlsVersion() : null;
    }

    @Deprecated(message="Use body.readUtf8()", replaceWith=@ReplaceWith(imports={}, expression="body.readUtf8()"), level=DeprecationLevel.WARNING)
    @NotNull
    public final String getUtf8Body() {
        return this.body.readUtf8();
    }

    @Nullable
    public final String getHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (String)CollectionsKt.firstOrNull((List)this.headers.values(name));
    }

    @NotNull
    public String toString() {
        return this.requestLine;
    }

    public RecordedRequest(@NotNull String requestLine, @NotNull Headers headers, @NotNull List<Integer> chunkSizes, long bodySize, @NotNull Buffer body, int sequenceNumber, @Nullable IOException failure, @Nullable String method, @Nullable String path, @Nullable Handshake handshake, @Nullable HttpUrl requestUrl) {
        Intrinsics.checkNotNullParameter((Object)requestLine, (String)"requestLine");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(chunkSizes, (String)"chunkSizes");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.requestLine = requestLine;
        this.headers = headers;
        this.chunkSizes = chunkSizes;
        this.bodySize = bodySize;
        this.body = body;
        this.sequenceNumber = sequenceNumber;
        this.failure = failure;
        this.method = method;
        this.path = path;
        this.handshake = handshake;
        this.requestUrl = requestUrl;
    }

    @JvmOverloads
    public RecordedRequest(@NotNull String requestLine, @NotNull Headers headers, @NotNull List<Integer> chunkSizes, long bodySize, @NotNull Buffer body, int sequenceNumber, @NotNull Socket socket, @Nullable IOException failure) {
        Intrinsics.checkNotNullParameter((Object)requestLine, (String)"requestLine");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(chunkSizes, (String)"chunkSizes");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.requestLine = requestLine;
        this.headers = headers;
        this.chunkSizes = chunkSizes;
        this.bodySize = bodySize;
        this.body = body;
        this.sequenceNumber = sequenceNumber;
        this.failure = failure;
        if (socket instanceof SSLSocket) {
            try {
                SSLSession sSLSession = ((SSLSocket)socket).getSession();
                Intrinsics.checkNotNullExpressionValue((Object)sSLSession, (String)"socket.session");
                this.handshake = Handshake.Companion.get(sSLSession);
            }
            catch (IOException e) {
                throw (Throwable)new IllegalArgumentException(e);
            }
        } else {
            this.handshake = null;
        }
        CharSequence e = requestLine;
        boolean bl = false;
        if (e.length() > 0) {
            InetAddress inetAddress;
            int methodEnd = StringsKt.indexOf$default((CharSequence)requestLine, (char)' ', (int)0, (boolean)false, (int)6, null);
            int pathEnd = StringsKt.indexOf$default((CharSequence)requestLine, (char)' ', (int)(methodEnd + 1), (boolean)false, (int)4, null);
            String string = requestLine;
            int n = 0;
            int n2 = 0;
            String string2 = string.substring(n, methodEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.method = string2;
            String string3 = requestLine;
            n2 = methodEnd + 1;
            boolean bl2 = false;
            String string4 = string3.substring(n2, pathEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String path = string4;
            if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                path = "/";
            }
            this.path = path;
            String scheme = socket instanceof SSLSocket ? "https" : "http";
            InetAddress inetAddress2 = inetAddress = socket.getLocalAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"inetAddress");
            String hostname = inetAddress2.getHostName();
            if (inetAddress instanceof Inet6Address) {
                String string5 = hostname;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"hostname");
                if (StringsKt.contains$default((CharSequence)string5, (char)':', (boolean)false, (int)2, null)) {
                    hostname = '[' + hostname + ']';
                }
            }
            int localPort = socket.getLocalPort();
            this.requestUrl = HttpUrl.Companion.parse(scheme + "://" + hostname + ':' + localPort + path);
        } else {
            this.requestUrl = null;
            this.method = null;
            this.path = null;
        }
    }

    public /* synthetic */ RecordedRequest(String string, Headers headers, List list, long l, Buffer buffer, int n, Socket socket, IOException iOException, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x80) != 0) {
            iOException = null;
        }
        this(string, headers, list, l, buffer, n, socket, iOException);
    }

    @JvmOverloads
    public RecordedRequest(@NotNull String requestLine, @NotNull Headers headers, @NotNull List<Integer> chunkSizes, long bodySize, @NotNull Buffer body, int sequenceNumber, @NotNull Socket socket) {
        this(requestLine, headers, chunkSizes, bodySize, body, sequenceNumber, socket, null, 128, null);
    }
}

