//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)/[protocols](protocols.md)

# protocols

[jvm]\
fun [protocols](protocols.md)(protocols: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt;): [OkHttpClient.Builder](index.md)

Configure the protocols used by this client to communicate with remote servers. By default this client will prefer the most efficient transport available, falling back to more ubiquitous protocols. Applications should only call this method to avoid specific compatibility problems, such as web servers that behave incorrectly when HTTP/2 is enabled.

The following protocols are currently supported:

- 
   [http/1.1](http://www.w3.org/Protocols/rfc2616/rfc2616.html)
- 
   [h2](https://tools.ietf.org/html/rfc7540)
- 
   [h2 with prior knowledge(cleartext only)](https://tools.ietf.org/html/rfc7540#section-3.4)

**This is an evolving set.** Future releases include support for transitional protocols. The http/1.1 transport will never be dropped.

If multiple protocols are specified, [ALPN](http://tools.ietf.org/html/draft-ietf-tls-applayerprotoneg) will be used to negotiate a transport. Protocol negotiation is only attempted for HTTPS URLs.

Protocol.HTTP_1_0 is not supported in this set. Requests are initiated with HTTP/1.1. If the server responds with HTTP/1.0, that will be exposed by [Response.protocol](../../-response/protocol.md).

## Parameters

jvm

| | |
|---|---|
| protocols | the protocols to use, in order of preference. If the list contains     Protocol.H2_PRIOR_KNOWLEDGE then that must be the only protocol and HTTPS URLs will not     be supported. Otherwise the list must contain Protocol.HTTP_1_1. The list must     not contain null or Protocol.HTTP_1_0. |
