//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[queryParameterValues](query-parameter-values.md)

# queryParameterValues

[jvm]\
fun [queryParameterValues](query-parameter-values.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?&gt;

Returns all values for the query parameter name ordered by their appearance in this URL. For example this returns [&quot;banana&quot;] for queryParameterValue(&quot;b&quot;) on http://host/?a=apple&amp;b=banana.

| URL | queryParameterValues(&quot;a&quot;) | queryParameterValues(&quot;b&quot;) |
|---|---|---|
| http://host/ | [] | [] |
| http://host/? | [] | [] |
| http://host/?a=apple&amp;k=key+lime | [&quot;apple&quot;] | [] |
| http://host/?a=apple&amp;a=apricot | [&quot;apple&quot;, &quot;apricot&quot;] | [] |
| http://host/?a=apple&amp;b | [&quot;apple&quot;] | [null] |
