/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;

public final class PolymorphicJsonAdapterFactory<T>
implements JsonAdapter.Factory {
    final Class<T> baseType;
    final String labelKey;
    final List<String> labels;
    final List<Type> subtypes;

    PolymorphicJsonAdapterFactory(Class<T> baseType, String labelKey, List<String> labels, List<Type> subtypes) {
        this.baseType = baseType;
        this.labelKey = labelKey;
        this.labels = labels;
        this.subtypes = subtypes;
    }

    @CheckReturnValue
    public static <T> PolymorphicJsonAdapterFactory<T> of(Class<T> baseType, String labelKey) {
        if (baseType == null) {
            throw new NullPointerException("baseType == null");
        }
        if (labelKey == null) {
            throw new NullPointerException("labelKey == null");
        }
        if (baseType == Object.class) {
            throw new IllegalArgumentException("The base type must not be Object. Consider using a marker interface.");
        }
        return new PolymorphicJsonAdapterFactory<T>(baseType, labelKey, Collections.emptyList(), Collections.emptyList());
    }

    public PolymorphicJsonAdapterFactory<T> withSubtype(Class<? extends T> subtype, String label) {
        if (subtype == null) {
            throw new NullPointerException("subtype == null");
        }
        if (label == null) {
            throw new NullPointerException("label == null");
        }
        if (this.labels.contains(label) || this.subtypes.contains(subtype)) {
            throw new IllegalArgumentException("Subtypes and labels must be unique.");
        }
        ArrayList<String> newLabels = new ArrayList<String>(this.labels);
        newLabels.add(label);
        ArrayList<Type> newSubtypes = new ArrayList<Type>(this.subtypes);
        newSubtypes.add(subtype);
        return new PolymorphicJsonAdapterFactory<T>(this.baseType, this.labelKey, newLabels, newSubtypes);
    }

    public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        if (Types.getRawType((Type)type) != this.baseType || !annotations.isEmpty()) {
            return null;
        }
        ArrayList<JsonAdapter<Object>> jsonAdapters = new ArrayList<JsonAdapter<Object>>(this.subtypes.size());
        int size = this.subtypes.size();
        for (int i = 0; i < size; ++i) {
            jsonAdapters.add(moshi.adapter(this.subtypes.get(i)));
        }
        JsonAdapter objectJsonAdapter = moshi.adapter(Object.class);
        return new PolymorphicJsonAdapter(this.labelKey, this.labels, this.subtypes, jsonAdapters, (JsonAdapter<Object>)objectJsonAdapter).nullSafe();
    }

    static final class PolymorphicJsonAdapter
    extends JsonAdapter<Object> {
        final String labelKey;
        final List<String> labels;
        final List<Type> subtypes;
        final List<JsonAdapter<Object>> jsonAdapters;
        final JsonAdapter<Object> objectJsonAdapter;
        final JsonReader.Options labelKeyOptions;
        final JsonReader.Options labelOptions;

        PolymorphicJsonAdapter(String labelKey, List<String> labels, List<Type> subtypes, List<JsonAdapter<Object>> jsonAdapters, JsonAdapter<Object> objectJsonAdapter) {
            this.labelKey = labelKey;
            this.labels = labels;
            this.subtypes = subtypes;
            this.jsonAdapters = jsonAdapters;
            this.objectJsonAdapter = objectJsonAdapter;
            this.labelKeyOptions = JsonReader.Options.of((String[])new String[]{labelKey});
            this.labelOptions = JsonReader.Options.of((String[])labels.toArray(new String[0]));
        }

        public Object fromJson(JsonReader reader) throws IOException {
            int labelIndex = this.labelIndex(reader.peekJson());
            return this.jsonAdapters.get(labelIndex).fromJson(reader);
        }

        private int labelIndex(JsonReader reader) throws IOException {
            reader.beginObject();
            while (reader.hasNext()) {
                if (reader.selectName(this.labelKeyOptions) == -1) {
                    reader.skipName();
                    reader.skipValue();
                    continue;
                }
                int labelIndex = reader.selectString(this.labelOptions);
                if (labelIndex == -1) {
                    throw new JsonDataException("Expected one of " + this.labels + " for key '" + this.labelKey + "' but found '" + reader.nextString() + "'. Register a subtype for this label.");
                }
                reader.close();
                return labelIndex;
            }
            throw new JsonDataException("Missing label for " + this.labelKey);
        }

        public void toJson(JsonWriter writer, Object value) throws IOException {
            Class<?> type = value.getClass();
            int labelIndex = this.subtypes.indexOf(type);
            if (labelIndex == -1) {
                throw new IllegalArgumentException("Expected one of " + this.subtypes + " but found " + value + ", a " + value.getClass() + ". Register this subtype.");
            }
            JsonAdapter<Object> adapter = this.jsonAdapters.get(labelIndex);
            writer.beginObject();
            writer.name(this.labelKey).value(this.labels.get(labelIndex));
            int flattenToken = writer.beginFlatten();
            adapter.toJson(writer, value);
            writer.endFlatten(flattenToken);
            writer.endObject();
        }

        public String toString() {
            return "PolymorphicJsonAdapter(" + this.labelKey + ")";
        }
    }
}

