/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;

final class RuntimeJsonAdapterFactory<T>
implements JsonAdapter.Factory {
    final Class<T> baseType;
    final String labelKey;
    final Map<String, Type> labelToType = new LinkedHashMap<String, Type>();

    @CheckReturnValue
    public static <T> RuntimeJsonAdapterFactory<T> of(Class<T> baseType, String labelKey) {
        if (baseType == null) {
            throw new NullPointerException("baseType == null");
        }
        if (labelKey == null) {
            throw new NullPointerException("labelKey == null");
        }
        if (baseType == Object.class) {
            throw new IllegalArgumentException("The base type must not be Object. Consider using a marker interface.");
        }
        return new RuntimeJsonAdapterFactory<T>(baseType, labelKey);
    }

    RuntimeJsonAdapterFactory(Class<T> baseType, String labelKey) {
        this.baseType = baseType;
        this.labelKey = labelKey;
    }

    public RuntimeJsonAdapterFactory<T> registerSubtype(Class<? extends T> subtype, String label) {
        if (subtype == null) {
            throw new NullPointerException("subtype == null");
        }
        if (label == null) {
            throw new NullPointerException("label == null");
        }
        if (this.labelToType.containsKey(label) || this.labelToType.containsValue(subtype)) {
            throw new IllegalArgumentException("Subtypes and labels must be unique.");
        }
        this.labelToType.put(label, subtype);
        return this;
    }

    public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        if (Types.getRawType((Type)type) != this.baseType || !annotations.isEmpty()) {
            return null;
        }
        int size = this.labelToType.size();
        LinkedHashMap<String, JsonAdapter<Object>> labelToAdapter = new LinkedHashMap<String, JsonAdapter<Object>>(size);
        LinkedHashMap<Type, String> typeToLabel = new LinkedHashMap<Type, String>(size);
        for (Map.Entry<String, Type> entry : this.labelToType.entrySet()) {
            String label = entry.getKey();
            Type typeValue = entry.getValue();
            typeToLabel.put(typeValue, label);
            labelToAdapter.put(label, (JsonAdapter<Object>)moshi.adapter(typeValue));
        }
        JsonAdapter objectJsonAdapter = moshi.adapter(Object.class);
        return new RuntimeJsonAdapter(this.labelKey, labelToAdapter, typeToLabel, (JsonAdapter<Object>)objectJsonAdapter).nullSafe();
    }

    static final class RuntimeJsonAdapter
    extends JsonAdapter<Object> {
        final String labelKey;
        final Map<String, JsonAdapter<Object>> labelToAdapter;
        final Map<Type, String> typeToLabel;
        final JsonAdapter<Object> objectJsonAdapter;

        RuntimeJsonAdapter(String labelKey, Map<String, JsonAdapter<Object>> labelToAdapter, Map<Type, String> typeToLabel, JsonAdapter<Object> objectJsonAdapter) {
            this.labelKey = labelKey;
            this.labelToAdapter = labelToAdapter;
            this.typeToLabel = typeToLabel;
            this.objectJsonAdapter = objectJsonAdapter;
        }

        public Object fromJson(JsonReader reader) throws IOException {
            JsonReader.Token peekedToken = reader.peek();
            if (peekedToken != JsonReader.Token.BEGIN_OBJECT) {
                throw new JsonDataException("Expected BEGIN_OBJECT but was " + peekedToken + " at path " + reader.getPath());
            }
            Object jsonValue = reader.readJsonValue();
            Map jsonObject = (Map)jsonValue;
            Object label = jsonObject.get(this.labelKey);
            if (label == null) {
                throw new JsonDataException("Missing label for " + this.labelKey);
            }
            if (!(label instanceof String)) {
                throw new JsonDataException("Label for '" + this.labelKey + "' must be a string but was " + label + ", a " + label.getClass());
            }
            JsonAdapter<Object> adapter = this.labelToAdapter.get(label);
            if (adapter == null) {
                throw new JsonDataException("Expected one of " + this.labelToAdapter.keySet() + " for key '" + this.labelKey + "' but found '" + label + "'. Register a subtype for this label.");
            }
            return adapter.fromJsonValue(jsonValue);
        }

        public void toJson(JsonWriter writer, Object value) throws IOException {
            Class<?> type = value.getClass();
            String label = this.typeToLabel.get(type);
            if (label == null) {
                throw new IllegalArgumentException("Expected one of " + this.typeToLabel.keySet() + " but found " + value + ", a " + value.getClass() + ". Register this subtype.");
            }
            JsonAdapter<Object> adapter = this.labelToAdapter.get(label);
            Map jsonValue = (Map)adapter.toJsonValue(value);
            LinkedHashMap<String, String> valueWithLabel = new LinkedHashMap<String, String>(1 + jsonValue.size());
            valueWithLabel.put(this.labelKey, label);
            valueWithLabel.putAll(jsonValue);
            this.objectJsonAdapter.toJson(writer, valueWithLabel);
        }

        public String toString() {
            return "RuntimeJsonAdapter(" + this.labelKey + ")";
        }
    }
}

