/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.GcRoot;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.HprofRecord;
import shark.IgnoredReferenceMatcher;
import shark.LeakTraceReference;
import shark.LibraryLeakReferenceMatcher;
import shark.OnAnalysisProgressListener;
import shark.PrimitiveType;
import shark.ReferenceMatcher;
import shark.ReferencePattern;
import shark.ValueHolder;
import shark.internal.DominatorTree;
import shark.internal.FieldIdReader;
import shark.internal.PathFinder;
import shark.internal.PathFinderKt;
import shark.internal.ReferencePathNode;
import shark.internal.hppc.LongScatterSet;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0004:;<=B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u0007H\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007*\u00020\u00132\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0014\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\f\u0010&\u001a\u00020\"*\u00020#H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020#H\u0002J\u0014\u0010'\u001a\u00020\u0011*\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0002J\f\u0010*\u001a\u00020%*\u00020#H\u0002J \u0010+\u001a\b\u0012\u0004\u0012\u00020-0,*\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0002J\u0012\u00100\u001a\u000201*\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001c\u00102\u001a\u00020\"*\u00020#2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020%H\u0002J\u001c\u00105\u001a\u00020\"*\u00020#2\u0006\u00106\u001a\u00020.2\u0006\u00104\u001a\u00020%H\u0002J\u001c\u00107\u001a\u00020\"*\u00020#2\u0006\u00108\u001a\u0002092\u0006\u00104\u001a\u00020%H\u0002R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lshark/internal/PathFinder;", "", "graph", "Lshark/HeapGraph;", "listener", "Lshark/OnAnalysisProgressListener;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "(Lshark/HeapGraph;Lshark/OnAnalysisProgressListener;Ljava/util/List;)V", "fieldNameByClassName", "", "", "jniGlobalReferenceMatchers", "staticFieldNameByClassName", "threadNameReferenceMatchers", "determineSizeOfObjectInstances", "", "objectClass", "Lshark/HeapObject$HeapClass;", "findPathsFromGcRoots", "Lshark/internal/PathFinder$PathFindingResults;", "leakingObjectIds", "", "", "computeRetainedHeapSize", "", "sortedGcRoots", "Lkotlin/Pair;", "Lshark/HeapObject;", "Lshark/GcRoot;", "classHierarchyWithoutJavaLangObject", "javaLangObjectId", "enqueue", "", "Lshark/internal/PathFinder$State;", "node", "Lshark/internal/ReferencePathNode;", "enqueueGcRoots", "getRecordSize", "field", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord$FieldRecord;", "poll", "readAllNonNullFieldsOfReferenceType", "", "Lshark/internal/PathFinder$InstanceRefField;", "Lshark/HeapObject$HeapInstance;", "classHierarchy", "toLongScatterSet", "Lshark/internal/hppc/LongScatterSet;", "visitClassRecord", "heapClass", "parent", "visitInstance", "instance", "visitObjectArray", "objectArray", "Lshark/HeapObject$HeapObjectArray;", "InstanceRefField", "PathFindingResults", "State", "VisitTracker", "shark"})
public final class PathFinder {
    private final Map<String, Map<String, ReferenceMatcher>> fieldNameByClassName;
    private final Map<String, Map<String, ReferenceMatcher>> staticFieldNameByClassName;
    private final Map<String, ReferenceMatcher> threadNameReferenceMatchers;
    private final Map<String, ReferenceMatcher> jniGlobalReferenceMatchers;
    private final HeapGraph graph;
    private final OnAnalysisProgressListener listener;

    @NotNull
    public final PathFindingResults findPathsFromGcRoots(@NotNull Set<Long> leakingObjectIds, boolean computeRetainedHeapSize) {
        Intrinsics.checkParameterIsNotNull(leakingObjectIds, (String)"leakingObjectIds");
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_PATHS_TO_RETAINED_OBJECTS);
        HeapObject.HeapClass objectClass = this.graph.findClassByName("java.lang.Object");
        int sizeOfObjectInstances = this.determineSizeOfObjectInstances(objectClass, this.graph);
        HeapObject.HeapClass heapClass = objectClass;
        long javaLangObjectId = heapClass != null ? heapClass.getObjectId() : -1L;
        int estimatedVisitedObjects = RangesKt.coerceAtLeast((int)(this.graph.getInstanceCount() / 2), (int)4);
        State state = new State(this.toLongScatterSet(leakingObjectIds), sizeOfObjectInstances, computeRetainedHeapSize, javaLangObjectId, estimatedVisitedObjects);
        return this.findPathsFromGcRoots(state);
    }

    private final int determineSizeOfObjectInstances(HeapObject.HeapClass objectClass, HeapGraph graph) {
        int sizeOfObjectOnArt;
        int objectClassFieldSize;
        return objectClass != null ? ((objectClassFieldSize = objectClass.readFieldsByteSize()) == (sizeOfObjectOnArt = graph.getIdentifierByteSize() + PrimitiveType.INT.getByteSize()) ? sizeOfObjectOnArt : 0) : 0;
    }

    private final LongScatterSet toLongScatterSet(Set<Long> $this$toLongScatterSet) {
        LongScatterSet longScatterSet = new LongScatterSet(0, 1, null);
        longScatterSet.ensureCapacity($this$toLongScatterSet.size());
        Iterable $this$forEach$iv = $this$toLongScatterSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            longScatterSet.add(it);
        }
        return longScatterSet;
    }

    private final PathFindingResults findPathsFromGcRoots(State $this$findPathsFromGcRoots) {
        this.enqueueGcRoots($this$findPathsFromGcRoots);
        boolean bl = false;
        List shortestPathsToLeakingObjects = new ArrayList();
        while ($this$findPathsFromGcRoots.getQueuesNotEmpty()) {
            HeapObject heapObject;
            ReferencePathNode node = this.poll($this$findPathsFromGcRoots);
            if ($this$findPathsFromGcRoots.getLeakingObjectIds().contains(node.getObjectId())) {
                shortestPathsToLeakingObjects.add(node);
                if (shortestPathsToLeakingObjects.size() == $this$findPathsFromGcRoots.getLeakingObjectIds().size()) {
                    if (!$this$findPathsFromGcRoots.getComputeRetainedHeapSize()) break;
                    this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_DOMINATORS);
                }
            }
            if ((heapObject = this.graph.findObjectById(node.getObjectId())) instanceof HeapObject.HeapClass) {
                this.visitClassRecord($this$findPathsFromGcRoots, (HeapObject.HeapClass)heapObject, node);
                continue;
            }
            if (heapObject instanceof HeapObject.HeapInstance) {
                this.visitInstance($this$findPathsFromGcRoots, (HeapObject.HeapInstance)heapObject, node);
                continue;
            }
            if (!(heapObject instanceof HeapObject.HeapObjectArray)) continue;
            this.visitObjectArray($this$findPathsFromGcRoots, (HeapObject.HeapObjectArray)heapObject, node);
        }
        return new PathFindingResults(shortestPathsToLeakingObjects, $this$findPathsFromGcRoots.getVisitTracker() instanceof VisitTracker.Dominated ? ((VisitTracker.Dominated)$this$findPathsFromGcRoots.getVisitTracker()).getDominatorTree() : null);
    }

    private final ReferencePathNode poll(State $this$poll) {
        ReferencePathNode referencePathNode;
        if (!$this$poll.getVisitingLast() && !$this$poll.getToVisitQueue().isEmpty()) {
            ReferencePathNode removedNode = $this$poll.getToVisitQueue().poll();
            $this$poll.getToVisitSet().remove(removedNode.getObjectId());
            ReferencePathNode referencePathNode2 = removedNode;
            referencePathNode = referencePathNode2;
            Intrinsics.checkExpressionValueIsNotNull((Object)referencePathNode2, (String)"removedNode");
        } else {
            $this$poll.setVisitingLast(true);
            ReferencePathNode removedNode = $this$poll.getToVisitLastQueue().poll();
            $this$poll.getToVisitLastSet().remove(removedNode.getObjectId());
            ReferencePathNode referencePathNode3 = removedNode;
            referencePathNode = referencePathNode3;
            Intrinsics.checkExpressionValueIsNotNull((Object)referencePathNode3, (String)"removedNode");
        }
        return referencePathNode;
    }

    /*
     * WARNING - void declaration
     */
    private final void enqueueGcRoots(State $this$enqueueGcRoots) {
        List<Pair<HeapObject, GcRoot>> gcRoots = this.sortedGcRoots();
        boolean bl = false;
        Map threadNames = new LinkedHashMap();
        boolean bl2 = false;
        Map threadsBySerialNumber = new LinkedHashMap();
        Iterable $this$forEach$iv = gcRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject.HeapInstance heapInstance;
            void objectRecord;
            Pair $dstr$objectRecord$gcRoot = (Pair)element$iv;
            boolean bl3 = false;
            HeapObject heapObject = (HeapObject)$dstr$objectRecord$gcRoot.component1();
            GcRoot gcRoot = (GcRoot)$dstr$objectRecord$gcRoot.component2();
            GcRoot gcRoot2 = gcRoot;
            if (gcRoot2 instanceof GcRoot.ThreadObject) {
                Integer n = ((GcRoot.ThreadObject)gcRoot).getThreadSerialNumber();
                HeapObject.HeapInstance heapInstance2 = objectRecord.getAsInstance();
                if (heapInstance2 == null) {
                    Intrinsics.throwNpe();
                }
                threadsBySerialNumber.put(n, TuplesKt.to((Object)heapInstance2, (Object)gcRoot));
                this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot.getId(), gcRoot));
                continue;
            }
            if (gcRoot2 instanceof GcRoot.JavaFrame) {
                String threadName;
                ReferenceMatcher referenceMatcher;
                void threadInstance;
                Pair threadPair = (Pair)threadsBySerialNumber.get(((GcRoot.JavaFrame)gcRoot).getThreadSerialNumber());
                if (threadPair == null) {
                    this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot.getId(), gcRoot));
                    continue;
                }
                Pair pair = threadPair;
                heapInstance = (HeapObject.HeapInstance)pair.component1();
                GcRoot.ThreadObject threadRoot = (GcRoot.ThreadObject)pair.component2();
                String string = (String)threadNames.get(threadInstance);
                if (string == null) {
                    string = (String)((Function0)new Function0<String>((HeapObject.HeapInstance)threadInstance, this, $this$enqueueGcRoots, threadsBySerialNumber, threadNames){
                        final /* synthetic */ HeapObject.HeapInstance $threadInstance;
                        final /* synthetic */ PathFinder this$0;
                        final /* synthetic */ State $this_enqueueGcRoots$inlined;
                        final /* synthetic */ Map $threadsBySerialNumber$inlined;
                        final /* synthetic */ Map $threadNames$inlined;
                        {
                            this.$threadInstance = heapInstance;
                            this.this$0 = pathFinder;
                            this.$this_enqueueGcRoots$inlined = state;
                            this.$threadsBySerialNumber$inlined = map;
                            this.$threadNames$inlined = map2;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final String invoke() {
                            void var1_1;
                            Object object = this.$threadInstance.get(Reflection.getOrCreateKotlinClass(Thread.class), "name");
                            if (object == null || (object = object.getValue()) == null || (object = object.readAsJavaString()) == null) {
                                object = "";
                            }
                            Object name = object;
                            this.$threadNames$inlined.put(this.$threadInstance, name);
                            return var1_1;
                        }
                    }).invoke();
                }
                if ((referenceMatcher = this.threadNameReferenceMatchers.get(threadName = string)) instanceof IgnoredReferenceMatcher) continue;
                ReferencePathNode.RootNode.NormalRootNode rootNode = new ReferencePathNode.RootNode.NormalRootNode(threadRoot.getId(), gcRoot);
                LeakTraceReference.ReferenceType refFromParentType = LeakTraceReference.ReferenceType.LOCAL;
                String refFromParentName = "";
                ReferencePathNode.ChildNode childNode2 = referenceMatcher instanceof LibraryLeakReferenceMatcher ? (ReferencePathNode.ChildNode)new ReferencePathNode.ChildNode.LibraryLeakChildNode(gcRoot.getId(), rootNode, refFromParentType, refFromParentName, (LibraryLeakReferenceMatcher)referenceMatcher, 0L, 32, null) : (ReferencePathNode.ChildNode)new ReferencePathNode.ChildNode.NormalNode(gcRoot.getId(), rootNode, refFromParentType, refFromParentName, 0L, 16, null);
                this.enqueue($this$enqueueGcRoots, childNode2);
                continue;
            }
            if (gcRoot2 instanceof GcRoot.JniGlobal) {
                ReferenceMatcher referenceMatcher;
                ReferenceMatcher referenceMatcher2;
                heapInstance = objectRecord;
                if (heapInstance instanceof HeapObject.HeapClass) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapClass)objectRecord).getName());
                } else if (heapInstance instanceof HeapObject.HeapInstance) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapInstance)objectRecord).getInstanceClassName());
                } else if (heapInstance instanceof HeapObject.HeapObjectArray) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapObjectArray)objectRecord).getArrayClassName());
                } else if (heapInstance instanceof HeapObject.HeapPrimitiveArray) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapPrimitiveArray)objectRecord).getArrayClassName());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((referenceMatcher = referenceMatcher2) instanceof IgnoredReferenceMatcher) continue;
                if (referenceMatcher instanceof LibraryLeakReferenceMatcher) {
                    this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.LibraryLeakRootNode(gcRoot.getId(), gcRoot, (LibraryLeakReferenceMatcher)referenceMatcher));
                    continue;
                }
                this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot.getId(), gcRoot));
                continue;
            }
            this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot.getId(), gcRoot));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<HeapObject, GcRoot>> sortedGcRoots() {
        void $this$mapTo$iv$iv;
        GcRoot gcRoot;
        Iterable $this$filterTo$iv$iv;
        Function1 rootClassName2 = sortedGcRoots.rootClassName.1.INSTANCE;
        Iterable $this$filter$iv = this.graph.getGcRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            gcRoot = (GcRoot)element$iv$iv;
            boolean bl = false;
            if (!this.graph.objectExists(gcRoot.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            gcRoot = (GcRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)this.graph.findObjectById(it.getId()), (Object)it);
            collection.add(pair);
        }
        return CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator<Pair<? extends HeapObject, ? extends GcRoot>>(rootClassName2){
            final /* synthetic */ Function1 $rootClassName;

            /*
             * WARNING - void declaration
             */
            public final int compare(Pair<? extends HeapObject, ? extends GcRoot> $dstr$graphObject1$root1, Pair<? extends HeapObject, ? extends GcRoot> $dstr$graphObject2$root2) {
                void graphObject2;
                void graphObject1;
                HeapObject heapObject = (HeapObject)$dstr$graphObject1$root1.component1();
                GcRoot root1 = (GcRoot)$dstr$graphObject1$root1.component2();
                HeapObject heapObject2 = (HeapObject)$dstr$graphObject2$root2.component1();
                GcRoot root2 = (GcRoot)$dstr$graphObject2$root2.component2();
                String string = root2.getClass().getName();
                String string2 = root1.getClass().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"root1::class.java.name");
                int gcRootTypeComparison = string.compareTo(string2);
                return gcRootTypeComparison != 0 ? gcRootTypeComparison : ((String)this.$rootClassName.invoke((Object)graphObject1)).compareTo((String)this.$rootClassName.invoke((Object)graphObject2));
            }
            {
                this.$rootClassName = function1;
            }
        });
    }

    private final void visitClassRecord(State $this$visitClassRecord, HeapObject.HeapClass heapClass, ReferencePathNode parent) {
        Map map = this.staticFieldNameByClassName.get(heapClass.getName());
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map ignoredStaticFields = map;
        for (HeapField staticField : heapClass.readStaticFields()) {
            ReferencePathNode.ChildNode node;
            ReferencePathNode.ChildNode childNode2;
            String fieldName;
            if (!staticField.getValue().isNonNullReference() || Intrinsics.areEqual((Object)(fieldName = staticField.getName()), (Object)"$staticOverhead") || Intrinsics.areEqual((Object)fieldName, (Object)"$classOverhead")) continue;
            ValueHolder valueHolder = staticField.getValue().getHolder();
            if (valueHolder == null) {
                throw new TypeCastException("null cannot be cast to non-null type shark.ValueHolder.ReferenceHolder");
            }
            long objectId = ((ValueHolder.ReferenceHolder)valueHolder).getValue();
            ReferenceMatcher referenceMatcher = (ReferenceMatcher)ignoredStaticFields.get(fieldName);
            if (referenceMatcher == null) {
                childNode2 = new ReferencePathNode.ChildNode.NormalNode(objectId, parent, LeakTraceReference.ReferenceType.STATIC_FIELD, fieldName, 0L, 16, null);
            } else if (referenceMatcher instanceof LibraryLeakReferenceMatcher) {
                childNode2 = new ReferencePathNode.ChildNode.LibraryLeakChildNode(objectId, parent, LeakTraceReference.ReferenceType.STATIC_FIELD, fieldName, (LibraryLeakReferenceMatcher)referenceMatcher, 0L, 32, null);
            } else if (referenceMatcher instanceof IgnoredReferenceMatcher) {
                childNode2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if ((node = childNode2) == null) continue;
            this.enqueue($this$visitClassRecord, node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitInstance(State $this$visitInstance, HeapObject.HeapInstance instance, ReferencePathNode parent) {
        List<InstanceRefField> fieldNamesAndValues;
        Map<String, ReferenceMatcher> referenceMatcherByField;
        boolean bl;
        LinkedHashMap fieldReferenceMatchers = new LinkedHashMap();
        Sequence $this$forEach$iv = instance.getInstanceClass().getClassHierarchy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject.HeapClass it = (HeapObject.HeapClass)element$iv;
            bl = false;
            referenceMatcherByField = this.fieldNameByClassName.get(it.getName());
            if (referenceMatcherByField == null) continue;
            Object object = referenceMatcherByField;
            boolean bl2 = false;
            Iterator<Map.Entry<String, ReferenceMatcher>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void fieldName;
                Map.Entry<String, ReferenceMatcher> entry;
                Map.Entry<String, ReferenceMatcher> entry2 = entry = iterator.next();
                boolean bl3 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl3 = false;
                ReferenceMatcher referenceMatcher = entry2.getValue();
                if (fieldReferenceMatchers.containsKey(fieldName)) continue;
                ((Map)fieldReferenceMatchers).put(fieldName, referenceMatcher);
            }
        }
        List<HeapObject.HeapClass> classHierarchy = this.classHierarchyWithoutJavaLangObject(instance.getInstanceClass(), $this$visitInstance.getJavaLangObjectId());
        List<InstanceRefField> $this$sortBy$iv = fieldNamesAndValues = this.readAllNonNullFieldsOfReferenceType(instance, classHierarchy);
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            List<InstanceRefField> list = $this$sortBy$iv;
            bl = false;
            referenceMatcherByField = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    InstanceRefField it = (InstanceRefField)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getFieldName());
                    it = (InstanceRefField)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getFieldName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)((Object)referenceMatcherByField));
        }
        Iterable $this$forEach$iv2 = fieldNamesAndValues;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ReferencePathNode.ChildNode node;
            ReferencePathNode.ChildNode childNode2;
            InstanceRefField instanceRefField = (InstanceRefField)element$iv;
            boolean bl4 = false;
            ReferenceMatcher referenceMatcher = (ReferenceMatcher)fieldReferenceMatchers.get(instanceRefField.getFieldName());
            if (referenceMatcher == null) {
                childNode2 = new ReferencePathNode.ChildNode.NormalNode(instanceRefField.getRefObjectId(), parent, LeakTraceReference.ReferenceType.INSTANCE_FIELD, instanceRefField.getFieldName(), instanceRefField.getDeclaringClassId());
            } else if (referenceMatcher instanceof LibraryLeakReferenceMatcher) {
                childNode2 = new ReferencePathNode.ChildNode.LibraryLeakChildNode(instanceRefField.getRefObjectId(), parent, LeakTraceReference.ReferenceType.INSTANCE_FIELD, instanceRefField.getFieldName(), (LibraryLeakReferenceMatcher)referenceMatcher, instanceRefField.getDeclaringClassId());
            } else if (referenceMatcher instanceof IgnoredReferenceMatcher) {
                childNode2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if ((node = childNode2) == null) continue;
            this.enqueue($this$visitInstance, node);
        }
    }

    private final List<InstanceRefField> readAllNonNullFieldsOfReferenceType(HeapObject.HeapInstance $this$readAllNonNullFieldsOfReferenceType, List<HeapObject.HeapClass> classHierarchy) {
        HeapGraph hprofGraph = $this$readAllNonNullFieldsOfReferenceType.getGraph();
        FieldIdReader fieldReader = null;
        boolean bl = false;
        List result = new ArrayList();
        int skipBytesCount = 0;
        for (HeapObject.HeapClass heapClass : classHierarchy) {
            for (HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord fieldRecord : heapClass.readRecordFields()) {
                if (fieldRecord.getType() != 2) {
                    skipBytesCount += this.getRecordSize(hprofGraph, fieldRecord);
                    continue;
                }
                if (fieldReader == null) {
                    fieldReader = new FieldIdReader($this$readAllNonNullFieldsOfReferenceType.readRecord(), hprofGraph.getIdentifierByteSize());
                }
                fieldReader.skipBytes(skipBytesCount);
                skipBytesCount = 0;
                long objectId = fieldReader.readId();
                if (objectId == 0L) continue;
                result.add(new InstanceRefField(heapClass.getObjectId(), objectId, heapClass.instanceFieldName(fieldRecord)));
            }
        }
        return result;
    }

    private final List<HeapObject.HeapClass> classHierarchyWithoutJavaLangObject(HeapObject.HeapClass $this$classHierarchyWithoutJavaLangObject, long javaLangObjectId) {
        boolean bl = false;
        List result = new ArrayList();
        for (HeapObject.HeapClass parent = $this$classHierarchyWithoutJavaLangObject; parent != null && parent.getObjectId() != javaLangObjectId; parent = parent.getSuperclass()) {
            Collection collection = result;
            boolean bl2 = false;
            collection.add(parent);
        }
        return result;
    }

    private final int getRecordSize(HeapGraph $this$getRecordSize, HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord field) {
        int n;
        int n2 = field.getType();
        if (n2 == 2) {
            n = $this$getRecordSize.getIdentifierByteSize();
        } else if (n2 == PrimitiveType.BOOLEAN.getHprofType()) {
            n = 1;
        } else if (n2 == PrimitiveType.CHAR.getHprofType()) {
            n = 2;
        } else if (n2 == PrimitiveType.FLOAT.getHprofType()) {
            n = 4;
        } else if (n2 == PrimitiveType.DOUBLE.getHprofType()) {
            n = 8;
        } else if (n2 == PrimitiveType.BYTE.getHprofType()) {
            n = 1;
        } else if (n2 == PrimitiveType.SHORT.getHprofType()) {
            n = 2;
        } else if (n2 == PrimitiveType.INT.getHprofType()) {
            n = 4;
        } else if (n2 == PrimitiveType.LONG.getHprofType()) {
            n = 8;
        } else {
            throw (Throwable)new IllegalStateException("Unknown type " + field.getType());
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final void visitObjectArray(State $this$visitObjectArray, HeapObject.HeapObjectArray objectArray, ReferencePathNode parent) {
        void $this$filterTo$iv$iv;
        HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord record = objectArray.readRecord();
        long[] $this$filter$iv = record.getElementIds();
        boolean $i$f$filter = false;
        long[] lArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (long element$iv$iv : $this$filterTo$iv$iv) {
            void objectId = element$iv$iv;
            boolean bl = false;
            if (!(objectId != 0L && this.graph.objectExists((long)objectId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonNullElementIds = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = nonNullElementIds;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void elementId;
            long element$iv$iv;
            int n = index$iv++;
            int n2 = 0;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n;
            element$iv$iv = ((Number)item$iv).longValue();
            int index = n3;
            boolean bl = false;
            String name = String.valueOf(index);
            this.enqueue($this$visitObjectArray, new ReferencePathNode.ChildNode.NormalNode((long)elementId, parent, LeakTraceReference.ReferenceType.ARRAY_ENTRY, name, 0L, 16, null));
        }
    }

    private final void enqueue(State $this$enqueue, ReferencePathNode node) {
        long l;
        boolean visitLast;
        if (node.getObjectId() == 0L) {
            return;
        }
        boolean bl = visitLast = $this$enqueue.getVisitingLast() || node instanceof ReferencePathNode.LibraryLeakNode || node instanceof ReferencePathNode.RootNode && ((ReferencePathNode.RootNode)node).getGcRoot() instanceof GcRoot.ThreadObject || node instanceof ReferencePathNode.ChildNode.NormalNode && ((ReferencePathNode.ChildNode.NormalNode)node).getParent() instanceof ReferencePathNode.RootNode && ((ReferencePathNode.RootNode)((ReferencePathNode.ChildNode.NormalNode)node).getParent()).getGcRoot() instanceof GcRoot.JavaFrame;
        if (node instanceof ReferencePathNode.RootNode) {
            l = 0L;
        } else {
            ReferencePathNode referencePathNode = node;
            if (referencePathNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type shark.internal.ReferencePathNode.ChildNode");
            }
            l = ((ReferencePathNode.ChildNode)referencePathNode).getParent().getObjectId();
        }
        long parentObjectId = l;
        boolean alreadyEnqueued = $this$enqueue.getVisitTracker().visited(node.getObjectId(), parentObjectId);
        if (alreadyEnqueued) {
            if (visitLast) {
                return;
            }
            if ($this$enqueue.getToVisitSet().contains(node.getObjectId())) {
                return;
            }
            if (!$this$enqueue.getToVisitLastSet().contains(node.getObjectId())) {
                return;
            }
        }
        if (alreadyEnqueued) {
            Object element$iv2;
            block29: {
                $this$enqueue.getToVisitQueue().add(node);
                $this$enqueue.getToVisitSet().add(node.getObjectId());
                Iterable $this$first$iv = $this$enqueue.getToVisitLastQueue();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ReferencePathNode it = (ReferencePathNode)element$iv2;
                    boolean bl2 = false;
                    if (!(it.getObjectId() == node.getObjectId())) continue;
                    break block29;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ReferencePathNode nodeToRemove = (ReferencePathNode)element$iv2;
            $this$enqueue.getToVisitLastQueue().remove(nodeToRemove);
            $this$enqueue.getToVisitLastSet().remove(node.getObjectId());
            return;
        }
        boolean isLeakingObject = $this$enqueue.getLeakingObjectIds().contains(node.getObjectId());
        if (!isLeakingObject) {
            boolean bl3;
            HeapObject graphObject = this.graph.findObjectById(node.getObjectId());
            if (graphObject instanceof HeapObject.HeapClass) {
                bl3 = false;
            } else if (graphObject instanceof HeapObject.HeapInstance) {
                if (((HeapObject.HeapInstance)graphObject).isPrimitiveWrapper()) {
                    bl3 = true;
                } else if (Intrinsics.areEqual((Object)((HeapObject.HeapInstance)graphObject).getInstanceClassName(), (Object)"java.lang.String")) {
                    bl3 = true;
                } else if (((HeapObject.HeapInstance)graphObject).getInstanceClass().getInstanceByteSize() <= $this$enqueue.getSizeOfObjectInstances()) {
                    bl3 = true;
                } else {
                    boolean bl4;
                    block30: {
                        Sequence $this$all$iv = ((HeapObject.HeapInstance)graphObject).getInstanceClass().getClassHierarchy();
                        boolean $i$f$all = false;
                        for (Object element$iv : $this$all$iv) {
                            HeapObject.HeapClass heapClass = (HeapObject.HeapClass)element$iv;
                            boolean bl5 = false;
                            if (heapClass.getObjectId() == $this$enqueue.getJavaLangObjectId() || !heapClass.getHasReferenceInstanceFields()) continue;
                            bl4 = false;
                            break block30;
                        }
                        bl4 = true;
                    }
                    bl3 = bl4;
                }
            } else if (graphObject instanceof HeapObject.HeapObjectArray) {
                bl3 = PathFinderKt.isSkippablePrimitiveWrapperArray((HeapObject.HeapObjectArray)graphObject);
            } else if (graphObject instanceof HeapObject.HeapPrimitiveArray) {
                bl3 = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean skip = bl3;
            if (skip) {
                return;
            }
        }
        if (visitLast) {
            $this$enqueue.getToVisitLastQueue().add(node);
            $this$enqueue.getToVisitLastSet().add(node.getObjectId());
        } else {
            $this$enqueue.getToVisitQueue().add(node);
            $this$enqueue.getToVisitSet().add(node.getObjectId());
        }
    }

    /*
     * WARNING - void declaration
     */
    public PathFinder(@NotNull HeapGraph graph, @NotNull OnAnalysisProgressListener listener, @NotNull List<? extends ReferenceMatcher> referenceMatchers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        this.graph = graph;
        this.listener = listener;
        boolean bl = false;
        Map fieldNameByClassName = new LinkedHashMap();
        boolean bl2 = false;
        Map staticFieldNameByClassName = new LinkedHashMap();
        boolean bl3 = false;
        Map threadNames = new LinkedHashMap();
        boolean bl4 = false;
        Map jniGlobals = new LinkedHashMap();
        Iterable $this$filter$iv = referenceMatchers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReferenceMatcher it = (ReferenceMatcher)element$iv$iv;
            boolean bl5 = false;
            if (!(it instanceof IgnoredReferenceMatcher || it instanceof LibraryLeakReferenceMatcher && (Boolean)((LibraryLeakReferenceMatcher)it).getPatternApplies().invoke((Object)this.graph) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List appliedRefMatchers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = appliedRefMatchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map;
            Map newMap;
            boolean bl6;
            Map mapOrNull;
            ReferenceMatcher referenceMatcher = (ReferenceMatcher)element$iv;
            boolean bl7 = false;
            ReferencePattern pattern = referenceMatcher.getPattern();
            if (pattern instanceof ReferencePattern.JavaLocalPattern) {
                threadNames.put(((ReferencePattern.JavaLocalPattern)pattern).getThreadName(), referenceMatcher);
                continue;
            }
            if (pattern instanceof ReferencePattern.StaticFieldPattern) {
                Map map2;
                mapOrNull = (Map)staticFieldNameByClassName.get(((ReferencePattern.StaticFieldPattern)pattern).getClassName());
                if (mapOrNull != null) {
                    map2 = mapOrNull;
                } else {
                    bl6 = false;
                    newMap = new LinkedHashMap();
                    staticFieldNameByClassName.put(((ReferencePattern.StaticFieldPattern)pattern).getClassName(), newMap);
                    map2 = newMap;
                }
                map = map2;
                map.put(((ReferencePattern.StaticFieldPattern)pattern).getFieldName(), referenceMatcher);
                continue;
            }
            if (pattern instanceof ReferencePattern.InstanceFieldPattern) {
                Map map3;
                mapOrNull = (Map)fieldNameByClassName.get(((ReferencePattern.InstanceFieldPattern)pattern).getClassName());
                if (mapOrNull != null) {
                    map3 = mapOrNull;
                } else {
                    bl6 = false;
                    newMap = new LinkedHashMap();
                    fieldNameByClassName.put(((ReferencePattern.InstanceFieldPattern)pattern).getClassName(), newMap);
                    map3 = newMap;
                }
                map = map3;
                map.put(((ReferencePattern.InstanceFieldPattern)pattern).getFieldName(), referenceMatcher);
                continue;
            }
            if (!(pattern instanceof ReferencePattern.NativeGlobalVariablePattern)) continue;
            jniGlobals.put(((ReferencePattern.NativeGlobalVariablePattern)pattern).getClassName(), referenceMatcher);
        }
        this.fieldNameByClassName = fieldNameByClassName;
        this.staticFieldNameByClassName = staticFieldNameByClassName;
        this.threadNameReferenceMatchers = threadNames;
        this.jniGlobalReferenceMatchers = jniGlobals;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lshark/internal/PathFinder$PathFindingResults;", "", "pathsToLeakingObjects", "", "Lshark/internal/ReferencePathNode;", "dominatorTree", "Lshark/internal/DominatorTree;", "(Ljava/util/List;Lshark/internal/DominatorTree;)V", "getDominatorTree", "()Lshark/internal/DominatorTree;", "getPathsToLeakingObjects", "()Ljava/util/List;", "shark"})
    public static final class PathFindingResults {
        @NotNull
        private final List<ReferencePathNode> pathsToLeakingObjects;
        @Nullable
        private final DominatorTree dominatorTree;

        @NotNull
        public final List<ReferencePathNode> getPathsToLeakingObjects() {
            return this.pathsToLeakingObjects;
        }

        @Nullable
        public final DominatorTree getDominatorTree() {
            return this.dominatorTree;
        }

        public PathFindingResults(@NotNull List<? extends ReferencePathNode> pathsToLeakingObjects, @Nullable DominatorTree dominatorTree) {
            Intrinsics.checkParameterIsNotNull(pathsToLeakingObjects, (String)"pathsToLeakingObjects");
            this.pathsToLeakingObjects = pathsToLeakingObjects;
            this.dominatorTree = dominatorTree;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lshark/internal/PathFinder$VisitTracker;", "", "()V", "visited", "", "objectId", "", "parentObjectId", "Dominated", "Visited", "Lshark/internal/PathFinder$VisitTracker$Dominated;", "Lshark/internal/PathFinder$VisitTracker$Visited;", "shark"})
    public static abstract class VisitTracker {
        public abstract boolean visited(long var1, long var3);

        private VisitTracker() {
        }

        public /* synthetic */ VisitTracker(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lshark/internal/PathFinder$VisitTracker$Dominated;", "Lshark/internal/PathFinder$VisitTracker;", "expectedElements", "", "(I)V", "dominatorTree", "Lshark/internal/DominatorTree;", "getDominatorTree", "()Lshark/internal/DominatorTree;", "visited", "", "objectId", "", "parentObjectId", "shark"})
        public static final class Dominated
        extends VisitTracker {
            @NotNull
            private final DominatorTree dominatorTree;

            @NotNull
            public final DominatorTree getDominatorTree() {
                return this.dominatorTree;
            }

            @Override
            public boolean visited(long objectId, long parentObjectId) {
                return this.dominatorTree.updateDominated(objectId, parentObjectId);
            }

            public Dominated(int expectedElements) {
                super(null);
                this.dominatorTree = new DominatorTree(expectedElements);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lshark/internal/PathFinder$VisitTracker$Visited;", "Lshark/internal/PathFinder$VisitTracker;", "expectedElements", "", "(I)V", "visitedSet", "Lshark/internal/hppc/LongScatterSet;", "visited", "", "objectId", "", "parentObjectId", "shark"})
        public static final class Visited
        extends VisitTracker {
            private final LongScatterSet visitedSet;

            @Override
            public boolean visited(long objectId, long parentObjectId) {
                return !this.visitedSet.add(objectId);
            }

            public Visited(int expectedElements) {
                super(null);
                this.visitedSet = new LongScatterSet(expectedElements);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lshark/internal/PathFinder$State;", "", "leakingObjectIds", "Lshark/internal/hppc/LongScatterSet;", "sizeOfObjectInstances", "", "computeRetainedHeapSize", "", "javaLangObjectId", "", "estimatedVisitedObjects", "(Lshark/internal/hppc/LongScatterSet;IZJI)V", "getComputeRetainedHeapSize", "()Z", "getJavaLangObjectId", "()J", "getLeakingObjectIds", "()Lshark/internal/hppc/LongScatterSet;", "queuesNotEmpty", "getQueuesNotEmpty", "getSizeOfObjectInstances", "()I", "toVisitLastQueue", "Ljava/util/Deque;", "Lshark/internal/ReferencePathNode;", "getToVisitLastQueue", "()Ljava/util/Deque;", "toVisitLastSet", "getToVisitLastSet", "toVisitQueue", "getToVisitQueue", "toVisitSet", "getToVisitSet", "visitTracker", "Lshark/internal/PathFinder$VisitTracker;", "getVisitTracker", "()Lshark/internal/PathFinder$VisitTracker;", "visitingLast", "getVisitingLast", "setVisitingLast", "(Z)V", "shark"})
    private static final class State {
        @NotNull
        private final Deque<ReferencePathNode> toVisitQueue;
        @NotNull
        private final Deque<ReferencePathNode> toVisitLastQueue;
        @NotNull
        private final LongScatterSet toVisitSet;
        @NotNull
        private final LongScatterSet toVisitLastSet;
        @NotNull
        private final VisitTracker visitTracker;
        private boolean visitingLast;
        @NotNull
        private final LongScatterSet leakingObjectIds;
        private final int sizeOfObjectInstances;
        private final boolean computeRetainedHeapSize;
        private final long javaLangObjectId;

        @NotNull
        public final Deque<ReferencePathNode> getToVisitQueue() {
            return this.toVisitQueue;
        }

        @NotNull
        public final Deque<ReferencePathNode> getToVisitLastQueue() {
            return this.toVisitLastQueue;
        }

        @NotNull
        public final LongScatterSet getToVisitSet() {
            return this.toVisitSet;
        }

        @NotNull
        public final LongScatterSet getToVisitLastSet() {
            return this.toVisitLastSet;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean getQueuesNotEmpty() {
            Collection collection = this.toVisitQueue;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            collection = this.toVisitLastQueue;
            bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        @NotNull
        public final VisitTracker getVisitTracker() {
            return this.visitTracker;
        }

        public final boolean getVisitingLast() {
            return this.visitingLast;
        }

        public final void setVisitingLast(boolean bl) {
            this.visitingLast = bl;
        }

        @NotNull
        public final LongScatterSet getLeakingObjectIds() {
            return this.leakingObjectIds;
        }

        public final int getSizeOfObjectInstances() {
            return this.sizeOfObjectInstances;
        }

        public final boolean getComputeRetainedHeapSize() {
            return this.computeRetainedHeapSize;
        }

        public final long getJavaLangObjectId() {
            return this.javaLangObjectId;
        }

        public State(@NotNull LongScatterSet leakingObjectIds, int sizeOfObjectInstances, boolean computeRetainedHeapSize, long javaLangObjectId, int estimatedVisitedObjects) {
            Intrinsics.checkParameterIsNotNull((Object)leakingObjectIds, (String)"leakingObjectIds");
            this.leakingObjectIds = leakingObjectIds;
            this.sizeOfObjectInstances = sizeOfObjectInstances;
            this.computeRetainedHeapSize = computeRetainedHeapSize;
            this.javaLangObjectId = javaLangObjectId;
            this.toVisitQueue = new ArrayDeque();
            this.toVisitLastQueue = new ArrayDeque();
            this.toVisitSet = new LongScatterSet(0, 1, null);
            this.toVisitLastSet = new LongScatterSet(0, 1, null);
            this.visitTracker = this.computeRetainedHeapSize ? (VisitTracker)new VisitTracker.Dominated(estimatedVisitedObjects) : (VisitTracker)new VisitTracker.Visited(estimatedVisitedObjects);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lshark/internal/PathFinder$InstanceRefField;", "", "declaringClassId", "", "refObjectId", "fieldName", "", "(JJLjava/lang/String;)V", "getDeclaringClassId", "()J", "getFieldName", "()Ljava/lang/String;", "getRefObjectId", "shark"})
    private static final class InstanceRefField {
        private final long declaringClassId;
        private final long refObjectId;
        @NotNull
        private final String fieldName;

        public final long getDeclaringClassId() {
            return this.declaringClassId;
        }

        public final long getRefObjectId() {
            return this.refObjectId;
        }

        @NotNull
        public final String getFieldName() {
            return this.fieldName;
        }

        public InstanceRefField(long declaringClassId, long refObjectId, @NotNull String fieldName) {
            Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
            this.declaringClassId = declaringClassId;
            this.refObjectId = refObjectId;
            this.fieldName = fieldName;
        }
    }
}

